# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pydevts', 'pydevts.routers']

package_data = \
{'': ['*']}

install_requires = \
['anyio>=3.1.0,<4.0.0', 'msgpack>=1.0.2,<2.0.0', 'networkx>=2.5.1,<3.0.0']

setup_kwargs = {
    'name': 'pydevts',
    'version': '0.1.1',
    'description': 'PYDEVTS (PYthon Distributed EVenT System) is a distributed event system written in python and based on the concept of nodes that is designed for the implementation of data stores and other replicated systems.',
    'long_description': "# PYDEVTS\n\nPYDEVTS (Python Distributed EVenT System) is a distributed event system written in python and based on the concept of nodes that is designed for the implementation of data stores and other replicated systems.\n\nPYDEVTS is based upon a simple concept: A cluster of nodes that can send and receive events.\n\nPYDEVTS is also lightweight, requiring only [anyio](https://github.com/agronholm/anyio) although some examples may require additional libraries (these will be detailed in the examples description)\n\n\n## How do I use this?\n\nWhile more in-depth documentation will come in the future, currently there are several examples in the `examples/` folder.\n\nEach example takes some command line arguments, which are detailed below. But first, we must define a few terms.\n\n\n\n\n### Terms\n\n\n#### Cluster Ports\n\nA cluster port is a port with which a client will try to connect to a cluster. If the port is not reachable, the node starts as the first node in a cluster. A cluster port is any public port of a node in a cluster. Cluster ports are printed when a node starts and log level is INFO or DEBUG.\n\n#### Host Ports\n\nSometimes PYDEVTS Nodes will run another application alongside themselves when running. If this application is a server of some kind, it's public facing port is called a Host Port.\n\n### Examples\n\nListed below are some of the examples found in the `examples/` directory. All examples assume localhost.\n\n#### fastapi_example.py\n\nExternal Requirements:\n- fastapi\n- hypercorn\n\nThis example details how to run another async application (FastAPI with hypercorn) alongside PYDEVTS.\n\nIt takes two arguments:\n- The cluster port to attempt to connect to\n- The host port to host the fastapi application on\n\n#### picklenode.py\n\nExternal Requirements:\n- trio (for the event loop)\n\nNOTICE: This should never be used with untrusted data, as pickle can be used to execute untrusted code.\n\nThis example shows how to create a custom node type. This node stores a single pickled object, and can get and set the object in the cluster.\n\nThis example takes two arguments:\n- The cluster port to attempt to connect to\n- The literal string 'w' (without the quotes) if we want the cluster to update the value. If we do not provide this, the cluster will simply read the value every second and print it.\n\n#### picklenodewriter.py\n\nExternal Requirements:\n- trio (for the event loop)\n\nNOTICE: This should never be used with untrusted data, as pickle can be used to execute untrusted code.\n\nThis example works in conjunction with picklenode.py to show two different nodes types can work together. Every time the stored value in a picklenode.py node is updated, it writes the string representation of it to a file called `pickleoutput.txt`\n\nThis example takes one argument:\n- The cluster port to attempt to connect to\n\n\n## Versioning\n\nThis project is currently in its infancy. In all 0.y.z versions, there is no backward or forwards compatibility guaranteed. These versions each represent a stage in the development of the first full release: 1.0.0\n\nWhat each 0.y.z version represents is listed here:\n\n### 0.0.z\n\nThis version is the most unstable version. This version was to simply provide a ground for experimenting with methods, almost none of which persisted into the next version.\n\n### 0.1.z\n\nThis version provides theoretical support for multiple routing systems, although it only provides a basic peer based routing system at 0.1.0, future patch versions will add more routing systems. For example: 0.1.1 will provide a basic hop-based routing system.\n\n### 0.2.z\n\nThis is where things start to get interesting. From versions 0.0.z and 0.1.z we now know the basics about how the system will function when finished. In this version we will start creating standard API interfaces and protocols for routing systems to use. This version will also implement QUIC as well as TCP to reduce overhead produced when connecting to peers, and use other external libraries to provide more extensive support for different routing methods.\n\n### 0.3.z\n\nThis version will restructure the project to make the Routing Systems, Protocols, and P2P connections as modular as possible, as well as removing dependencies between different classes to completely decouple systems and allow, for example, routing systems to be used with a different library, or allow someone to implement, say, STCP as the communication protocol used.\n\n### 0.4.z\n\nThis version is an API refractor. This focuses mainly on how nodes work (combining nodes, removing unneeded methods, etc.), and will allow users to provide custom data serialization methods. The goal of this version is to make the library as ergonomic as possible, whilst adding customization that was not included in 0.3.z.\n\n### 0.5.z\n\nThis version will focus on security and hardening the system against denial of service attacks and similar attacks. A patch version of this version will also provide support for plugins that allow certain aspects of the system to be changed (e.x: load balancing connections), or to perform operations (like analytics) on received or sent data. This plugin system works at the connection level, and not at the node level like custom nodes do.\n\n### 0.6.z and up\n\nThese versions are yet to be determined, and will most likely be used in the event of an occurring issue or feature that I have not yet thought of, or do not fit into the other versions. These versions will be filled in here as needed.\n\n### 1.y.z and up\n\nThese versions are the first stable versions and will follow the semver versioning system. These will mainly be bugfixes and new features.\n## Collaboration and Questions\n\nIf you find a bug, report it on github issues. If, however, you have questions or are not sure how something works, post it on github discussions.\n\nIf you see some room for improvement and you wish to help out, create a github issue describing the problem and stating that you can work on it. If you do not wish to help out, or can not for some reason, then still leave the issue, as any feedback is appreciated. Usability and efficiency feedback is appreciated even more.\n\n",
    'author': 'Riley Wilton',
    'author_email': 'meetingprince34@outlook.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Peperworx/pydevts',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
