# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['wrfy']

package_data = \
{'': ['*']}

install_requires = \
['docker>=2.7.0,<3.0.0', 'progressbar2>=3.5.0,<4.0.0']

entry_points = \
{'console_scripts': ['wrfy = wrfy.cli:main']}

setup_kwargs = {
    'name': 'wrfy',
    'version': '0.9.1',
    'description': 'Simple bulk operations for Docker',
    'long_description': "# `wrfy` /wharfie/\n\n> *minimal CLI tool to smooth your docker local dev experience*\n\n`wrfy` provides a dozen or so commands to automate common operations on a docker development or CI host. Want to pull all images? Delete images matching a regexp? Clean up dangling volumes? You've come to the right place.\n\n# installation\n\n```$ pip3 install wrfy```\n\n# `wrfy` commands\n\n## doctor\n\n`wrfy doctor` will check your docker host for common issues. The checks are:\n\n  - **containers running from an old version of the image they were launched from**. for example, \n    if you were to do `docker run -it alpine:latest /bin/sh`, leave that\n\tcontainer going, and then pull a newer version of `alpine:latest`, `wrfy`\n\twill let you know that your Alpine container is running from an old\n\timage.\n  - **dangling volumes**. dangling volumes, which are not attached to a container.\n  - **dangling images**. dangling images, which do not have a tag.\n  - **stopped containers**. docker hosts can build up a large number of stopped containers\n    whose purpose was ephemeral.\n\nEach check suggests a `wrfy` tool to address each particular issue identified.\n\n## kill-all\n\n`wrfy kill-all` will kill all running containers.\nIt asks for confirmation, unless `--force` is passed as an argument.\n\n## pull-all\n\n`wrfy pull-all` will pull all images present on the docker host. This is very useful when you want to make sure everything is up to date.\n\n## rm-matching\n\n`wrfy rm-matching <pattern>` will remove containers matching the provided glob pattern.\nIf `-e` is passed, the pattern is interpreted as a regular expression.\nIt asks for confirmation, unless `--force` is passed as an argument.\n\nA useful command is `wrfy rm-matching -e '^[a-z]+_[a-z]+$'`, which will remove all containers with a name\ncomprised of two words seperated by an underscore. This will match containers with names automatically\ngenerated by docker.\n\n## rm-stopped\n\n`wrfy rm-stopped` will remove all containers which are not running. It is somewhat of a blunt instrument,\nyou might want to use `rm-matching` instead.\nIt asks for confirmation, unless `--force` is passed as an argument.\n\n## rmi-dangling\n\n`wrfy rmi-dangling` will remove all dangling images - images which haven't got a name. \nIt asks for confirmation, unless `--force` is passed as an argument.\n\n## rmi-matching\n\n`wrfy rmi-matching <pattern>` will remove images matching the provided glob pattern.\nIf `-e` is passed, the pattern is interpreted as a regular expression.\nIt asks for confirmation, unless `--force` is passed as an argument.\n\nA useful command to clean up after `docker-compose` is \n`wrfy rmi-matching -e '^[a-z]+_[a-z]+:latest$'`,\nwhich will remove all containers with a name comprised of two words\nseperated by an underscore, and a tag of `latest`. Such images\nprobably came from `docker-compose`.\n\n## rmv-dangling\n\n`wrfy rmv-dangling` will remove all dangling volumes - volumes not attached to any container.\nIt asks for confirmation, unless `--force` is passed as an argument.\n\n## scrub\n\n`wrfy scrub` chains together `rm_stopped`, `rmi_dangling`, and `rmv_dangling`.\nIt asks for confirmation at each stage, unless `--force` is passed as an argument.\n\n",
    'author': 'Grahame Bowland',
    'author_email': 'grahame@oreamnos.com.au',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4',
}


setup(**setup_kwargs)
