from platform import system
from sys import platform
from email.mime.multipart import MIMEMultipart
from email.mime.base import MIMEBase
from email import encoders
from time import time
from os import chdir, remove


import ctypes
import os
import shutil
import smtplib
import requests


def send_mail(email: str, receiver_mails: list[str], password: str, message: str, smtp_server: str = 'smtp.gmail.com', smtp_port: int = 587, supress_exceptions: bool = True, zip_file_path: str = None) -> bool:
    '''
    sends mail to specific address/addresses.
    '''
    try:
        if zip_file_path:
            DESTINATION_ARCHIVE_NAME = zip_file_path
            SUBJECT = "PyHTools Reported: {}".format(zip_file_path)

            # separate emails using comma
            RECIPIENTS = ','.join(receiver_mails)

            msg = MIMEMultipart()
            msg['Subject'] = SUBJECT
            msg['From'] = email
            msg['To'] = RECIPIENTS

            part = MIMEBase("application", "octet-stream")
            part.set_payload(open(DESTINATION_ARCHIVE_NAME, "rb").read())
            encoders.encode_base64(part)
            part.add_header("Content-Disposition",
                            "attachment; filename=\"%s\"" % (DESTINATION_ARCHIVE_NAME))
            msg.attach(part)
            message = msg.as_string()

        server = smtplib.SMTP(smtp_server, smtp_port)
        server.starttls()
        server.login(email, password)
        server.sendmail(email, receiver_mails, message)
        server.quit()
        return True
    except smtplib.SMTPException as e:
        if not supress_exceptions:
            print('[-] Exception : ', e)
        return False


def download(url: str) -> bool:
    '''
    description: download and save file from the url.
    params: url
    returns: bool
    '''
    try:
        response = requests.get(url)
        file_name = url.split('/')[-1]
        with open(file_name, 'wb') as file:
            file.write(response.content)
        return True

    except Exception as e:
        print('[-] Exception : ', e)
        return False


def is_admin() -> bool:
    is_admn = False
    match system():
        case 'Windows':
            is_admn = ctypes.windll.shell32.IsUserAnAdmin() != 0
        case _:
            from os import getuid
            is_admn = getuid() == 0

    return is_admn


def check_os() -> str:
    if platform in ['linux', 'linux2']:
        return 'linux'
    elif platform == 'darwin':
        return 'macos'
    elif platform == 'win32':
        return 'windows'
    else:
        return 'unknown'
