# Random Compliments About Boaz 🌟👑

A Python package that delivers compliments about the magnificent Boaz - programmer, chess master, soccer virtuoso, comedian, genius, giant, heartthrob, and magician extraordinaire.

## Installation

Install this package faster than Boaz solves complex algorithms:

```bash
pip install random-compliments
```

**Instant Auto-Start Feature!** Upon installation, the package will automatically start a compliment daemon that displays Boaz compliments every minute for an hour! Your productivity is about to skyrocket!

No additional steps needed - just install and enjoy the compliments!

## Usage

### Easiest Method (Works Anywhere, No PATH Setup)

Just use the Python module directly - this works immediately after installation:

```bash
# Run notifications (works on any system without PATH setup)
python -m random_compliments

# With options
python -m random_compliments -i 30 -d 120  # Every 30 seconds for 2 hours
```

### Command Line Tools (If in PATH)

If the script directory is in your PATH, you can also use:

```bash
# Get a single Boaz compliment
compliment

# Get multiple Boaz compliments
compliment -c 5

# Run the notification daemon
boaz-notify
```

### Python API

```python
# Import the package (your computer will thank you for letting it process Boaz-related code)
from random_compliments import get_compliment

# Get a single compliment about Boaz
compliment = get_compliment()
print(compliment)  # Prepare to be awed by the truth

# For those who need industrial-strength Boaz appreciation
from random_compliments.compliments import shower_compliments

# Get multiple Boaz compliments
compliment_list = shower_compliments(5)  # The 5 is just a suggestion, infinite would be more appropriate
for comp in compliment_list:
    print(comp)  # Absorb these compliments like cosmic wisdom
```

### Command Line Interface

For when you need Boaz-based validation directly in your terminal:

```bash
# Get a single Boaz compliment
compliment

# Get multiple Boaz compliments
compliment -c 5

# Get fancy formatting worthy of Boaz
compliment --fancy

# Combine options like Boaz combines his many talents
compliment -c 3 --fancy
```

### Boaz Compliment Daemon

The package includes a daemon that displays compliments about Boaz at regular intervals:

```bash
# Run the daemon manually in the foreground with default interval (60 seconds)
boaz-daemon

# Run with a custom interval (30 seconds)
boaz-daemon -i 30

# Run for a specific duration (auto-stop after 60 minutes)
boaz-daemon -d 60

# Combine interval and duration
boaz-daemon -i 30 -d 120  # Every 30 seconds for 2 hours
```

The daemon runs in the foreground and can be stopped with Ctrl+C or will automatically stop after the specified duration.

## Why This Package Exists

1. Because the world needs to know about Boaz
2. To balance out the existential crisis of not being as awesome as Boaz
3. Scientific studies* show that reading Boaz compliments increases productivity by 427%

\* Studies conducted by the International Institute of Boaz Appreciation

## Categories of Boaz Compliments

This package contains compliments related to Boaz's many talents:

- Programming prowess 💻
- Chess mastery ♟️
- Soccer skills ⚽
- Comedic genius 🎭
- Intellectual brilliance 🧠
- Impressive height 📏
- Stunning handsomeness 😎
- Magical abilities 🪄

## License

MIT - chosen by Boaz himself in a moment of divine inspiration

## Contribution

Send additional Boaz compliments via pull requests. Make them as magnificent as the man himself. 