"""
Module containing color palettes
"""
import pychromatic.colorclass as pcl

#default colors
red = '#d32f2f'
pink = '#c2185b'
purple = '#7b1fa2'
blue = '#1976d2'
lightblue = '#0288d1'
cyan = '#0097a7'
teal = '#00796b'
green = '#388e3c'
lightgreen = '#689f38'
lime = '#afb42b'
yellow = '#fbc02d'
orange = '#f57c00'
brown = '#5d4037'
grey = '#616161'
bluegrey = '#455a64'
darkgrey = '#263238'
#color paletts -as dicts
color_palettes = {

	'default' : {'colors':[blue,red,green,orange,purple,bluegrey,lightblue,pink,lightgreen,yellow,teal,grey,brown,lime,cyan],
				'names':["blue","red","green","orange","purple","bluegrey","lightblue","pink","lightgreen","yellow","teal","grey","brown","lime","cyan"],
	        	'type':'sequential',
	        	'other_stuff':'value'},


	'pastels' : {'colors':['#8dd3c7','#ffffb3','#bebada','#fb8072','#80b1d3',
						   '#fdb462', '#b3de69','#fccde5','#d9d9d9','#bc80bd',
						   '#ccebc5','#ffed6f'],
	          'names':['color1', 'color2', 'color3', 'color4', 'color5', 'color6', 'color7',
	          'color8', 'color9', 'color10', 'color11', 'color12'],
				'type':'', },


	'basics' : {'colors':['#e41a1c','#377eb8','#4daf4a','#984ea3','#ff7f00',
						  '#ffff33','#a65628','#f781bf','#999999'],
	          'names':['color1', 'color2', 'color3', 'color4', 'color5', 'color6', 'color7',
	          'color8'],
				'type':'', },


	'set1_dark' : {'colors':['#1b9e77','#d95f02','#7570b3','#e7298a','#66a61e',
							 '#e6ab02', '#a6761d','#666666'],
	          'names':['color1', 'color2', 'color3', 'color4', 'color5', 'color6', 'color7',
	          'color8'],
				'type':'', },


	'set1_pastel' : {'colors':['#66c2a5','#fc8d62','#8da0cb','#e78ac3','#a6d854',
							   '#ffd92f', '#e5c494','#b3b3b3'],
	          'names':['color1', 'color2', 'color3', 'color4', 'color5', 'color6', 'color7',
	          'color8'],
				'type':'', },


	'excel' : {'colors':['#5F7CBB','#B1534F','#9DBD5B','#7D60A0','#E8994B',
						 '#999999','#67A8C4'],
	          'names':['color1', 'color2', 'color3', 'color4', 'color5', 'color6', 'color7'],
				'type':'', },


	'set2' : {'colors':['#d11141','#00b159','#00aedb','#f37735','#ffc425'],
	          'names':['color1', 'color2', 'color3', 'color4', 'color5'],
				'type':'', },


	'google' : {'colors':['#008744','#0057e7','#d62d20','#ffa700','#B9B9B9'],
		          'names':['color1', 'color2', 'color3', 'color4', 'color5'],
				'type':'', },


	'set3' : {'colors':['#5fad56','#f2c14e','#f78154','#4d9078','#b4436c'],
	          'names':['color1', 'color2', 'color3', 'color4', 'color5'],
				'type':'', },


	'set4' : {'colors':['#363537','#0cce6b','#dced31','#ef2d56','#ed7d3a'],
	          'names':['color1', 'color2', 'color3', 'color4', 'color5'],
				'type':'', },


	'dark' : {'colors':['#007283','#72013f','#c76b0d','#322569','#124d25'],
	          'names':['color1', 'color2', 'color3', 'color4', 'color5'],
				'type':'', },


	'earth' : {'colors':['#FDBF00','#514939','#BD5340','#90A74F','#D0B388'],
	          'names':['color1', 'color2', 'color3', 'color4', 'color5'],
				'type':'', },


	'set5' : {'colors':['#F4AB33','#EC7176','#C068A8','#5C63A2','#1B4E6B'],
	          'names':['color1', 'color2', 'color3', 'color4', 'color5'],
				'type':'', },


	'rainbow' : {'colors':['#015486','#00B5D0','#6EC626','#FFBE00','#FD5D47'],
	          'names':['color1', 'color2', 'color3', 'color4', 'color5'],
				'type':'', },


	'set6' : {'colors':['#435772','#2DA4A8','#FD9C3C','#FD6041','#CF2257'],
	          'names':['color1', 'color2', 'color3', 'color4', 'color5'],
				'type':'', },


	'set7' : {'colors':['#4597A3','#D6765D','#99CFAB','#F0CB73','#7B7E7E'],
	          'names':['color1', 'color2', 'color3', 'color4', 'color5'],
				'type':'', },

	"accent" : { "colors":['#d7191c', '#fdae61', '#abdda4', '#2b83ba', "#455A64",
					'#C62828', '#FFA000', '#008F68', '#006899', "#424242", "#e58080",
					"#ffc766",  "#85e085", "#66cfff", "#b3b3b3",],
				 "names": ["lred","lyellow","lgreen", "lblue", "lgrey", "dred", "dyellow", "dgreen",
			"dblue", "dgrey", "pred", "pyellow", "pgreen", "pblue", "pgrey",],
			'type':'',},

}

deprecated = {
		"lred" : '#d7191c',
        "lyellow" : '#fdae61',
        "lgreen" : '#abdda4',
        "lblue" : '#2b83ba',
        "lgrey" : "#455A64",
        "dred" : '#C62828',
        "dyellow" : '#FFA000',
        "dgreen" : '#008F68',
        "dblue" : '#006899',
        "dgrey" : "#424242",
        "pred" : "#e58080",
        "pyellow" : "#ffc766",
        "pgreen" : "#85e085",
        "pblue" : "#66cfff",
        "pgrey" : "#b3b3b3",
}

accent = {
		"lred" : '#d7191c',
        "lyellow" : '#fdae61',
        "lgreen" : '#abdda4',
        "lblue" : '#2b83ba',
        "lgrey" : "#455A64",
        "dred" : '#C62828',
        "dyellow" : '#FFA000',
        "dgreen" : '#008F68',
        "dblue" : '#006899',
        "dgrey" : "#424242",
        "pred" : "#e58080",
        "pyellow" : "#ffc766",
        "pgreen" : "#85e085",
        "pblue" : "#66cfff",
        "pgrey" : "#b3b3b3",
}

chromate = {
	"dark":{
        "red" : '#C62828',
        "yellow" : '#FFA000',
        "green" : '#008F68',
        "blue" : '#006899',
        "grey" : "#424242",
	},
	"light":{
		"red" : '#d7191c',
        "yellow" : '#fdae61',
        "green" : '#abdda4',
        "blue" : '#2b83ba',
        "grey" : "#455A64",
	},
	"pastel":{
        "red" : "#e58080",
        "yellow" : "#ffc766",
        "green" : "#85e085",
        "blue" : "#66cfff",
        "grey" : "#b3b3b3",
	}
}


