from typing import Any, Optional

from botocore.compat import HTTPHeaders as HTTPHeaders
from botocore.compat import HTTPResponse as HTTPResponse
from botocore.compat import urlencode as urlencode
from botocore.compat import urlsplit as urlsplit
from botocore.compat import urlunsplit as urlunsplit
from botocore.exceptions import UnseekableStreamError as UnseekableStreamError
from urllib3.connection import HTTPConnection, VerifiedHTTPSConnection
from urllib3.connectionpool import HTTPConnectionPool, HTTPSConnectionPool

try:
    from collections.abc import MutableMapping
except ImportError:
    from collections import MutableMapping  # type: ignore

class AWSHTTPResponse(HTTPResponse):
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...

class AWSConnection:
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    response_class: Any = ...
    def close(self) -> None: ...
    def send(self, str: Any) -> Any: ...

# FIXME: AWSConnection.send has incompatible arg names
class AWSHTTPConnection(AWSConnection, HTTPConnection): ...  # type: ignore
class AWSHTTPSConnection(AWSConnection, VerifiedHTTPSConnection): ...  # type: ignore

class AWSHTTPConnectionPool(HTTPConnectionPool):
    ConnectionCls: Any = ...

class AWSHTTPSConnectionPool(HTTPSConnectionPool):
    ConnectionCls: Any = ...

def prepare_request_dict(
    request_dict: Any,
    endpoint_url: Any,
    context: Optional[Any] = ...,
    user_agent: Optional[Any] = ...,
) -> None: ...
def create_request_object(request_dict: Any) -> Any: ...

class AWSRequestPreparer:
    def prepare(self, original: Any) -> Any: ...

class AWSRequest:
    method: Any = ...
    url: Any = ...
    headers: Any = ...
    data: Any = ...
    params: Any = ...
    auth_path: Any = ...
    stream_output: Any = ...
    context: Any = ...
    def __init__(
        self,
        method: Optional[Any] = ...,
        url: Optional[Any] = ...,
        headers: Optional[Any] = ...,
        data: Optional[Any] = ...,
        params: Optional[Any] = ...,
        auth_path: Optional[Any] = ...,
        stream_output: bool = ...,
    ) -> None: ...
    def prepare(self) -> Any: ...
    @property
    def body(self) -> Any: ...

class AWSPreparedRequest:
    method: Any = ...
    url: Any = ...
    headers: Any = ...
    body: Any = ...
    stream_output: Any = ...
    def __init__(
        self, method: Any, url: Any, headers: Any, body: Any, stream_output: Any
    ) -> None: ...
    def reset_stream(self) -> None: ...

class AWSResponse:
    url: Any = ...
    status_code: Any = ...
    headers: Any = ...
    raw: Any = ...
    def __init__(self, url: Any, status_code: Any, headers: Any, raw: Any) -> None: ...
    @property
    def content(self) -> Any: ...
    @property
    def text(self) -> Any: ...

class _HeaderKey:
    def __init__(self, key: Any) -> None: ...
    def __hash__(self) -> Any: ...
    def __eq__(self, other: Any) -> Any: ...

class HeadersDict(MutableMapping[str, str]):
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def __setitem__(self, key: Any, value: Any) -> None: ...
    def __getitem__(self, key: Any) -> Any: ...
    def __delitem__(self, key: Any) -> None: ...
    def __iter__(self) -> Any: ...
    def __len__(self) -> int: ...
    def copy(self) -> Any: ...
