# hg-fluiddyn, a small Mercurial extension for the FluidDyn project

## Installation

With Mercurial installed with
[conda-app](https://foss.heptapod.net/fluiddyn/conda-app), run:

```bash
conda activate _env_mercurial
pip install hg-fluiddyn
```

## What we would like to provide

- [x] check that the topic, evolve and rebase extensions are activated,

- [x] check paths for FluidDyn packages and automatically modify them if
needed,

  - `default = ssh://hg@foss.heptapod.net/fluiddyn/fluid???`

- [x] for maintainers:

  - [x] check that hg-git is activated,

- [x] black pre-commit hook (better with Python >= 3.6) applying `black -l 82`
  to modified Python files,

- [x] commands similar to fluiddevops

  - [x] fluiddyn-clone-repositories
  - [x] fluiddyn-pull-update-default

(See https://www.mercurial-scm.org/wiki/WritingExtensions and
https://www.mercurial-scm.org/wiki/MercurialApi)

## Example of configuration for this extension (in `~/.hgrc`)

```raw

[fluiddyn]
root = ~/Dev
maintainer = 1

```
