# Generated by Django 2.1.15 on 2020-04-23 11:58

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("opening_hours_management", "0005_auto_20200409_1256"),
    ]

    operations = [
        migrations.CreateModel(
            name="GeneralHolidaysHours",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "closed",
                    models.BooleanField(
                        default=False,
                        help_text="If checked, prevails on time range values",
                        verbose_name="Closed",
                    ),
                ),
                (
                    "opening_hours",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="general_holidays_hours",
                        to="opening_hours_management.OpeningHours",
                        verbose_name="Opening hours",
                    ),
                ),
            ],
            options={
                "verbose_name": "General holidays hours",
                "verbose_name_plural": "General holidays hours",
            },
        ),
        migrations.CreateModel(
            name="GeneralHolidaysTimeRange",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "opening_time",
                    models.TimeField(
                        blank=True, null=True, verbose_name="Opening time"
                    ),
                ),
                (
                    "closing_time",
                    models.TimeField(
                        blank=True, null=True, verbose_name="Closing time"
                    ),
                ),
                (
                    "general_holidays_hours",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="general_holidays_time_ranges",
                        to="opening_hours_management.GeneralHolidaysHours",
                        verbose_name="General holidays hours",
                    ),
                ),
            ],
            options={
                "verbose_name": "General holidays time range",
                "verbose_name_plural": "General holidays time range",
                "ordering": ["opening_time"],
                "abstract": False,
            },
        ),
    ]
