# Generated by Django 1.11.5 on 2017-11-25 17:46
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="ReferralHit",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "authenticated",
                    models.BooleanField(
                        help_text="Whether the hit was created by an authenticated user."
                    ),
                ),
                (
                    "ip",
                    models.GenericIPAddressField(help_text="IP address at hit time"),
                ),
                (
                    "user_agent",
                    models.TextField(blank=True, help_text="User-Agent at hit time"),
                ),
                (
                    "http_referer",
                    models.TextField(
                        blank=True, help_text="Referrer header at hit time"
                    ),
                ),
                (
                    "next",
                    models.URLField(
                        blank=True,
                        help_text="The ?next parameter when the link was hit.",
                    ),
                ),
                (
                    "confirmed",
                    models.DateTimeField(
                        db_index=True,
                        help_text="If set, the datetime at which the hit was marked as a successful referral.",
                        null=True,
                        blank=True,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
                (
                    "hit_user",
                    models.ForeignKey(
                        null=True,
                        blank=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ReferralLink",
            fields=[
                (
                    "id",
                    models.AutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "identifier",
                    models.CharField(blank=True, max_length=50, unique=True),
                ),
                ("disabled", models.BooleanField(default=False)),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
                (
                    "user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="referralhit",
            name="referral_link",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="hype.ReferralLink"
            ),
        ),
    ]
