import * as iam from 'aws-cdk-lib/aws-iam';
import * as cdk from 'aws-cdk-lib';
import { MessageLanguage } from './common';
/**
 * (experimental) Properties for governance mechanisms and constraints.
 *
 * @experimental
 */
export interface CommonConstraintOptions {
    /**
     * (experimental) The language code.
     *
     * Configures the language for error messages from service catalog.
     *
     * @default - English
     * @experimental
     */
    readonly messageLanguage?: MessageLanguage;
    /**
     * (experimental) The description of the constraint.
     *
     * @default - No description provided
     * @experimental
     */
    readonly description?: string;
}
/**
 * (experimental) Properties for deploying with Stackset, which creates a StackSet constraint.
 *
 * @experimental
 */
export interface StackSetsConstraintOptions extends CommonConstraintOptions {
    /**
     * (experimental) List of accounts to deploy stacks to.
     *
     * @experimental
     */
    readonly accounts: string[];
    /**
     * (experimental) List of regions to deploy stacks to.
     *
     * @experimental
     */
    readonly regions: string[];
    /**
     * (experimental) IAM role used to administer the StackSets configuration.
     *
     * @experimental
     */
    readonly adminRole: iam.IRole;
    /**
     * (experimental) IAM role used to provision the products in the Stacks.
     *
     * @experimental
     */
    readonly executionRoleName: string;
    /**
     * (experimental) Wether to allow end users to create, update, and delete stacks.
     *
     * @default false
     * @experimental
     */
    readonly allowStackSetInstanceOperations?: boolean;
}
/**
 * (experimental) Properties for ResourceUpdateConstraint.
 *
 * @experimental
 */
export interface TagUpdateConstraintOptions extends CommonConstraintOptions {
    /**
     * (experimental) Toggle for if users should be allowed to change/update tags on provisioned products.
     *
     * @default true
     * @experimental
     */
    readonly allow?: boolean;
}
/**
 * (experimental) An assertion within a template rule, defined by intrinsic functions.
 *
 * @experimental
 */
export interface TemplateRuleAssertion {
    /**
     * (experimental) The assertion condition.
     *
     * @experimental
     */
    readonly assert: cdk.ICfnRuleConditionExpression;
    /**
     * (experimental) The description for the asssertion.
     *
     * @default - no description provided for the assertion.
     * @experimental
     */
    readonly description?: string;
}
/**
 * (experimental) Defines the provisioning template constraints.
 *
 * @experimental
 */
export interface TemplateRule {
    /**
     * (experimental) Name of the rule.
     *
     * @experimental
     */
    readonly ruleName: string;
    /**
     * (experimental) Specify when to apply rule with a rule-specific intrinsic function.
     *
     * @default - no rule condition provided
     * @experimental
     */
    readonly condition?: cdk.ICfnRuleConditionExpression;
    /**
     * (experimental) A list of assertions that make up the rule.
     *
     * @experimental
     */
    readonly assertions: TemplateRuleAssertion[];
}
/**
 * (experimental) Properties for provisoning rule constraint.
 *
 * @experimental
 */
export interface CloudFormationRuleConstraintOptions extends CommonConstraintOptions {
    /**
     * (experimental) The rule with condition and assertions to apply to template.
     *
     * @experimental
     */
    readonly rule: TemplateRule;
}
