from dataclasses import dataclass, field
from typing import List, Optional
from data_classes.ei_rest_api.sgr_rest_api_eidata_types import (
    SgrRestApiattrFrameType,
    SgrRestApidataPointDescriptionType,
    SgrRestApidataPointsFrameType,
    SgrRestApiinterfaceDescriptionType,
    SgrRestApiprofilesFrameType,
)
from data_classes.generic.sgr_gen_data_point_definition import SgrDataPointDescriptionType
from data_classes.generic.sgr_gen_device_profile import SgrDeviceProfileType
from data_classes.generic.sgr_gen_functional_profile_definition import SgrProfileDescriptionType
from data_classes.generic.sgr_manufacturer_list import SgrManufacturerIdtype

__NAMESPACE__ = "http://www.smartgridready.com/ns/V0/"


@dataclass
class SgrRestapideviceDescriptionType:
    """
    Data Typdefinition for a REST Device Description as an EI (External
    Interace) Geraet.

    :ivar device_profile:
    :ivar dev_rest_apiattr_reference: RestAPIAttrFrameTypes contain two
        branches of SmartGridready attributes: REST related and Generic
        devAttrReference values are valid for a whole device
    :ivar rest_apiinterface_desc:
    :ivar fp_list_element:
    :ivar device_name: Device Name in the context of the ManufacturerID
    :ivar manufacturer_name: Name of the Manufacturer or OEM
    :ivar manufacturer_id: the identifier as enumeration indicates that
        the manufacturer is related with the organisation and that this
        external interface is generated by himself
    :ivar is_local_control: Value "false" means "is cloud control
        device", indicating that this service is based on cloud. "True"
        indicates that services are provided within the range of the
        local area.
    """
    class Meta:
        name = "SGrRESTAPIDeviceDescriptionType"
        namespace = "http://www.smartgridready.com/ns/V0/"

    device_profile: Optional[SgrDeviceProfileType] = field(
        default=None,
        metadata={
            "name": "deviceProfile",
            "type": "Element",
            "required": True,
        }
    )
    dev_rest_apiattr_reference: List[SgrRestApiattrFrameType] = field(
        default_factory=list,
        metadata={
            "name": "devRestAPIAttrReference",
            "type": "Element",
        }
    )
    rest_apiinterface_desc: Optional[SgrRestApiinterfaceDescriptionType] = field(
        default=None,
        metadata={
            "name": "restAPIInterfaceDesc",
            "type": "Element",
            "required": True,
        }
    )
    fp_list_element: List[SgrRestApiprofilesFrameType] = field(
        default_factory=list,
        metadata={
            "name": "fpListElement",
            "type": "Element",
            "min_occurs": 1,
        }
    )
    device_name: Optional[str] = field(
        default=None,
        metadata={
            "name": "deviceName",
            "type": "Attribute",
        }
    )
    manufacturer_name: Optional[str] = field(
        default=None,
        metadata={
            "name": "manufacturerName",
            "type": "Attribute",
        }
    )
    manufacturer_id: Optional[SgrManufacturerIdtype] = field(
        default=None,
        metadata={
            "name": "manufacturerID",
            "type": "Attribute",
        }
    )
    is_local_control: Optional[bool] = field(
        default=None,
        metadata={
            "name": "isLocalControl",
            "type": "Attribute",
        }
    )


@dataclass
class SgrRestDataPointsFrameType:
    """RPT Root Point for stand alone Rest Functional Profile description.

    It includes the embedded generic Profile decription

    :ivar data_point:
    :ivar rest_data_point: RestAPIAttrFrameTypes contain two branches of
        SmartGridready attributes: Rest related and Generic
        fpReatAPIAttrRefernce values are valid for a single datapoint
    :ivar dp_rest_apiattr_reference:
    """
    class Meta:
        name = "SGrRestDataPointsFrameType"

    data_point: List[SgrDataPointDescriptionType] = field(
        default_factory=list,
        metadata={
            "name": "dataPoint",
            "type": "Element",
            "namespace": "http://www.smartgridready.com/ns/V0/",
            "min_occurs": 1,
        }
    )
    rest_data_point: List[SgrRestApidataPointDescriptionType] = field(
        default_factory=list,
        metadata={
            "name": "RestDataPoint",
            "type": "Element",
            "namespace": "http://www.smartgridready.com/ns/V0/",
            "min_occurs": 1,
        }
    )
    dp_rest_apiattr_reference: List[SgrRestApiattrFrameType] = field(
        default_factory=list,
        metadata={
            "name": "dpRestAPIAttrReference",
            "type": "Element",
            "namespace": "http://www.smartgridready.com/ns/V0/",
        }
    )


@dataclass
class SgrRestProfilesFrameType:
    """
    :ivar functional_profile:
    :ivar fp_rest_apiattr_reference: RestAttrFrameTypes contain two
        branches of SmartGridready attributes: REST related and Generic
        fpMbAttrRefernce values are valid for a whole functional profile
    :ivar dp_list_element:
    """
    class Meta:
        name = "SGrRestProfilesFrameType"

    functional_profile: Optional[SgrProfileDescriptionType] = field(
        default=None,
        metadata={
            "name": "functionalProfile",
            "type": "Element",
            "namespace": "http://www.smartgridready.com/ns/V0/",
            "required": True,
        }
    )
    fp_rest_apiattr_reference: List[SgrRestApiattrFrameType] = field(
        default_factory=list,
        metadata={
            "name": "fpRestAPIAttrReference",
            "type": "Element",
            "namespace": "http://www.smartgridready.com/ns/V0/",
        }
    )
    dp_list_element: List[SgrRestApidataPointsFrameType] = field(
        default_factory=list,
        metadata={
            "name": "dpListElement",
            "type": "Element",
            "namespace": "http://www.smartgridready.com/ns/V0/",
            "min_occurs": 1,
        }
    )


@dataclass
class SgrRestApideviceFrame(SgrRestapideviceDescriptionType):
    """RPT Root Point for stand alone Rest Device description.

    It includes the embedded generic Device decription
    """
    class Meta:
        name = "SGrRestAPIDeviceFrame"
        namespace = "http://www.smartgridready.com/ns/V0/"
