from dataclasses import dataclass, field
from typing import List, Optional
from data_classes.generic.sgr_gen_device_frame import SgrProfilesFrameType
from data_classes.generic.sgr_gen_device_profile import SgrDeviceProfileType
from data_classes.generic.sgr_gen_type_definitions import SgrAttr4GenericType
from data_classes.generic.sgr_manufacturer_list import SgrManufacturerIdtype

__NAMESPACE__ = "http://www.smartgridready.com/ns/V0/"


@dataclass
class ContactApiInterfaceDescType:
    class Meta:
        name = "ContactAPI_InterfaceDescType"

    num_contacts: Optional[int] = field(
        default=None,
        metadata={
            "name": "numContacts",
            "type": "Element",
            "namespace": "http://www.smartgridready.com/ns/V0/",
            "required": True,
        }
    )
    contact_stabilisation_time_ms: Optional[int] = field(
        default=None,
        metadata={
            "name": "contactStabilisationTimeMs",
            "type": "Element",
            "namespace": "http://www.smartgridready.com/ns/V0/",
            "required": True,
        }
    )


@dataclass
class SgrContactApideviceDescriptionType:
    """
    Data Typdefinition for a AnyAPI_ Device Description as an EI (External
    Interface) Geraet.

    :ivar device_profile:
    :ivar dev_attr4_generic: ContactsAPI_AttrFrameTypes contains only
        the generic branch of SGr attributes
    :ivar contact_api_interface_desc:
    :ivar fp_list_element:
    :ivar device_name: Device Name in the context of the ManufacturerID
    :ivar manufacturer_name: Name of the Manufacturer or OEM
    :ivar manufacturer_id: the identifier as enumeration indicates that
        the manufacturer is related with the organisation and that this
        external interface is generated by himself
    :ivar is_local_control: Value "false" means "is cloud control
        device", indicating that this service is based on cloud. "True"
        indicates that services are provided within the range of the
        local area.
    """
    class Meta:
        name = "SGrContactAPIDeviceDescriptionType"
        namespace = "http://www.smartgridready.com/ns/V0/"

    device_profile: Optional[SgrDeviceProfileType] = field(
        default=None,
        metadata={
            "name": "deviceProfile",
            "type": "Element",
            "required": True,
        }
    )
    dev_attr4_generic: List[SgrAttr4GenericType] = field(
        default_factory=list,
        metadata={
            "name": "devAttr4Generic",
            "type": "Element",
        }
    )
    contact_api_interface_desc: Optional[ContactApiInterfaceDescType] = field(
        default=None,
        metadata={
            "name": "contactApiInterfaceDesc",
            "type": "Element",
            "required": True,
        }
    )
    fp_list_element: List[SgrProfilesFrameType] = field(
        default_factory=list,
        metadata={
            "name": "fpListElement",
            "type": "Element",
            "min_occurs": 1,
        }
    )
    device_name: Optional[str] = field(
        default=None,
        metadata={
            "name": "deviceName",
            "type": "Attribute",
        }
    )
    manufacturer_name: Optional[str] = field(
        default=None,
        metadata={
            "name": "manufacturerName",
            "type": "Attribute",
        }
    )
    manufacturer_id: Optional[SgrManufacturerIdtype] = field(
        default=None,
        metadata={
            "name": "manufacturerID",
            "type": "Attribute",
        }
    )
    is_local_control: Optional[bool] = field(
        default=None,
        metadata={
            "name": "isLocalControl",
            "type": "Attribute",
        }
    )


@dataclass
class SgrContactApiDeviceFrame(SgrContactApideviceDescriptionType):
    """RPT Root Point for stand alone ContactAPI_ Device description.

    It includes the embedded generic Device decription
    """
    class Meta:
        name = "sgrContactAPI_DeviceFrame"
        namespace = "http://www.smartgridready.com/ns/V0/"
