# Generated by Django 2.2.4 on 2020-06-08 13:22

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import martor.models
import mptt.fields
import writing.mixins


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100, unique=True, verbose_name='title')),
                ('slug', models.SlugField(blank=True, max_length=150, unique=True)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name='modified')),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
                ('parent', mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='writing.Category', verbose_name='parent')),
            ],
            options={
                'verbose_name': 'category',
                'verbose_name_plural': 'categories',
                'ordering': ('title',),
                'default_permissions': ('list', 'view', 'add', 'change', 'delete'),
            },
            bases=(writing.mixins.SlugMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Article',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(db_index=True, max_length=100, unique=True, verbose_name='title')),
                ('slug', models.SlugField(blank=True, max_length=150, unique=True)),
                ('is_highlighted', models.BooleanField(default=False, verbose_name='highlighted')),
                ('is_published', models.BooleanField(default=True, verbose_name='published')),
                ('seen', models.PositiveSmallIntegerField(db_index=True, default=1, verbose_name='seen')),
                ('excerpt', martor.models.MartorField(verbose_name='excerpt')),
                ('content', martor.models.MartorField(verbose_name='content')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name='modified')),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, verbose_name='author')),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='writing.Category', verbose_name='category')),
            ],
            options={
                'verbose_name': 'article',
                'verbose_name_plural': 'articles',
                'ordering': ['category', 'title'],
                'default_permissions': ('list', 'view', 'add', 'change', 'delete'),
            },
        ),
    ]
