"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.addCdkConstructVersionTag = exports.Datadog = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const loglevel_1 = require("loglevel");
const transport_1 = require("./common/transport");
const index_1 = require("./index");
const versionJson = require("../version.json");
/**
 * @stability stable
 */
class Datadog extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        if (((_b = process.env.DD_CONSTRUCT_DEBUG_LOGS) === null || _b === void 0 ? void 0 : _b.toLowerCase()) == "true") {
            loglevel_1.default.setLevel("debug");
        }
        super(scope, id);
        this.scope = scope;
        this.props = props;
        index_1.validateProps(this.props);
        this.transport = new transport_1.Transport(this.props.flushMetricsToLogs, this.props.site, this.props.apiKey, this.props.apiKeySecretArn, this.props.apiKmsKey, this.props.extensionLayerVersion);
    }
    /**
     * @stability stable
     */
    addLambdaFunctions(lambdaFunctions) {
        const baseProps = index_1.handleSettingPropDefaults(this.props);
        if (this.props !== undefined && lambdaFunctions.length > 0) {
            const region = `${lambdaFunctions[0].env.region}`;
            loglevel_1.default.debug(`Using region: ${region}`);
            if (baseProps.addLayers) {
                index_1.applyLayers(this.scope, region, lambdaFunctions, this.props.pythonLayerVersion, this.props.nodeLayerVersion, this.props.extensionLayerVersion);
            }
            index_1.redirectHandlers(lambdaFunctions, baseProps.addLayers);
            if (this.props.forwarderArn !== undefined) {
                if (this.props.extensionLayerVersion !== undefined) {
                    loglevel_1.default.debug(`Skipping adding subscriptions to the lambda log groups since the extension is enabled`);
                }
                else {
                    loglevel_1.default.debug(`Adding log subscriptions using provided Forwarder ARN: ${this.props.forwarderArn}`);
                    index_1.addForwarder(this.scope, lambdaFunctions, this.props.forwarderArn);
                }
            }
            else {
                loglevel_1.default.debug("Forwarder ARN not provided, no log group subscriptions will be added");
            }
            addCdkConstructVersionTag(lambdaFunctions);
            index_1.applyEnvVariables(lambdaFunctions, baseProps);
            index_1.setDDEnvVariables(lambdaFunctions, this.props);
            setTags(lambdaFunctions, this.props);
            this.transport.applyEnvVars(lambdaFunctions);
            if (baseProps.sourceCodeIntegration) {
                this.addGitCommitMetadata(lambdaFunctions);
            }
        }
    }
    // unused parameters gitCommitSha and gitRepoUrl are kept for backwards compatibility
    /**
     * @stability stable
     */
    addGitCommitMetadata(lambdaFunctions, 
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-ignore
    gitCommitSha, 
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-ignore
    gitRepoUrl) {
        index_1.setGitEnvironmentVariables(lambdaFunctions);
    }
    /**
     * @stability stable
     */
    addForwarderToNonLambdaLogGroups(logGroups) {
        if (this.props.forwarderArn !== undefined) {
            index_1.addForwarderToLogGroups(this.scope, logGroups, this.props.forwarderArn);
        }
        else {
            loglevel_1.default.debug("Forwarder ARN not provided, no non lambda log group subscriptions will be added");
        }
    }
}
exports.Datadog = Datadog;
_a = JSII_RTTI_SYMBOL_1;
Datadog[_a] = { fqn: "datadog-cdk-constructs.Datadog", version: "0.8.5" };
function addCdkConstructVersionTag(lambdaFunctions) {
    loglevel_1.default.debug(`Adding CDK Construct version tag: ${versionJson.version}`);
    lambdaFunctions.forEach((functionName) => {
        cdk.Tags.of(functionName).add(index_1.TagKeys.CDK, `v${versionJson.version}`, {
            includeResourceTypes: ["AWS::Lambda::Function"],
        });
    });
}
exports.addCdkConstructVersionTag = addCdkConstructVersionTag;
function setTags(lambdaFunctions, props) {
    loglevel_1.default.debug(`Adding datadog tags`);
    lambdaFunctions.forEach((functionName) => {
        if (props.forwarderArn) {
            if (props.env) {
                cdk.Tags.of(functionName).add(index_1.TagKeys.ENV, props.env);
            }
            if (props.service) {
                cdk.Tags.of(functionName).add(index_1.TagKeys.SERVICE, props.service);
            }
            if (props.version) {
                cdk.Tags.of(functionName).add(index_1.TagKeys.VERSION, props.version);
            }
            if (props.tags) {
                const tagsArray = props.tags.split(",");
                tagsArray.forEach((tag) => {
                    const [key, value] = tag.split(":");
                    if (key && value) {
                        cdk.Tags.of(functionName).add(key, value);
                    }
                });
            }
        }
    });
}
//# sourceMappingURL=data:application/json;base64,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