import * as lambda from "@aws-cdk/aws-lambda";
import * as lambdaNodejs from "@aws-cdk/aws-lambda-nodejs";
import * as lambdaPython from "@aws-cdk/aws-lambda-python";
import * as logs from "@aws-cdk/aws-logs";
import * as cdk from "@aws-cdk/core";
import { Transport } from "./common/transport";
import { DatadogProps } from "./index";
/**
 * @stability stable
 */
export declare class Datadog extends cdk.Construct {
    /**
     * @stability stable
     */
    scope: cdk.Construct;
    /**
     * @stability stable
     */
    props: DatadogProps;
    /**
     * @stability stable
     */
    transport: Transport;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: DatadogProps);
    /**
     * @stability stable
     */
    addLambdaFunctions(lambdaFunctions: (lambda.Function | lambdaNodejs.NodejsFunction | lambdaPython.PythonFunction)[]): void;
    /**
     * @stability stable
     */
    addGitCommitMetadata(lambdaFunctions: (lambda.Function | lambdaNodejs.NodejsFunction | lambdaPython.PythonFunction)[], gitCommitSha?: string, gitRepoUrl?: string): void;
    /**
     * @stability stable
     */
    addForwarderToNonLambdaLogGroups(logGroups: logs.ILogGroup[]): void;
}
export declare function addCdkConstructVersionTag(lambdaFunctions: lambda.Function[]): void;
