import { ILambdaFunction } from "./interfaces";
/**
 * To avoid modifying code in the user's lambda handler, redirect the handler to a Datadog
 * handler that initializes the Lambda Layers and then calls the original handler.
 * 'DD_LAMBDA_HANDLER' is set to the original handler in the lambda's environment for the
 * replacement handler to find.
 *
 * Unchanged aside from parameter type
 */
export declare function redirectHandlers(lambdas: ILambdaFunction[], addLayers: boolean): void;
