"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.govCloudRegions = exports.runtimeToLayerName = exports.runtimeLookup = exports.TagKeys = exports.DefaultDatadogProps = exports.RuntimeType = exports.SUBSCRIPTION_FILTER_PREFIX = exports.JS_HANDLER = exports.JS_HANDLER_WITH_LAYERS = exports.PYTHON_HANDLER = exports.DD_HANDLER_ENV_VAR = exports.DD_GOV_ACCOUNT_ID = exports.DD_ACCOUNT_ID = exports.EXTENSION_LAYER_PREFIX = exports.LAYER_PREFIX = void 0;
exports.LAYER_PREFIX = "DatadogLayer";
exports.EXTENSION_LAYER_PREFIX = "DatadogExtension";
exports.DD_ACCOUNT_ID = "464622532012";
exports.DD_GOV_ACCOUNT_ID = "002406178527";
exports.DD_HANDLER_ENV_VAR = "DD_LAMBDA_HANDLER";
exports.PYTHON_HANDLER = "datadog_lambda.handler.handler";
exports.JS_HANDLER_WITH_LAYERS = "/opt/nodejs/node_modules/datadog-lambda-js/handler.handler";
exports.JS_HANDLER = "node_modules/datadog-lambda-js/dist/handler.handler";
exports.SUBSCRIPTION_FILTER_PREFIX = "DatadogSubscriptionFilter";
/**
 * @stability stable
 */
var RuntimeType;
(function (RuntimeType) {
    RuntimeType[RuntimeType["NODE"] = 0] = "NODE";
    RuntimeType[RuntimeType["PYTHON"] = 1] = "PYTHON";
    RuntimeType[RuntimeType["UNSUPPORTED"] = 2] = "UNSUPPORTED";
})(RuntimeType = exports.RuntimeType || (exports.RuntimeType = {}));
exports.DefaultDatadogProps = {
    addLayers: true,
    enableDatadogTracing: true,
    enableMergeXrayTraces: false,
    injectLogContext: true,
    enableDatadogLogs: true,
    architecture: "X86_64",
    captureLambdaPayload: false,
    sourceCodeIntegration: true,
};
/**
 * @stability stable
 */
var TagKeys;
(function (TagKeys) {
    TagKeys["CDK"] = "dd_cdk_construct";
    TagKeys["ENV"] = "env";
    TagKeys["SERVICE"] = "service";
    TagKeys["VERSION"] = "version";
})(TagKeys = exports.TagKeys || (exports.TagKeys = {}));
exports.runtimeLookup = {
    "nodejs12.x": RuntimeType.NODE,
    "nodejs14.x": RuntimeType.NODE,
    "nodejs16.x": RuntimeType.NODE,
    "nodejs18.x": RuntimeType.NODE,
    "python3.6": RuntimeType.PYTHON,
    "python3.7": RuntimeType.PYTHON,
    "python3.8": RuntimeType.PYTHON,
    "python3.9": RuntimeType.PYTHON,
};
exports.runtimeToLayerName = {
    "nodejs12.x": "Datadog-Node12-x",
    "nodejs14.x": "Datadog-Node14-x",
    "nodejs16.x": "Datadog-Node16-x",
    "nodejs18.x": "Datadog-Node18-x",
    "python3.6": "Datadog-Python36",
    "python3.7": "Datadog-Python37",
    "python3.8": "Datadog-Python38",
    "python3.9": "Datadog-Python39",
};
exports.govCloudRegions = ["us-gov-east-1", "us-gov-west-1"];
//# sourceMappingURL=data:application/json;base64,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