from runtests.mpi import MPITest
from nbodykit.io.gadget import Gadget1File
import numpy
import base64

import tempfile
import os
import pytest

@MPITest([1])
def test_data(comm):
    tmpfile = tempfile.mktemp()
    with open(tmpfile, 'wb') as ff: 

        ff.write(base64.b64decode(CONTENT))

        # read
        ff.seek(0, 0)
        f = Gadget1File(ff.name, ptype=0)

        assert(f.attrs['Time'] == 1.0)
        assert(f.attrs['BoxSize'] == 50000.0)
        assert f.size == 149
        f.read(['Position'], 0, f.size)
        f.read(['GadgetVelocity'], 0, f.size)
        f.read(['ID'], 0, f.size)
        f.read(['Mass'], 0, f.size)
        f.read(['InternalEnergy'], 0, f.size)
        f.read(['Density'], 0, f.size)
        f.read(['SmoothingLength'], 0, f.size)

        assert f.dtype['Position'].base == numpy.dtype('f4')
        assert f.dtype['ID'].base == numpy.dtype('i4')
        assert f.dtype['Density'].base == numpy.dtype('f4')

        f = Gadget1File(ff.name, ptype=1)
        assert(f.attrs['Time'] == 1.0)
        assert(f.attrs['BoxSize'] == 50000.0)
        assert(f.size == 152)
        f.read(['Position'], 0, f.size)
        f.read(['GadgetVelocity'], 0, f.size)
        f.read(['ID'], 0, f.size)
        f.read(['Mass'], 0, f.size)

        with pytest.raises(KeyError):
            f.read(['InternalEnergy'], 0, f.size)

        with pytest.raises(IndexError):
            f.read(['ID'], 0, f.size + 10)

# this is a simple snapshot file from Gadget2.
CONTENT="""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"""
