# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['iplib3', 'iplib3.constants']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'iplib3',
    'version': '0.2.1',
    'description': 'A modern, object-oriented approach to IP addresses.',
    'long_description': '# IPLib3\n\nA `pathlib.Path`-equivalent for IP addresses.\n\n<!-- Badge chain start -->\n[![License](https://img.shields.io/github/license/diapolo10/iplib3)](https://opensource.org/licenses/MIT)[![CodeFactor](https://www.codefactor.io/repository/github/diapolo10/iplib3/badge?logo=codefactor)](https://www.codefactor.io/repository/github/diapolo10/iplib3)![Build Status](https://github.com/diapolo10/iplib3/workflows/iplib3%20CI/badge.svg)![Last commit](https://img.shields.io/github/last-commit/diapolo10/iplib3?logo=github)[![codecov](https://codecov.io/gh/Diapolo10/iplib3/branch/main/graph/badge.svg?token=JUWGSVLIF3)](https://codecov.io/gh/Diapolo10/iplib3)  \n[![FOSSA Status](https://app.fossa.com/api/projects/git%2Bgithub.com%2FDiapolo10%2Fiplib3.svg?type=shield)](https://app.fossa.com/projects/git%2Bgithub.com%2FDiapolo10%2Fiplib3?ref=badge_shield)![Wheel](https://img.shields.io/pypi/wheel/iplib3?logo=pypi)![Downloads](https://img.shields.io/pypi/dm/iplib3?logo=pypi)[![Version](https://img.shields.io/pypi/v/iplib3)](https://pypi.org/project/iplib3/)[![Rating](https://img.shields.io/librariesio/sourcerank/pypi/iplib3)](https://libraries.io/github/Diapolo10/iplib3/sourcerank)  \n![Repository size](https://img.shields.io/github/repo-size/diapolo10/iplib3?logo=github)![Code size](https://img.shields.io/github/languages/code-size/diapolo10/iplib3?logo=github)![Lines of code](https://img.shields.io/tokei/lines/github/diapolo10/iplib3?logo=github)![Python versions](https://img.shields.io/pypi/pyversions/iplib3?logo=python)\n<!-- Broken/unused badges -->\n<!-- [![Coverage Status](https://coveralls.io/repos/github/Diapolo10/iplib3/badge.svg?branch=main?logo=coveralls)](https://coveralls.io/github/Diapolo10/iplib3?branch=main) -->\n<!-- ![File count](https://img.shields.io/github/directory-file-count/diapolo10/iplib3?logo=github) -->\n<!-- Badge chain end -->\n\nThis module was heavily inspired by the built-in `pathlib` module to provide a similar, flexible interface for IP addresses. `iplib3` can effortlessly convert between IPv4, IPv6, raw numbers and hex values and it can also verify IP address syntax. It can recognise optional port numbers and store them separately from the main address. The `iplib.IPAddress` class works like `pathlib.Path` in that it accepts both IPv4 and IPv6 addresses, returning an object representing whichever format was used. The module also uses some unit tests, and these will be added more over time as functionality grows and becomes more set in stone.\n\nThe module is currently lacking in long-term vision as I used it as a practice project, but there are some plans to further flesh it out. It could incorporate URL support in the future and may be extended with `requests` integration.\n\nThis project is not affiliated with `iplib`, the naming similarity is merely a coincidence.\n\n\n[![FOSSA Status](https://app.fossa.com/api/projects/git%2Bgithub.com%2FDiapolo10%2Fiplib3.svg?type=large)](https://app.fossa.com/projects/git%2Bgithub.com%2FDiapolo10%2Fiplib3?ref=badge_large)\n\n## Installation\n\n`iplib3` will work with Python versions 3.6 and above. It could be back-ported to 3.5 or for even earlier versions with relatively little change, but the maintainer doesn\'t see a good reason to focus on earlier versions.\n\nThis module will not support Python 2.\n\nUse the package manager [`pip`](https://pip.pypa.io/en/stable/) to install `iplib3`.\n\nOn Windows:\n\n```sh\npy -m pip install iplib3\n```\n\nOn most Unix-like platforms:\n\n```sh\npip3 install iplib3\n```\n\nOn other platforms, you may try:\n\n```sh\npip install iplib3\n```\n\nThe library is distributed as wheels and source distributions, and the source distributions use Poetry as the build back-end instead of `setuptools`.\n\n## Usage\n\nThe module mainly provides a single class, `iplib3.IPAddress`, which can be used to initialise IP address objects of any supported type. However, it is possible to use the provided `iplib3.IPv4` and `iplib3.IPv6` classes directly if needed.\n\nThe primary class has the advantage that it also supports raw numbers; you can initialise it with any positive integer in addition to stringified addresses, and since you can directly convert between the two sub-classes at any time you can use all functionality with just `iplib3.IPAddress`. Since `iplib3.IPv4` and `iplib3.IPv6` are subclasses of `iplib3.IPAddress`, you can use `isinstance` to recognise any of the three types.\n\nSome basic usage examples:\n\n```python\nfrom iplib3 import IPAddress, IPv6\n\naddress = IPAddress(\'222.173.190.239\')\nprint(address) # 222.173.190.239\n\nprint(address.port) # None, because we never specified one\naddress.port = 80\nprint(address) # 222.173.190.239:80\n\nprint(repr(address)) # iplib3.IPv4(\'222.173.190.239:80\')\n\n\nipv6_address = address.as_ipv6\nprint(ipv6_address) # [0:0:0:0:0:0:DEAD:BEEF]:80\nipv6_address.port = None\nprint(ipv6_address) # 0:0:0:0:0:0:DEAD:BEEF\n\nprint(repr(ipv6_address)) # iplib3.IPv6(\'0:0:0:0:0:0:DEAD:BEEF\')\n\nfoo = IPv6(\'[::1337:1337:1337:1337]:25565\')\nbar = IPv6(\'::1337:1337:1337:1337\', 25565)\nbaz = IPv6(\'::1337:1337:1337:1337\', port_num=25565)\n\nprint(f"Addresses are {\'equal\' if foo == bar == baz else \'not equal\'}")\nprint(baz) # [::1337:1337:1337:1337]:25565\n\nprint(baz.as_ipv4.as_ipv6 == baz)\n\n# If the string contains a port number and you also provide a port separately,\n# then the separately provided port takes precedence\nspam = IPv6(\'[::1337:1337:1337:1337]:80\', port_num=25565)\nprint(spam) # [::1337:1337:1337:1337]:25565\n\nprint(address.hex) # 0xDEADBEEF\nprint(address.num) # 3735928559\n```\n\n## Contributing\n\nPull requests are welcome. For major changes, please open an issue first to discuss what you would like to change.\n\nPlease make sure to update tests as appropriate.\n\n## License\n\nThis project is licensed under an [MIT license](./LICENSE).\n\n[![FOSSA Status](https://app.fossa.com/api/projects/git%2Bgithub.com%2FDiapolo10%2Fiplib3.svg?type=large)](https://app.fossa.com/projects/git%2Bgithub.com%2FDiapolo10%2Fiplib3?ref=badge_large)\n',
    'author': 'Lari Liuhamo',
    'author_email': 'lari.liuhamo+pypi@gmail.com',
    'maintainer': 'Lari Liuhamo',
    'maintainer_email': 'lari.liuhamo+pypi@gmail.com',
    'url': 'https://pypi.org/project/iplib3/',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
