# Generated by Django 4.2.13 on 2024-06-28 00:26

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import simple_history.models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('openedx_ledger', '0010_transaction_parent_content_key'),
    ]

    operations = [
        migrations.CreateModel(
            name='SalesContractReferenceProvider',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(help_text='The pretty name of the contract reference provider.', max_length=255)),
                ('slug', models.SlugField(help_text='A unique slug for this sales contract reference provider.', max_length=32, unique=True)),
            ],
            options={
                'verbose_name': 'Sales Contract Reference Provider',
            },
        ),
        migrations.CreateModel(
            name='HistoricalDeposit',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('uuid', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False)),
                ('desired_deposit_quantity', models.BigIntegerField(help_text='How many units to deposit via related transaction.')),
                ('sales_contract_reference_id', models.CharField(db_index=True, help_text=('The reference ID for the specific sales contract which beget this deposit. The source system which ', 'stores the sales object is identified by the sales_contract_reference_provider field.'), max_length=255)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('ledger', models.ForeignKey(blank=True, db_constraint=False, help_text='The Ledger instance with which this deposit is associated.', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='openedx_ledger.ledger')),
                ('sales_contract_reference_provider', models.ForeignKey(blank=True, db_constraint=False, help_text='The system providing the source of truth for the sales contract which beget this deposit.', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='openedx_ledger.salescontractreferenceprovider')),
                ('transaction', models.ForeignKey(blank=True, db_constraint=False, help_text='The Transaction instance which represents this deposit and influences the balance of the relevant ledger.', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='openedx_ledger.transaction')),
            ],
            options={
                'verbose_name': 'historical deposit',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='Deposit',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('desired_deposit_quantity', models.BigIntegerField(help_text='How many units to deposit via related transaction.')),
                ('sales_contract_reference_id', models.CharField(db_index=True, help_text=('The reference ID for the specific sales contract which beget this deposit. The source system which ', 'stores the sales object is identified by the sales_contract_reference_provider field.'), max_length=255)),
                ('ledger', models.ForeignKey(help_text='The Ledger instance with which this deposit is associated.', on_delete=django.db.models.deletion.CASCADE, related_name='deposits', to='openedx_ledger.ledger')),
                ('sales_contract_reference_provider', models.ForeignKey(help_text='The system providing the source of truth for the sales contract which beget this deposit.', on_delete=django.db.models.deletion.CASCADE, related_name='deposits', to='openedx_ledger.salescontractreferenceprovider')),
                ('transaction', models.OneToOneField(help_text='The Transaction instance which represents this deposit and influences the balance of the relevant ledger.', on_delete=django.db.models.deletion.CASCADE, related_name='deposit', to='openedx_ledger.transaction')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
