# Generated by Django 3.2.19 on 2023-10-16 16:26

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import simple_history.models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('openedx_ledger', '0007_alter_externalfulfillmentprovider_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalAdjustment',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('uuid', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False)),
                ('adjustment_quantity', models.BigIntegerField(help_text='How many units to adjust for in the related transaction.')),
                ('reason', models.CharField(choices=[('unauthorized_enrollment', 'Unauthorized enrollment'), ('poor_content_fit', 'Poor content fit'), ('technical_challenges', 'Technical challenges'), ('missed_refund_or_date', 'Missed refund or date'), ('good_faith', 'Good faith/Relationship building')], db_index=True, default='technical_challenges', help_text='The primary reason for the existence of this adjustment.', max_length=255)),
                ('notes', models.TextField(blank=True, help_text='Any additional context you have for the existence of this adjustment.', null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('ledger', models.ForeignKey(blank=True, db_constraint=False, help_text='The Ledger instance with which this Adjustment is associated.', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='openedx_ledger.ledger')),
                ('transaction', models.ForeignKey(blank=True, db_constraint=False, help_text='The Transaction instance which adjusts the balance of the relevant ledger.', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='openedx_ledger.transaction')),
                ('transaction_of_interest', models.ForeignKey(blank=True, db_constraint=False, help_text='Any transaction of interest w.r.t. the reason for being of this adjustment. For example, the transaction of interest may point to some transaction record for which the enrolling user is unsatisfied, but for which we cannot issue a reversal due to business rules.', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='openedx_ledger.transaction')),
            ],
            options={
                'verbose_name': 'historical adjustment',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='Adjustment',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('adjustment_quantity', models.BigIntegerField(help_text='How many units to adjust for in the related transaction.')),
                ('reason', models.CharField(choices=[('unauthorized_enrollment', 'Unauthorized enrollment'), ('poor_content_fit', 'Poor content fit'), ('technical_challenges', 'Technical challenges'), ('missed_refund_or_date', 'Missed refund or date'), ('good_faith', 'Good faith/Relationship building')], db_index=True, default='technical_challenges', help_text='The primary reason for the existence of this adjustment.', max_length=255)),
                ('notes', models.TextField(blank=True, help_text='Any additional context you have for the existence of this adjustment.', null=True)),
                ('ledger', models.ForeignKey(help_text='The Ledger instance with which this Adjustment is associated.', on_delete=django.db.models.deletion.CASCADE, related_name='adjustments', to='openedx_ledger.ledger')),
                ('transaction', models.OneToOneField(help_text='The Transaction instance which adjusts the balance of the relevant ledger.', on_delete=django.db.models.deletion.CASCADE, related_name='adjustment', to='openedx_ledger.transaction')),
                ('transaction_of_interest', models.OneToOneField(blank=True, help_text='Any transaction of interest w.r.t. the reason for being of this adjustment. For example, the transaction of interest may point to some transaction record for which the enrolling user is unsatisfied, but for which we cannot issue a reversal due to business rules.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='adjustment_of_interest', to='openedx_ledger.transaction')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
