# Generated by Django 3.2.18 on 2023-03-23 12:51

from django.db import migrations, models
import django.db.models.deletion
import jsonfield.fields


class Migration(migrations.Migration):

    dependencies = [
        ('openedx_ledger', '0004_ledger_idpkey_blankable'),
    ]

    operations = [
        migrations.AlterField(
            model_name='historicalledger',
            name='idempotency_key',
            field=models.CharField(blank=True, db_index=True, help_text='An idempotency key is a unique value generated by the client of the Ledger API which the Ledger and Transaction APIs use to recognize subsequent retries of the same redemption (i.e. a Transaction that leads to the fulfillment of an enrollment or entitlement for a particular user id in a particular content key.We suggest incorporating V4 UUIDs along with sufficiently unique or random values representing the desired redemption to avoid unintended collisions.Utility methods are provided in the ``utils.py`` module to help clients generate appropriate idempotency keys.', max_length=255),
        ),
        migrations.AlterField(
            model_name='historicalledger',
            name='metadata',
            field=jsonfield.fields.JSONField(blank=True, help_text='Any additionaly metadata that a client may want to associate with this Ledger instance.', null=True),
        ),
        migrations.AlterField(
            model_name='historicalledger',
            name='unit',
            field=models.CharField(choices=[('usd_cents', 'U.S. Dollar (Cents)'), ('seats', 'Seats in a course')], db_index=True, default='usd_cents', help_text='The unit in which Transaction quantities related to this Ledger instance are denominated.', max_length=255),
        ),
        migrations.AlterField(
            model_name='historicalreversal',
            name='idempotency_key',
            field=models.CharField(db_index=True, help_text="An idempotency key is a unique value generated by the client of the Ledger API which the Ledger and Transaction APIs use to recognize subsequent retries of the same redemption (i.e. a Transaction that leads to the fulfillment of an enrollment or entitlement for a particular user id in a particular content key).We suggest incorporating V4 UUIDs along with sufficiently unique or random values representing the desired redemption to avoid unintended collisions.In particular, a Transaction's idempotency_key should incorporate it's corresponding ledger's idempotency_key.Utility methods are provided in the ``utils.py`` module to help clients generate appropriate idempotency keys.", max_length=255),
        ),
        migrations.AlterField(
            model_name='historicalreversal',
            name='metadata',
            field=jsonfield.fields.JSONField(blank=True, help_text='Any additionaly metadata that a client may want to associate with this Transaction.', null=True),
        ),
        migrations.AlterField(
            model_name='historicalreversal',
            name='quantity',
            field=models.BigIntegerField(help_text='How many units (as defined in the associated Ledger instance) this Transaction represents.'),
        ),
        migrations.AlterField(
            model_name='historicalreversal',
            name='state',
            field=models.CharField(choices=[('created', 'Created'), ('pending', 'Pending'), ('committed', 'Committed'), ('failed', 'Failed')], db_index=True, default='created', help_text="The current state of the Transaction. One of: ['Created', 'Pending', 'Committed', 'Failed']", max_length=255),
        ),
        migrations.AlterField(
            model_name='historicalreversal',
            name='transaction',
            field=models.ForeignKey(blank=True, db_constraint=False, help_text='The Transaction instance which is reversed by this Reversal instance.', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='openedx_ledger.transaction'),
        ),
        migrations.AlterField(
            model_name='historicaltransaction',
            name='idempotency_key',
            field=models.CharField(db_index=True, help_text="An idempotency key is a unique value generated by the client of the Ledger API which the Ledger and Transaction APIs use to recognize subsequent retries of the same redemption (i.e. a Transaction that leads to the fulfillment of an enrollment or entitlement for a particular user id in a particular content key).We suggest incorporating V4 UUIDs along with sufficiently unique or random values representing the desired redemption to avoid unintended collisions.In particular, a Transaction's idempotency_key should incorporate it's corresponding ledger's idempotency_key.Utility methods are provided in the ``utils.py`` module to help clients generate appropriate idempotency keys.", max_length=255),
        ),
        migrations.AlterField(
            model_name='historicaltransaction',
            name='ledger',
            field=models.ForeignKey(blank=True, db_constraint=False, help_text='The Ledger instance with which this Transaction is associated.', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='openedx_ledger.ledger'),
        ),
        migrations.AlterField(
            model_name='historicaltransaction',
            name='lms_user_id',
            field=models.IntegerField(blank=True, db_index=True, help_text='The id of the Open edX LMS user record with which this Transaction is associated.', null=True),
        ),
        migrations.AlterField(
            model_name='historicaltransaction',
            name='metadata',
            field=jsonfield.fields.JSONField(blank=True, help_text='Any additionaly metadata that a client may want to associate with this Transaction.', null=True),
        ),
        migrations.AlterField(
            model_name='historicaltransaction',
            name='quantity',
            field=models.BigIntegerField(help_text='How many units (as defined in the associated Ledger instance) this Transaction represents.'),
        ),
        migrations.AlterField(
            model_name='historicaltransaction',
            name='state',
            field=models.CharField(choices=[('created', 'Created'), ('pending', 'Pending'), ('committed', 'Committed'), ('failed', 'Failed')], db_index=True, default='created', help_text="The current state of the Transaction. One of: ['Created', 'Pending', 'Committed', 'Failed']", max_length=255),
        ),
        migrations.AlterField(
            model_name='ledger',
            name='idempotency_key',
            field=models.CharField(blank=True, help_text='An idempotency key is a unique value generated by the client of the Ledger API which the Ledger and Transaction APIs use to recognize subsequent retries of the same redemption (i.e. a Transaction that leads to the fulfillment of an enrollment or entitlement for a particular user id in a particular content key.We suggest incorporating V4 UUIDs along with sufficiently unique or random values representing the desired redemption to avoid unintended collisions.Utility methods are provided in the ``utils.py`` module to help clients generate appropriate idempotency keys.', max_length=255, unique=True),
        ),
        migrations.AlterField(
            model_name='ledger',
            name='metadata',
            field=jsonfield.fields.JSONField(blank=True, help_text='Any additionaly metadata that a client may want to associate with this Ledger instance.', null=True),
        ),
        migrations.AlterField(
            model_name='ledger',
            name='unit',
            field=models.CharField(choices=[('usd_cents', 'U.S. Dollar (Cents)'), ('seats', 'Seats in a course')], db_index=True, default='usd_cents', help_text='The unit in which Transaction quantities related to this Ledger instance are denominated.', max_length=255),
        ),
        migrations.AlterField(
            model_name='reversal',
            name='idempotency_key',
            field=models.CharField(db_index=True, help_text="An idempotency key is a unique value generated by the client of the Ledger API which the Ledger and Transaction APIs use to recognize subsequent retries of the same redemption (i.e. a Transaction that leads to the fulfillment of an enrollment or entitlement for a particular user id in a particular content key).We suggest incorporating V4 UUIDs along with sufficiently unique or random values representing the desired redemption to avoid unintended collisions.In particular, a Transaction's idempotency_key should incorporate it's corresponding ledger's idempotency_key.Utility methods are provided in the ``utils.py`` module to help clients generate appropriate idempotency keys.", max_length=255),
        ),
        migrations.AlterField(
            model_name='reversal',
            name='metadata',
            field=jsonfield.fields.JSONField(blank=True, help_text='Any additionaly metadata that a client may want to associate with this Transaction.', null=True),
        ),
        migrations.AlterField(
            model_name='reversal',
            name='quantity',
            field=models.BigIntegerField(help_text='How many units (as defined in the associated Ledger instance) this Transaction represents.'),
        ),
        migrations.AlterField(
            model_name='reversal',
            name='state',
            field=models.CharField(choices=[('created', 'Created'), ('pending', 'Pending'), ('committed', 'Committed'), ('failed', 'Failed')], db_index=True, default='created', help_text="The current state of the Transaction. One of: ['Created', 'Pending', 'Committed', 'Failed']", max_length=255),
        ),
        migrations.AlterField(
            model_name='reversal',
            name='transaction',
            field=models.OneToOneField(help_text='The Transaction instance which is reversed by this Reversal instance.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='reversal', to='openedx_ledger.transaction'),
        ),
        migrations.AlterField(
            model_name='transaction',
            name='idempotency_key',
            field=models.CharField(db_index=True, help_text="An idempotency key is a unique value generated by the client of the Ledger API which the Ledger and Transaction APIs use to recognize subsequent retries of the same redemption (i.e. a Transaction that leads to the fulfillment of an enrollment or entitlement for a particular user id in a particular content key).We suggest incorporating V4 UUIDs along with sufficiently unique or random values representing the desired redemption to avoid unintended collisions.In particular, a Transaction's idempotency_key should incorporate it's corresponding ledger's idempotency_key.Utility methods are provided in the ``utils.py`` module to help clients generate appropriate idempotency keys.", max_length=255),
        ),
        migrations.AlterField(
            model_name='transaction',
            name='ledger',
            field=models.ForeignKey(help_text='The Ledger instance with which this Transaction is associated.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='transactions', to='openedx_ledger.ledger'),
        ),
        migrations.AlterField(
            model_name='transaction',
            name='lms_user_id',
            field=models.IntegerField(blank=True, db_index=True, help_text='The id of the Open edX LMS user record with which this Transaction is associated.', null=True),
        ),
        migrations.AlterField(
            model_name='transaction',
            name='metadata',
            field=jsonfield.fields.JSONField(blank=True, help_text='Any additionaly metadata that a client may want to associate with this Transaction.', null=True),
        ),
        migrations.AlterField(
            model_name='transaction',
            name='quantity',
            field=models.BigIntegerField(help_text='How many units (as defined in the associated Ledger instance) this Transaction represents.'),
        ),
        migrations.AlterField(
            model_name='transaction',
            name='state',
            field=models.CharField(choices=[('created', 'Created'), ('pending', 'Pending'), ('committed', 'Committed'), ('failed', 'Failed')], db_index=True, default='created', help_text="The current state of the Transaction. One of: ['Created', 'Pending', 'Committed', 'Failed']", max_length=255),
        ),
        migrations.AlterIndexTogether(
            name='transaction',
            index_together={('ledger', 'subsidy_access_policy_uuid'), ('ledger', 'content_key'), ('ledger', 'lms_user_id', 'content_key')},
        ),
    ]
