"""This module contains dicts containing thermal demand profiles"""


def accommodation():
    config = {
        "name": "accommodation",
        "load_profile": [
            0.026,
            0.028,
            0.028,
            0.035,
            0.045,
            0.047,
            0.062,
            0.071,
            0.051,
            0.043,
            0.044,
            0.039,
            0.038,
            0.035,
            0.036,
            0.036,
            0.036,
            0.042,
            0.043,
            0.048,
            0.048,
            0.047,
            0.413,
            0.033,
        ],
        "A": 0.9874283,
        "B": -35.2532124,
        "C": 6.1544406,
        "D": 0.2265716,
        "V_0": 40.0,
        "M_H": -0.0339020,
        "B_H": 0.6938234,
        "M_W": -0.0012849,
        "B_W": 0.2029732,
        "weekday_constants": [0.977, 1.039, 1.003, 1.016, 1.002, 1.004, 0.958],
        "consumer_constant": 13_698.63,
    }
    return config


def accommodation_hospital():
    config = {
        "name": "accommodation_hospital",
        "load_profile": [
            0.026,
            0.028,
            0.028,
            0.035,
            0.045,
            0.047,
            0.062,
            0.071,
            0.051,
            0.043,
            0.044,
            0.039,
            0.038,
            0.035,
            0.036,
            0.036,
            0.036,
            0.042,
            0.043,
            0.048,
            0.048,
            0.047,
            0.413,
            0.033,
        ],
        "A": 0.9874283,
        "B": -35.2532124,
        "C": 6.1544406,
        "D": 0.2265716,
        "V_0": 40.0,
        "M_H": -0.0339020,
        "B_H": 0.6938234,
        "M_W": -0.0012849,
        "B_W": 0.2029732,
        "weekday_constants": [0.977, 1.039, 1.003, 1.016, 1.002, 1.004, 0.958],
        "consumer_constant": 18_000,
    }
    return config


def bakery():
    config = {
        "name": "bakery",
        "load_profile": [
            0.054,
            0.093,
            0.120,
            0.111,
            0.104,
            0.091,
            0.066,
            0.053,
            0.046,
            0.035,
            0.028,
            0.027,
            0.018,
            0.009,
            0.007,
            0.005,
            0.004,
            0.006,
            0.008,
            0.013,
            0.020,
            0.015,
            0.016,
            0.052,
        ],
        "A": 0.2770087,
        "B": -33.0000000,
        "C": 5.7212303,
        "D": 0.4865118,
        "V_0": 40.0,
        "M_H": -0.0094849,
        "B_H": 0.4630237,
        "M_W": -0.0007134,
        "B_W": 0.3867447,
        "weekday_constants": [1.085, 1.121, 1.077, 1.135, 1.140, 0.485, 0.958],
        "consumer_constant": 2_712.33,
    }
    return config


def business_swimmingpool():
    config = {
        "name": "business_swimmingpool",
        "load_profile": [
            0.022,
            0.021,
            0.021,
            0.023,
            0.034,
            0.053,
            0.060,
            0.055,
            0.052,
            0.049,
            0.046,
            0.044,
            0.043,
            0.042,
            0.040,
            0.040,
            0.042,
            0.044,
            0.047,
            0.051,
            0.052,
            0.050,
            0.041,
            0.029,
        ],
        "A": 1.2328655,
        "B": -34.7213605,
        "C": 5.8164304,
        "D": 0.0873352,
        "V_0": 40.0,
        "M_H": -0.0409284,
        "B_H": 0.7672920,
        "M_W": -0.0022320,
        "B_W": 0.1199207,
        "weekday_constants": [1.035, 1.052, 1.045, 1.049, 0.989, 0.886, 0.944],
        "consumer_constant": 8_205.335,
    }
    return config


def laundry():
    config = {
        "name": "laundry",
        "load_profile": [
            0.005,
            0.004,
            0.005,
            0.010,
            0.024,
            0.039,
            0.055,
            0.064,
            0.081,
            0.081,
            0.082,
            0.087,
            0.077,
            0.067,
            0.046,
            0.047,
            0.048,
            0.050,
            0.028,
            0.028,
            0.025,
            0.022,
            0.016,
            0.010,
        ],
        "A": 0.3337838,
        "B": -36.0237912,
        "C": 4.8662747,
        "D": 0.4912280,
        "V_0": 40.0,
        "M_H": -0.0092263,
        "B_H": 0.4595757,
        "M_W": -0.0009676,
        "B_W": 0.3964291,
        "weekday_constants": [1.246, 1.262, 1.271, 1.243, 1.128, 0.388, 0.462],
        "consumer_constant": 342.47,
    }
    return config


def metal_kfz():
    config = {
        "name": "metal_kfz",
        "load_profile": [
            0.035,
            0.035,
            0.036,
            0.036,
            0.037,
            0.039,
            0.046,
            0.066,
            0.067,
            0.070,
            0.055,
            0.052,
            0.041,
            0.038,
            0.044,
            0.047,
            0.041,
            0.029,
            0.026,
            0.029,
            0.031,
            0.035,
            0.033,
            0.034,
        ],
        "A": 1.4202419,
        "B": -34.8806130,
        "C": 6.5951899,
        "D": 0.0385317,
        "V_0": 40.0,
        "M_H": -0.0521084,
        "B_H": 0.8647919,
        "M_W": -0.0014369,
        "B_W": 0.0637602,
        "weekday_constants": [1.070, 1.365, 0.993, 0.995, 1.066, 0.936, 0.903],
        "consumer_constant": 1_132.423,
    }
    return config


def multy_family():
    config = {
        "name": "multi_family",
        "load_profile": [
            0.0221,
            0.0215,
            0.0208,
            0.0231,
            0.0343,
            0.0526,
            0.0605,
            0.0550,
            0.0521,
            0.0487,
            0.0463,
            0.0439,
            0.0429,
            0.0416,
            0.0401,
            0.0404,
            0.0415,
            0.0436,
            0.0470,
            0.0505,
            0.0518,
            0.0496,
            0.0409,
            0.0292,
        ],
        "A": 1.2328655,
        "B": -34.7213605,
        "C": 5.8164304,
        "D": 0.0873352,
        "V_0": 40.0,
        "M_H": -0.0409284,
        "B_H": 0.7672920,
        "M_W": -0.0022320,
        "B_W": 0.1199207,
        "weekday_constants": [1, 1, 1, 1, 1, 1, 1],
        "consumer_constant": 211.97,
    }
    return config


def one_family():
    config = {
        "name": "one_family",
        "load_profile": [
            0.0142,
            0.0155,
            0.0167,
            0.0200,
            0.0298,
            0.0540,
            0.0685,
            0.0679,
            0.0578,
            0.0527,
            0.0478,
            0.0435,
            0.0415,
            0.0402,
            0.0399,
            0.0414,
            0.0441,
            0.0477,
            0.0515,
            0.0552,
            0.0535,
            0.0474,
            0.0315,
            0.0177,
        ],
        "A": 1.6209544,
        "B": -37.183314,
        "C": 5.6727847,
        "D": 0.0716431,
        "V_0": 40.0,
        "M_H": -0.0495700,
        "B_H": 0.8401015,
        "M_W": -0.0022090,
        "B_W": 0.1074468,
        "weekday_constants": [1, 1, 1, 1, 1, 1, 1],
        "consumer_constant": 70.9863,
    }
    return config


def paper_print():
    config = {
        "name": "paper_print",
        "load_profile": [
            0.035,
            0.035,
            0.036,
            0.038,
            0.045,
            0.046,
            0.062,
            0.060,
            0.062,
            0.052,
            0.045,
            0.044,
            0.042,
            0.040,
            0.039,
            0.037,
            0.037,
            0.037,
            0.036,
            0.034,
            0.034,
            0.035,
            0.035,
            0.034,
        ],
        "A": 1.7110739,
        "B": -35.8000000,
        "C": 8.4000000,
        "D": 0.0702546,
        "V_0": 40.0,
        "M_H": -0.0745381,
        "B_H": 1.0463005,
        "M_W": -0.0003672,
        "B_W": 0.0621882,
        "weekday_constants": [1.021, 1.087, 1.072, 1.056, 1.012, 0.900, 0.851],
        "consumer_constant": 1_922.375633,
    }
    return config


def restaurant():
    config = {
        "name": "restaurant",
        "load_profile": [
            0.040,
            0.040,
            0.030,
            0.030,
            0.029,
            0.035,
            0.046,
            0.053,
            0.050,
            0.047,
            0.048,
            0.049,
            0.043,
            0.042,
            0.038,
            0.047,
            0.035,
            0.043,
            0.043,
            0.042,
            0.043,
            0.045,
            0.043,
            0.041,
        ],
        "A": 1.1582082,
        "B": -36.2878584,
        "C": 6.5885126,
        "D": 0.2235680,
        "V_0": 40.0,
        "M_H": -0.0410335,
        "B_H": 0.7526451,
        "M_W": -0.0009088,
        "B_W": 0.1916641,
        "weekday_constants": [0.932, 0.989, 1.003, 1.011, 1.018, 1.036, 1.009],
        "consumer_constant": 5_458.7478,
    }
    return config


def store():
    config = {
        "name": "store",
        "load_profile": [
            0.025,
            0.028,
            0.034,
            0.036,
            0.038,
            0.057,
            0.076,
            0.083,
            0.069,
            0.061,
            0.050,
            0.045,
            0.041,
            0.038,
            0.033,
            0.032,
            0.032,
            0.031,
            0.035,
            0.039,
            0.034,
            0.033,
            0.026,
            0.023,
        ],
        "A": 0.19724775,
        "B": -36.9650065,
        "C": 7.2256947,
        "D": 0.0345782,
        "V_0": 40.0,
        "M_H": -0.0742174,
        "B_H": 1.0448869,
        "M_W": -0.0008295,
        "B_W": 0.0461795,
        "weekday_constants": [1.036, 1.023, 1.025, 1.030, 1.025, 0.968, 0.893],
        "consumer_constant": 140.98537,
    }
    return config
