"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackApp = exports.SlackAppManifestDefinition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const secretsmanager = require("aws-cdk-lib/aws-secretsmanager");
const constructs_1 = require("constructs");
const manifest_1 = require("./manifest");
const provider_1 = require("./provider");
/**
 * A Slack app manifest definition
 */
class SlackAppManifestDefinition {
    /**
     * Create a Slack app manifest from a JSON app manifest encoded as a string
     */
    static fromString(manifest) {
        return new StringManifest(manifest);
    }
    /**
     * Creates a Slack app manifest from a file containg a JSON app manifest
     */
    static fromFile(file) {
        return new FileManifest(file);
    }
    /**
     * Creates a Slack app manifest by specifying properties
     */
    static fromManifest(props) {
        return new manifest_1.SlackAppManifest(props);
    }
}
exports.SlackAppManifestDefinition = SlackAppManifestDefinition;
_a = JSII_RTTI_SYMBOL_1;
SlackAppManifestDefinition[_a] = { fqn: "cloudstructs.SlackAppManifestDefinition", version: "0.5.6" };
class StringManifest extends SlackAppManifestDefinition {
    constructor(manifest) {
        super();
        this.manifest = manifest;
    }
    render(_construct) {
        return this.manifest;
    }
}
class FileManifest extends SlackAppManifestDefinition {
    constructor(file) {
        super();
        this.file = file;
    }
    render(_construct) {
        return fs.readFileSync(this.file, 'utf8');
    }
}
/**
 * A Slack application deployed with a manifest
 *
 * @see https://api.slack.com/reference/manifests
 */
class SlackApp extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const provider = provider_1.SlackAppProvider.getOrCreate(this);
        props.configurationTokenSecret.grantRead(provider.handler);
        props.configurationTokenSecret.grantWrite(provider.handler);
        this.credentials = props.credentialsSecret ?? new secretsmanager.Secret(this, 'Credentials', {
            description: `Credentials for Slack App ${this.node.id}`,
        });
        this.credentials.grantWrite(provider.handler);
        const resource = new aws_cdk_lib_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::SlackApp',
            properties: {
                manifest: props.manifest.render(this),
                configurationTokenSecretArn: props.configurationTokenSecret.secretArn,
                credentialsSecretArn: this.credentials.secretArn,
            },
        });
        this.appId = resource.getAttString('appId');
        this.clientId = this.credentials.secretValueFromJson('clientId').toString();
        this.clientSecret = this.credentials.secretValueFromJson('clientSecret').toString();
        this.verificationToken = this.credentials.secretValueFromJson('verificationToken').toString();
        this.signingSecret = this.credentials.secretValueFromJson('signingSecret').toString();
    }
}
exports.SlackApp = SlackApp;
_b = JSII_RTTI_SYMBOL_1;
SlackApp[_b] = { fqn: "cloudstructs.SlackApp", version: "0.5.6" };
//# sourceMappingURL=data:application/json;base64,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