import { Construct } from '@aws-cdk/core';
import { IFunction } from './function-base';
/**
 * A destination configuration.
 *
 * @stability stable
 */
export interface DestinationConfig {
    /**
     * The Amazon Resource Name (ARN) of the destination resource.
     *
     * @stability stable
     */
    readonly destination: string;
}
/**
 * The type of destination.
 *
 * @stability stable
 */
export declare enum DestinationType {
    /**
     * Failure.
     *
     * @stability stable
     */
    FAILURE = "Failure",
    /**
     * Success.
     *
     * @stability stable
     */
    SUCCESS = "Success"
}
/**
 * Options when binding a destination to a function.
 *
 * @stability stable
 */
export interface DestinationOptions {
    /**
     * The destination type.
     *
     * @stability stable
     */
    readonly type: DestinationType;
}
/**
 * A Lambda destination.
 *
 * @stability stable
 */
export interface IDestination {
    /**
     * Binds this destination to the Lambda function.
     *
     * @stability stable
     */
    bind(scope: Construct, fn: IFunction, options?: DestinationOptions): DestinationConfig;
}
