#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['parselglossy', 'parselglossy.grammars']

package_data = \
{'': ['*']}

install_requires = \
['click', 'pyparsing', 'pyyaml', 'networkx']

extras_require = \
{'dev': ['black', 'flake8', 'isort', 'mypy'],
 'doc': ['sphinx', 'guzzle_sphinx_theme'],
 'test': ['codecov',
          'coverage',
          'hypothesis',
          'pytest',
          'pytest-black',
          'pytest-cov',
          'pytest-flake8',
          'pytest-mypy',
          'pytest-sugar']}

entry_points = \
{'console_scripts': ['parselglossy = parselglossy.cli:cli']}

setup(name='parselglossy',
      version='0.5.0',
      description='Top-level package for parselglossy.',
      author='Roberto Di Remigio',
      author_email=None,
      url='https://parselglossy.readthedocs.io',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='~=3.6',
     )
