import terrascript.core as core


@core.resource(type="aws_db_event_subscription", namespace="rds")
class DbEventSubscription(core.Resource):
    """
    The Amazon Resource Name of the RDS event notification subscription
    """

    arn: str | core.StringOut = core.attr(str, computed=True)

    """
    The AWS customer account associated with the RDS event notification subscription
    """
    customer_aws_id: str | core.StringOut = core.attr(str, computed=True)

    """
    (Optional) A boolean flag to enable/disable the subscription. Defaults to true.
    """
    enabled: bool | core.BoolOut | None = core.attr(bool, default=None)

    """
    (Optional) A list of event categories for a SourceType that you want to subscribe to. See http://doc
    s.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html or run `aws rds describe-event-categori
    es`.
    """
    event_categories: list[str] | core.ArrayOut[core.StringOut] | None = core.attr(
        str, default=None, kind=core.Kind.array
    )

    """
    The name of the RDS event notification subscription
    """
    id: str | core.StringOut = core.attr(str, computed=True)

    """
    (Optional) The name of the DB event subscription. By default generated by Terraform.
    """
    name: str | core.StringOut | None = core.attr(str, default=None, computed=True)

    """
    (Optional) The name of the DB event subscription. Conflicts with `name`.
    """
    name_prefix: str | core.StringOut | None = core.attr(str, default=None, computed=True)

    """
    (Required) The SNS topic to send events to.
    """
    sns_topic: str | core.StringOut = core.attr(str)

    """
    (Optional) A list of identifiers of the event sources for which events will be returned. If not spec
    ified, then all sources are included in the response. If specified, a source_type must also be speci
    fied.
    """
    source_ids: list[str] | core.ArrayOut[core.StringOut] | None = core.attr(
        str, default=None, kind=core.Kind.array
    )

    """
    (Optional) The type of source that will be generating the events. Valid options are `db-instance`, `
    db-security-group`, `db-parameter-group`, `db-snapshot`, `db-cluster` or `db-cluster-snapshot`. If n
    ot set, all sources will be subscribed to.
    """
    source_type: str | core.StringOut | None = core.attr(str, default=None)

    """
    (Optional) A map of tags to assign to the resource. If configured with a provider [`default_tags` co
    nfiguration block](https://registry.terraform.io/providers/hashicorp/aws/latest/docs#default_tags-co
    nfiguration-block) present, tags with matching keys will overwrite those defined at the provider-lev
    el.
    """
    tags: dict[str, str] | core.MapOut[core.StringOut] | None = core.attr(
        str, default=None, kind=core.Kind.map
    )

    """
    A map of tags assigned to the resource, including those inherited from the provider [`default_tags`
    configuration block](https://registry.terraform.io/providers/hashicorp/aws/latest/docs#default_tags-
    configuration-block).
    """
    tags_all: dict[str, str] | core.MapOut[core.StringOut] | None = core.attr(
        str, default=None, computed=True, kind=core.Kind.map
    )

    def __init__(
        self,
        resource_name: str,
        *,
        sns_topic: str | core.StringOut,
        enabled: bool | core.BoolOut | None = None,
        event_categories: list[str] | core.ArrayOut[core.StringOut] | None = None,
        name: str | core.StringOut | None = None,
        name_prefix: str | core.StringOut | None = None,
        source_ids: list[str] | core.ArrayOut[core.StringOut] | None = None,
        source_type: str | core.StringOut | None = None,
        tags: dict[str, str] | core.MapOut[core.StringOut] | None = None,
        tags_all: dict[str, str] | core.MapOut[core.StringOut] | None = None,
        depends_on: list[str] | core.ArrayOut[core.StringOut] | None = None,
        provider: str | core.StringOut | None = None,
        lifecycle: core.Lifecycle | None = None,
    ):
        super().__init__(
            name=resource_name,
            args=DbEventSubscription.Args(
                sns_topic=sns_topic,
                enabled=enabled,
                event_categories=event_categories,
                name=name,
                name_prefix=name_prefix,
                source_ids=source_ids,
                source_type=source_type,
                tags=tags,
                tags_all=tags_all,
                depends_on=depends_on,
                provider=provider,
                lifecycle=lifecycle,
            ),
        )

    @core.schema_args
    class Args(core.Resource.Args):
        enabled: bool | core.BoolOut | None = core.arg(default=None)

        event_categories: list[str] | core.ArrayOut[core.StringOut] | None = core.arg(default=None)

        name: str | core.StringOut | None = core.arg(default=None)

        name_prefix: str | core.StringOut | None = core.arg(default=None)

        sns_topic: str | core.StringOut = core.arg()

        source_ids: list[str] | core.ArrayOut[core.StringOut] | None = core.arg(default=None)

        source_type: str | core.StringOut | None = core.arg(default=None)

        tags: dict[str, str] | core.MapOut[core.StringOut] | None = core.arg(default=None)

        tags_all: dict[str, str] | core.MapOut[core.StringOut] | None = core.arg(default=None)
