import terrascript.core as core


@core.resource(type="aws_lambda_permission", namespace="lambda_")
class Permission(core.Resource):
    """
    (Required) The AWS Lambda action you want to allow in this statement. (e.g., `lambda:InvokeFunction`
    )
    """

    action: str | core.StringOut = core.attr(str)

    """
    (Optional) The Event Source Token to validate.  Used with [Alexa Skills][1].
    """
    event_source_token: str | core.StringOut | None = core.attr(str, default=None)

    """
    (Required) Name of the Lambda function whose resource policy you are updating
    """
    function_name: str | core.StringOut = core.attr(str)

    """
    (Optional) Lambda Function URLs [authentication type][3]. Valid values are: `AWS_IAM` or `NONE`.
    """
    function_url_auth_type: str | core.StringOut | None = core.attr(str, default=None)

    id: str | core.StringOut = core.attr(str, computed=True)

    """
    (Required) The principal who is getting this permission e.g., `s3.amazonaws.com`, an AWS account ID,
    or any valid AWS service principal such as `events.amazonaws.com` or `sns.amazonaws.com`.
    """
    principal: str | core.StringOut = core.attr(str)

    """
    (Optional) The identifier for your organization in AWS Organizations. Use this to grant permissions
    to all the AWS accounts under this organization.
    """
    principal_org_id: str | core.StringOut | None = core.attr(str, default=None)

    """
    (Optional) Query parameter to specify function version or alias name. The permission will then apply
    to the specific qualified ARN e.g., `arn:aws:lambda:aws-region:acct-id:function:function-name:2`
    """
    qualifier: str | core.StringOut | None = core.attr(str, default=None)

    """
    (Optional) This parameter is used for S3 and SES. The AWS account ID (without a hyphen) of the sourc
    e owner.
    """
    source_account: str | core.StringOut | None = core.attr(str, default=None)

    """
    (Optional) When the principal is an AWS service, the ARN of the specific resource within that servic
    e to grant permission to.
    """
    source_arn: str | core.StringOut | None = core.attr(str, default=None)

    """
    (Optional) A unique statement identifier. By default generated by Terraform.
    """
    statement_id: str | core.StringOut | None = core.attr(str, default=None, computed=True)

    """
    (Optional) A statement identifier prefix. Terraform will generate a unique suffix. Conflicts with `s
    tatement_id`.
    """
    statement_id_prefix: str | core.StringOut | None = core.attr(str, default=None, computed=True)

    def __init__(
        self,
        resource_name: str,
        *,
        action: str | core.StringOut,
        function_name: str | core.StringOut,
        principal: str | core.StringOut,
        event_source_token: str | core.StringOut | None = None,
        function_url_auth_type: str | core.StringOut | None = None,
        principal_org_id: str | core.StringOut | None = None,
        qualifier: str | core.StringOut | None = None,
        source_account: str | core.StringOut | None = None,
        source_arn: str | core.StringOut | None = None,
        statement_id: str | core.StringOut | None = None,
        statement_id_prefix: str | core.StringOut | None = None,
        depends_on: list[str] | core.ArrayOut[core.StringOut] | None = None,
        provider: str | core.StringOut | None = None,
        lifecycle: core.Lifecycle | None = None,
    ):
        super().__init__(
            name=resource_name,
            args=Permission.Args(
                action=action,
                function_name=function_name,
                principal=principal,
                event_source_token=event_source_token,
                function_url_auth_type=function_url_auth_type,
                principal_org_id=principal_org_id,
                qualifier=qualifier,
                source_account=source_account,
                source_arn=source_arn,
                statement_id=statement_id,
                statement_id_prefix=statement_id_prefix,
                depends_on=depends_on,
                provider=provider,
                lifecycle=lifecycle,
            ),
        )

    @core.schema_args
    class Args(core.Resource.Args):
        action: str | core.StringOut = core.arg()

        event_source_token: str | core.StringOut | None = core.arg(default=None)

        function_name: str | core.StringOut = core.arg()

        function_url_auth_type: str | core.StringOut | None = core.arg(default=None)

        principal: str | core.StringOut = core.arg()

        principal_org_id: str | core.StringOut | None = core.arg(default=None)

        qualifier: str | core.StringOut | None = core.arg(default=None)

        source_account: str | core.StringOut | None = core.arg(default=None)

        source_arn: str | core.StringOut | None = core.arg(default=None)

        statement_id: str | core.StringOut | None = core.arg(default=None)

        statement_id_prefix: str | core.StringOut | None = core.arg(default=None)
