'''
This code was copied from the straylight area of the BMG svn repo

These globals were refactored from the top of the straylight accessor because
some of them are also used by the thermal accessor.
'''


import os
from pandeia.engine.helpers.background.jwst.mod_healpix_func import *

bmg_url = os.environ.get('BMG_URL', 'NONE')

D2R = math.pi / 180.
R2D = 180. / math.pi

# C structure used to write the stray light binary file.
# One record per file.
#    typedef struct {
#              double pix_ra;
#              double pix_dec;
#              double pos[3];
#              double nonzodi_bg[SL_NWAVE];  // The in-field ism+cib for each pixel.
#            } sl_pix;
#              Then for every day with the target in the FOR,the following three items are written.
#              double day;
#              double zodi_bg[SL_NWAVE];  //  The combined in-field zodi for each pixel.
#              double stray_light_bg[SL_NWAVE];  //The equivalent in-field background from stray light from zodi, stellar,ism, cib

# Number of days in a year
NUM_DAYS = 366

'''
In principle, this wavelist should be identical (ideally, read from) the standard
wavelength set delivered with the BMG in bgmodel/inputs/std_spectrum_wavelengths.txt.

In practice, it must be identical to the waveset used BACK WHEN the cached data was
generated by other code in the straylight area of the BMG svn repo.

Note that the comment above, which describes the structure of that file, refers to [SL_NWAVE].
'''

#-----------------------------------------------------------------------------------
# THE WAVELENGTH ARRAY:
#
# Copied directly from pandeia/backgrounds/straylight/std_wavelengths.c
#
# NOTE!!! when this is changed it affects THREE (3) hard-coded places:
# 1) here
# 2) pandeia/backgrounds/straylight/std_wavelengths.c (the wave array)
# 3) pandeia/backgrounds/bmg/src/libBG/bmg_user.h (the value of SPECTRUM_ELEMENTS)
#
# (also edit all counterparts in pandeia/backgrounds/bmg_for_straylight)
#-----------------------------------------------------------------------------------

wavelist = [
    0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0, 2.1,
    2.2, 2.3, 2.4, 2.5, 2.6, 2.7, 2.8, 2.9, 3.0, 3.1, 3.2, 3.3, 3.4, 3.5, 3.7, 4.0, 4.25,
    4.5, 4.75, 5.0, 5.1, 5.2, 5.3, 5.4, 5.5, 5.7, 5.9, 6.1, 6.3, 6.5, 6.7, 6.9, 7.1, 7.3,
    7.5, 7.7, 7.9, 8.1, 8.3, 8.5, 8.7, 8.9, 9.1, 9.3, 9.5, 9.7, 9.9, 10.1, 10.3, 10.5,
    10.7, 10.9, 11.1, 11.3, 11.5, 11.7, 11.9, 12.1, 12.3, 12.5, 12.7, 12.9, 13.1, 13.3,
    13.5, 13.7, 13.9, 14.1, 14.3, 14.5, 14.7, 14.9, 15.1, 15.3, 15.5, 16.5, 17.5, 18.5,
    19.5, 20.5, 21.5, 22.5, 23.5, 24.5, 25.5, 26.5, 27.5, 28.5, 29.5, 30.5, 31.0
]

SL_NWAVE = len(wavelist)
IDX_OF_3P5 = wavelist.index(3.5)  # will throw an exception if fails (which we want)

nside = 128
Npix = 12 * nside * nside
