/*
	https://github.com/Jowin/Datatables-Bootstrap3
*/

(function (factory) {
    if (typeof define === 'function' && define.amd) {
        define(['jquery'], factory);
    }
    else {
        factory(jQuery);
    }
}(function ($) {

    /* Set the defaults for DataTables initialisation */
	$.extend( true, $.fn.dataTable.defaults, {
		"sDom": "<'row'<'col-sm-12'<'pull-right'f><'pull-left'l>r<'clearfix'>>>t<'row'<'col-sm-12'<'pull-left'i><'pull-right'p><'clearfix'>>>",
	    "sPaginationType": "bs_full",
	    "oLanguage": {
	        "sLengthMenu": "Show _MENU_ Rows",
	        "sSearch": ""
	    }
	} );

	/* Default class modification */
	$.extend( $.fn.dataTableExt.oStdClasses, {
		"sWrapper": "dataTables_wrapper form-inline"
	} );

	/* API method to get paging information */
	$.fn.dataTableExt.oApi.fnPagingInfo = function ( oSettings )
	{
		return {
			"iStart":         oSettings._iDisplayStart,
			"iEnd":           oSettings.fnDisplayEnd(),
			"iLength":        oSettings._iDisplayLength,
			"iTotal":         oSettings.fnRecordsTotal(),
			"iFilteredTotal": oSettings.fnRecordsDisplay(),
			"iPage":          oSettings._iDisplayLength === -1 ?
				0 : Math.ceil( oSettings._iDisplayStart / oSettings._iDisplayLength ),
			"iTotalPages":    oSettings._iDisplayLength === -1 ?
				0 : Math.ceil( oSettings.fnRecordsDisplay() / oSettings._iDisplayLength )
		};
	};

	/* Bootstrap style pagination control */
	$.extend( $.fn.dataTableExt.oPagination, {

		"bs_full": {
			"fnInit": function ( oSettings, nPaging, fnCallbackDraw )
				{
					var oLang = oSettings.oLanguage.oPaginate;
					var oClasses = oSettings.oClasses;
					var fnClickHandler = function ( e ) {
						if ( oSettings.oApi._fnPageChange( oSettings, e.data.action ) )
						{
							fnCallbackDraw( oSettings );
						}
					};
					$(nPaging).append(
						'<ul class="pagination">'+
						'<li class="disabled"><a  tabindex="'+oSettings.iTabIndex+'" class="'+oClasses.sPageButton+" "+oClasses.sPageFirst+'">'+oLang.sFirst+'</a></li>'+
						'<li class="disabled"><a  tabindex="'+oSettings.iTabIndex+'" class="'+oClasses.sPageButton+" "+oClasses.sPagePrevious+'">'+oLang.sPrevious+'</a></li>'+
						'<li><a tabindex="'+oSettings.iTabIndex+'" class="'+oClasses.sPageButton+" "+oClasses.sPageNext+'">'+oLang.sNext+'</a></li>'+
						'<li><a tabindex="'+oSettings.iTabIndex+'" class="'+oClasses.sPageButton+" "+oClasses.sPageLast+'">'+oLang.sLast+'</a></li>'+
						'</ul>'
					);
					var els = $('a', nPaging);
					var nFirst = els[0],
						nPrev = els[1],
						nNext = els[2],
						nLast = els[3];
					oSettings.oApi._fnBindAction( nFirst, {action: "first"},    fnClickHandler );
					oSettings.oApi._fnBindAction( nPrev,  {action: "previous"}, fnClickHandler );
					oSettings.oApi._fnBindAction( nNext,  {action: "next"},     fnClickHandler );
					oSettings.oApi._fnBindAction( nLast,  {action: "last"},     fnClickHandler );
					if ( !oSettings.aanFeatures.p )
					{
						nPaging.id = oSettings.sTableId+'_paginate';
						nFirst.id =oSettings.sTableId+'_first';
						nPrev.id =oSettings.sTableId+'_previous';
						nNext.id =oSettings.sTableId+'_next';
						nLast.id =oSettings.sTableId+'_last';
					}
				},
			"fnUpdate": function ( oSettings, fnCallbackDraw )
				{
					if ( !oSettings.aanFeatures.p )
					{
						return;
					}
					var oPaging = oSettings.oInstance.fnPagingInfo();
					var iPageCount = $.fn.dataTableExt.oPagination.iFullNumbersShowPages;
					var iPageCountHalf = Math.floor(iPageCount / 2);
					var iPages = Math.ceil((oSettings.fnRecordsDisplay()) / oSettings._iDisplayLength);
					var iCurrentPage = Math.ceil(oSettings._iDisplayStart / oSettings._iDisplayLength) + 1;
					var sList = "";
					var iStartButton, iEndButton, i, iLen;
					var oClasses = oSettings.oClasses;
					var anButtons, anStatic, nPaginateList, nNode;
					var an = oSettings.aanFeatures.p;
					var fnBind = function (j) {
						oSettings.oApi._fnBindAction( this, {"page": j+iStartButton-1}, function(e) {
							if( oSettings.oApi._fnPageChange( oSettings, e.data.page ) ){
								fnCallbackDraw( oSettings );
							}
							e.preventDefault();
						} );
					};
					if ( oSettings._iDisplayLength === -1 )
					{
						iStartButton = 1;
						iEndButton = 1;
						iCurrentPage = 1;
					}
					else if (iPages < iPageCount)
					{
						iStartButton = 1;
						iEndButton = iPages;
					}
					else if (iCurrentPage <= iPageCountHalf)
					{
						iStartButton = 1;
						iEndButton = iPageCount;
					}
					else if (iCurrentPage >= (iPages - iPageCountHalf))
					{
						iStartButton = iPages - iPageCount + 1;
						iEndButton = iPages;
					}
					else
					{
						iStartButton = iCurrentPage - Math.ceil(iPageCount / 2) + 1;
						iEndButton = iStartButton + iPageCount - 1;
					}
					for ( i=iStartButton ; i<=iEndButton ; i++ )
					{
						sList += (iCurrentPage !== i) ?
							'<li><a tabindex="'+oSettings.iTabIndex+'">'+oSettings.fnFormatNumber(i)+'</a></li>' :
							'<li class="active"><a tabindex="'+oSettings.iTabIndex+'">'+oSettings.fnFormatNumber(i)+'</a></li>';
					}
					for ( i=0, iLen=an.length ; i<iLen ; i++ )
					{
						nNode = an[i];
						if ( !nNode.hasChildNodes() )
						{
							continue;
						}
						$('li:gt(1)', an[i]).filter(':not(li:eq(-2))').filter(':not(li:eq(-1))').remove();
						if ( oPaging.iPage === 0 ) {
							$('li:eq(0)', an[i]).addClass('disabled');
							$('li:eq(1)', an[i]).addClass('disabled');
						} else {
							$('li:eq(0)', an[i]).removeClass('disabled');
							$('li:eq(1)', an[i]).removeClass('disabled');
						}
						if ( oPaging.iPage === oPaging.iTotalPages-1 || oPaging.iTotalPages === 0 ) {
							$('li:eq(-1)', an[i]).addClass('disabled');
							$('li:eq(-2)', an[i]).addClass('disabled');
						} else {
							$('li:eq(-1)', an[i]).removeClass('disabled');
							$('li:eq(-2)', an[i]).removeClass('disabled');
						}
						$(sList)
							.insertBefore($('li:eq(-2)', an[i]))
							.bind('click', function (e) {
								e.preventDefault();
								if ( oSettings.oApi._fnPageChange(oSettings, parseInt($('a', this).text(),10)-1) ) {
									fnCallbackDraw( oSettings );
								}
							});
					}
				}
		}
	} );


	/*
	 * TableTools Bootstrap compatibility
	 * Required TableTools 2.1+
	 */
	if ( $.fn.DataTable.TableTools ) {
		// Set the classes that TableTools uses to something suitable for Bootstrap
		$.extend( true, $.fn.DataTable.TableTools.classes, {
			"container": "DTTT btn-group",
			"buttons": {
				"normal": "btn",
				"disabled": "disabled"
			},
			"collection": {
				"container": "DTTT_dropdown dropdown-menu",
				"buttons": {
					"normal": "",
					"disabled": "disabled"
				}
			},
			"print": {
				"info": "DTTT_print_info modal"
			},
			"select": {
				"row": "active"
			}
		} );

		// Have the collection use a bootstrap compatible dropdown
		$.extend( true, $.fn.DataTable.TableTools.DEFAULTS.oTags, {
			"collection": {
				"container": "ul",
				"button": "li",
				"liner": "a"
			}
		} );
	}
}));




