import * as ec2 from 'aws-cdk-lib/aws-ec2';
import { IResource, Resource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * (experimental) Represents an API Gateway VpcLink.
 *
 * @experimental
 */
export interface IVpcLink extends IResource {
    /**
     * (experimental) Physical ID of the VpcLink resource.
     *
     * @experimental
     * @attribute true
     */
    readonly vpcLinkId: string;
    /**
     * (experimental) The VPC to which this VPC Link is associated with.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
}
/**
 * (experimental) Properties for a VpcLink.
 *
 * @experimental
 */
export interface VpcLinkProps {
    /**
     * (experimental) The VPC in which the private resources reside.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) The name used to label and identify the VPC link.
     *
     * @default - automatically generated name
     * @experimental
     */
    readonly vpcLinkName?: string;
    /**
     * (experimental) A list of subnets for the VPC link.
     *
     * @default - private subnets of the provided VPC. Use `addSubnets` to add more subnets
     * @experimental
     */
    readonly subnets?: ec2.SubnetSelection;
    /**
     * (experimental) A list of security groups for the VPC link.
     *
     * @default - no security groups. Use `addSecurityGroups` to add security groups
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
}
/**
 * (experimental) Attributes when importing a new VpcLink.
 *
 * @experimental
 */
export interface VpcLinkAttributes {
    /**
     * (experimental) The VPC Link id.
     *
     * @experimental
     */
    readonly vpcLinkId: string;
    /**
     * (experimental) The VPC to which this VPC link is associated with.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
}
/**
 * (experimental) Define a new VPC Link Specifies an API Gateway VPC link for a HTTP API to access resources in an Amazon Virtual Private Cloud (VPC).
 *
 * @experimental
 */
export declare class VpcLink extends Resource implements IVpcLink {
    /**
     * (experimental) Import a VPC Link by specifying its attributes.
     *
     * @experimental
     */
    static fromVpcLinkAttributes(scope: Construct, id: string, attrs: VpcLinkAttributes): IVpcLink;
    /**
     * (experimental) Physical ID of the VpcLink resource.
     *
     * @experimental
     */
    readonly vpcLinkId: string;
    /**
     * (experimental) The VPC to which this VPC Link is associated with.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    private readonly subnets;
    private readonly securityGroups;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: VpcLinkProps);
    /**
     * (experimental) Adds the provided subnets to the vpc link.
     *
     * @experimental
     */
    addSubnets(...subnets: ec2.ISubnet[]): void;
    /**
     * (experimental) Adds the provided security groups to the vpc link.
     *
     * @experimental
     */
    addSecurityGroups(...groups: ec2.ISecurityGroup[]): void;
    private renderSubnets;
    private renderSecurityGroups;
}
