# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEnvironmentResult',
    'AwaitableGetEnvironmentResult',
    'get_environment',
    'get_environment_output',
]

@pulumi.output_type
class GetEnvironmentResult:
    """
    A collection of values returned by getEnvironment.
    """
    def __init__(__self__, api_key=None, approval_settings=None, client_side_id=None, color=None, confirm_changes=None, default_track_events=None, default_ttl=None, id=None, key=None, mobile_key=None, name=None, project_key=None, require_comments=None, secure_mode=None, tags=None):
        if api_key and not isinstance(api_key, str):
            raise TypeError("Expected argument 'api_key' to be a str")
        pulumi.set(__self__, "api_key", api_key)
        if approval_settings and not isinstance(approval_settings, list):
            raise TypeError("Expected argument 'approval_settings' to be a list")
        pulumi.set(__self__, "approval_settings", approval_settings)
        if client_side_id and not isinstance(client_side_id, str):
            raise TypeError("Expected argument 'client_side_id' to be a str")
        pulumi.set(__self__, "client_side_id", client_side_id)
        if color and not isinstance(color, str):
            raise TypeError("Expected argument 'color' to be a str")
        pulumi.set(__self__, "color", color)
        if confirm_changes and not isinstance(confirm_changes, bool):
            raise TypeError("Expected argument 'confirm_changes' to be a bool")
        pulumi.set(__self__, "confirm_changes", confirm_changes)
        if default_track_events and not isinstance(default_track_events, bool):
            raise TypeError("Expected argument 'default_track_events' to be a bool")
        pulumi.set(__self__, "default_track_events", default_track_events)
        if default_ttl and not isinstance(default_ttl, int):
            raise TypeError("Expected argument 'default_ttl' to be a int")
        pulumi.set(__self__, "default_ttl", default_ttl)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if mobile_key and not isinstance(mobile_key, str):
            raise TypeError("Expected argument 'mobile_key' to be a str")
        pulumi.set(__self__, "mobile_key", mobile_key)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_key and not isinstance(project_key, str):
            raise TypeError("Expected argument 'project_key' to be a str")
        pulumi.set(__self__, "project_key", project_key)
        if require_comments and not isinstance(require_comments, bool):
            raise TypeError("Expected argument 'require_comments' to be a bool")
        pulumi.set(__self__, "require_comments", require_comments)
        if secure_mode and not isinstance(secure_mode, bool):
            raise TypeError("Expected argument 'secure_mode' to be a bool")
        pulumi.set(__self__, "secure_mode", secure_mode)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        The environment's SDK key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="approvalSettings")
    def approval_settings(self) -> Sequence['outputs.GetEnvironmentApprovalSettingResult']:
        return pulumi.get(self, "approval_settings")

    @property
    @pulumi.getter(name="clientSideId")
    def client_side_id(self) -> str:
        """
        The environment's client-side ID.
        """
        return pulumi.get(self, "client_side_id")

    @property
    @pulumi.getter
    def color(self) -> str:
        """
        The color swatch as an RGB hex value with no leading `#`. For example: `000000`.
        """
        return pulumi.get(self, "color")

    @property
    @pulumi.getter(name="confirmChanges")
    def confirm_changes(self) -> Optional[bool]:
        """
        A value of `true` indicates that this environment requires confirmation for flag and segment changes.
        """
        return pulumi.get(self, "confirm_changes")

    @property
    @pulumi.getter(name="defaultTrackEvents")
    def default_track_events(self) -> Optional[bool]:
        """
        A value of `true` enables data export for every flag created in this environment. To learn more, read [Data Export](https://docs.launchdarkly.com/docs/data-export).
        """
        return pulumi.get(self, "default_track_events")

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[int]:
        """
        The TTL for the environment. This will be a numeric value between 0 and 60 in minutes. The TTL setting only applies to environments using the PHP SDK. To learn more, read [TTL settings](https://docs.launchdarkly.com/docs/environments#section-ttl-settings).
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="mobileKey")
    def mobile_key(self) -> str:
        """
        The environment's mobile key.
        """
        return pulumi.get(self, "mobile_key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the environment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> str:
        return pulumi.get(self, "project_key")

    @property
    @pulumi.getter(name="requireComments")
    def require_comments(self) -> Optional[bool]:
        """
        A value of `true` indicates that this environment requires comments for flag and segment changes.
        """
        return pulumi.get(self, "require_comments")

    @property
    @pulumi.getter(name="secureMode")
    def secure_mode(self) -> Optional[bool]:
        """
        A value of true `true` ensures a user of the client-side SDK cannot impersonate another user.
        """
        return pulumi.get(self, "secure_mode")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        Set of tags associated with the environment.
        """
        return pulumi.get(self, "tags")


class AwaitableGetEnvironmentResult(GetEnvironmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnvironmentResult(
            api_key=self.api_key,
            approval_settings=self.approval_settings,
            client_side_id=self.client_side_id,
            color=self.color,
            confirm_changes=self.confirm_changes,
            default_track_events=self.default_track_events,
            default_ttl=self.default_ttl,
            id=self.id,
            key=self.key,
            mobile_key=self.mobile_key,
            name=self.name,
            project_key=self.project_key,
            require_comments=self.require_comments,
            secure_mode=self.secure_mode,
            tags=self.tags)


def get_environment(approval_settings: Optional[Sequence[pulumi.InputType['GetEnvironmentApprovalSettingArgs']]] = None,
                    confirm_changes: Optional[bool] = None,
                    default_track_events: Optional[bool] = None,
                    default_ttl: Optional[int] = None,
                    key: Optional[str] = None,
                    project_key: Optional[str] = None,
                    require_comments: Optional[bool] = None,
                    secure_mode: Optional[bool] = None,
                    tags: Optional[Sequence[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnvironmentResult:
    """
    Provides a LaunchDarkly environment data source.

    This data source allows you to retrieve environment information from your LaunchDarkly organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_launchdarkly as launchdarkly

    example = launchdarkly.get_environment(key="example-env",
        project_key="example-project")
    ```


    :param bool confirm_changes: A value of `true` indicates that this environment requires confirmation for flag and segment changes.
    :param bool default_track_events: A value of `true` enables data export for every flag created in this environment. To learn more, read [Data Export](https://docs.launchdarkly.com/docs/data-export).
    :param int default_ttl: The TTL for the environment. This will be a numeric value between 0 and 60 in minutes. The TTL setting only applies to environments using the PHP SDK. To learn more, read [TTL settings](https://docs.launchdarkly.com/docs/environments#section-ttl-settings).
    :param str key: The environment's unique key.
    :param str project_key: The environment's project key.
    :param bool require_comments: A value of `true` indicates that this environment requires comments for flag and segment changes.
    :param bool secure_mode: A value of true `true` ensures a user of the client-side SDK cannot impersonate another user.
    :param Sequence[str] tags: Set of tags associated with the environment.
    """
    __args__ = dict()
    __args__['approvalSettings'] = approval_settings
    __args__['confirmChanges'] = confirm_changes
    __args__['defaultTrackEvents'] = default_track_events
    __args__['defaultTtl'] = default_ttl
    __args__['key'] = key
    __args__['projectKey'] = project_key
    __args__['requireComments'] = require_comments
    __args__['secureMode'] = secure_mode
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('launchdarkly:index/getEnvironment:getEnvironment', __args__, opts=opts, typ=GetEnvironmentResult).value

    return AwaitableGetEnvironmentResult(
        api_key=__ret__.api_key,
        approval_settings=__ret__.approval_settings,
        client_side_id=__ret__.client_side_id,
        color=__ret__.color,
        confirm_changes=__ret__.confirm_changes,
        default_track_events=__ret__.default_track_events,
        default_ttl=__ret__.default_ttl,
        id=__ret__.id,
        key=__ret__.key,
        mobile_key=__ret__.mobile_key,
        name=__ret__.name,
        project_key=__ret__.project_key,
        require_comments=__ret__.require_comments,
        secure_mode=__ret__.secure_mode,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_environment)
def get_environment_output(approval_settings: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetEnvironmentApprovalSettingArgs']]]]] = None,
                           confirm_changes: Optional[pulumi.Input[Optional[bool]]] = None,
                           default_track_events: Optional[pulumi.Input[Optional[bool]]] = None,
                           default_ttl: Optional[pulumi.Input[Optional[int]]] = None,
                           key: Optional[pulumi.Input[str]] = None,
                           project_key: Optional[pulumi.Input[str]] = None,
                           require_comments: Optional[pulumi.Input[Optional[bool]]] = None,
                           secure_mode: Optional[pulumi.Input[Optional[bool]]] = None,
                           tags: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEnvironmentResult]:
    """
    Provides a LaunchDarkly environment data source.

    This data source allows you to retrieve environment information from your LaunchDarkly organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_launchdarkly as launchdarkly

    example = launchdarkly.get_environment(key="example-env",
        project_key="example-project")
    ```


    :param bool confirm_changes: A value of `true` indicates that this environment requires confirmation for flag and segment changes.
    :param bool default_track_events: A value of `true` enables data export for every flag created in this environment. To learn more, read [Data Export](https://docs.launchdarkly.com/docs/data-export).
    :param int default_ttl: The TTL for the environment. This will be a numeric value between 0 and 60 in minutes. The TTL setting only applies to environments using the PHP SDK. To learn more, read [TTL settings](https://docs.launchdarkly.com/docs/environments#section-ttl-settings).
    :param str key: The environment's unique key.
    :param str project_key: The environment's project key.
    :param bool require_comments: A value of `true` indicates that this environment requires comments for flag and segment changes.
    :param bool secure_mode: A value of true `true` ensures a user of the client-side SDK cannot impersonate another user.
    :param Sequence[str] tags: Set of tags associated with the environment.
    """
    ...
