
# This is a generated file

"""thirdpartyownership - Residential/Commercial 3rd Party Ownership Finance model."""

# VERSION: 1

from mypy_extensions import TypedDict
from typing import Any, Dict, Mapping
from typing_extensions import Final

from .. import ssc
from ._util import *

DataDict = TypedDict('DataDict', {
    'depr_fed_type': float,
        'depr_fed_sl_years': float,
        'depr_fed_custom': Array,
        'depr_sta_type': float,
        'depr_sta_sl_years': float,
        'depr_sta_custom': Array,
        'analysis_period': float,
        'real_discount_rate': float,
        'inflation_rate': float,
        'lease_or_ppa': float,
        'annual_energy_value': Array,
        'gen': Array,
        'degradation': Array,
        'system_use_lifetime_output': float,
        'lease_price': float,
        'lease_escalation': float,
        'ppa_price': float,
        'ppa_escalation': float,
        'cf_length': float,
        'npv': float,
        'cf_energy_net': Array,
        'cf_agreement_cost': Array,
        'cf_after_tax_net_equity_cost_flow': Array,
        'cf_after_tax_cash_flow': Array,
        'cf_payback_with_expenses': Array,
        'cf_cumulative_payback_with_expenses': Array,
        'elec_cost_with_system': Array,
        'elec_cost_without_system': Array,
        'cf_nte': Array,
        'year1_nte': float,
        'lnte_real': float,
        'lnte_nom': float
}, total=False)

class Data(ssc.DataDict):
    depr_fed_type: float = INPUT(label='Federal depreciation type', type='NUMBER', group='Depreciation', required='?=0', constraints='INTEGER,MIN=0,MAX=3', meta='0=none,1=macrs_half_year,2=sl,3=custom')
    depr_fed_sl_years: float = INPUT(label='Federal depreciation straight-line Years', units='years', type='NUMBER', group='Depreciation', required='depr_fed_type=2', constraints='INTEGER,POSITIVE')
    depr_fed_custom: Array = INPUT(label='Federal custom depreciation', units='%/year', type='ARRAY', group='Depreciation', required='depr_fed_type=3')
    depr_sta_type: float = INPUT(label='State depreciation type', type='NUMBER', group='Depreciation', required='?=0', constraints='INTEGER,MIN=0,MAX=3', meta='0=none,1=macrs_half_year,2=sl,3=custom')
    depr_sta_sl_years: float = INPUT(label='State depreciation straight-line years', units='years', type='NUMBER', group='Depreciation', required='depr_sta_type=2', constraints='INTEGER,POSITIVE')
    depr_sta_custom: Array = INPUT(label='State custom depreciation', units='%/year', type='ARRAY', group='Depreciation', required='depr_sta_type=3')
    analysis_period: float = INPUT(label='Analyis period', units='years', type='NUMBER', group='Financials', required='?=30', constraints='INTEGER,MIN=0,MAX=50')
    real_discount_rate: float = INPUT(label='Real discount rate', units='%', type='NUMBER', group='Financials', required='*', constraints='MIN=-99')
    inflation_rate: float = INPUT(label='Inflation rate', units='%', type='NUMBER', group='Financials', required='*', constraints='MIN=-99')
    lease_or_ppa: float = INPUT(label='Lease or PPA agreement', units='0/1', type='NUMBER', group='thirdpartyownership', required='?=0', constraints='INTEGER,MIN=0,MAX=1', meta='0=lease,1=ppa')
    annual_energy_value: Array = INPUT(label='Energy value', units='$', type='ARRAY', group='thirdpartyownership', required='*')
    gen: Array = INPUT(label='Power generated by renewable resource', units='kW', type='ARRAY', required='*')
    degradation: Array = INPUT(label='Annual degradation', units='%', type='ARRAY', group='AnnualOutput', required='*')
    system_use_lifetime_output: float = INPUT(label='Lifetime hourly system outputs', units='0/1', type='NUMBER', group='AnnualOutput', required='*', constraints='INTEGER,MIN=0', meta='0=hourly first year,1=hourly lifetime')
    lease_price: float = INPUT(label='Monthly lease price', units='$/month', type='NUMBER', group='Cash Flow', required='lease_or_ppa=0')
    lease_escalation: float = INPUT(label='Monthly lease escalation', units='%/year', type='NUMBER', group='Cash Flow', required='lease_or_ppa=0')
    ppa_price: float = INPUT(label='Monthly lease price', units='$/month', type='NUMBER', group='Cash Flow', required='lease_or_ppa=1')
    ppa_escalation: float = INPUT(label='Monthly lease escalation', units='%/year', type='NUMBER', group='Cash Flow', required='lease_or_ppa=1')
    cf_length: Final[float] = OUTPUT(label='Agreement period', type='NUMBER', group='Financial Metrics', required='*', constraints='INTEGER')
    npv: Final[float] = OUTPUT(label='Net present value', units='$', type='NUMBER', group='Financial Metrics', required='*')
    cf_energy_net: Final[Array] = OUTPUT(label='Energy', units='kWh', type='ARRAY', group='Cash Flow', required='*', constraints='LENGTH_EQUAL=cf_length')
    cf_agreement_cost: Final[Array] = OUTPUT(label='Agreement cost', units='$', type='ARRAY', group='Cash Flow', required='*', constraints='LENGTH_EQUAL=cf_length')
    cf_after_tax_net_equity_cost_flow: Final[Array] = OUTPUT(label='After-tax annual costs', units='$', type='ARRAY', group='Cash Flow', required='*', constraints='LENGTH_EQUAL=cf_length')
    cf_after_tax_cash_flow: Final[Array] = OUTPUT(label='After-tax cash flow', units='$', type='ARRAY', group='Cash Flow', required='*', constraints='LENGTH_EQUAL=cf_length')
    cf_payback_with_expenses: Final[Array] = OUTPUT(label='Simple payback with expenses', units='$', type='ARRAY', group='Cash Flow', required='*', constraints='LENGTH_EQUAL=cf_length')
    cf_cumulative_payback_with_expenses: Final[Array] = OUTPUT(label='Cumulative simple payback with expenses', units='$', type='ARRAY', group='Cash Flow', required='*', constraints='LENGTH_EQUAL=cf_length')
    elec_cost_with_system: Array = INPUT(label='Energy value', units='$', type='ARRAY', group='Electricity Cost', required='*')
    elec_cost_without_system: Array = INPUT(label='Energy value', units='$', type='ARRAY', group='Electricity Cost', required='*')
    cf_nte: Final[Array] = OUTPUT(label='Host indifference point by year', units='cents/kWh', type='ARRAY', group='Cash Flow', required='*', constraints='LENGTH_EQUAL=cf_length')
    year1_nte: Final[float] = OUTPUT(label='Host indifference point in Year 1', units='cents/kWh', type='NUMBER', group='Financial Metrics', required='*')
    lnte_real: Final[float] = OUTPUT(label='Host indifference point nominal levelized value', units='cents/kWh', type='NUMBER', group='Financial Metrics', required='*')
    lnte_nom: Final[float] = OUTPUT(label='Host indifference point real levelized value', units='cents/kWh', type='NUMBER', group='Financial Metrics', required='*')

    def __init__(self, *args: Mapping[str, Any],
                 depr_fed_type: float = ...,
                 depr_fed_sl_years: float = ...,
                 depr_fed_custom: Array = ...,
                 depr_sta_type: float = ...,
                 depr_sta_sl_years: float = ...,
                 depr_sta_custom: Array = ...,
                 analysis_period: float = ...,
                 real_discount_rate: float = ...,
                 inflation_rate: float = ...,
                 lease_or_ppa: float = ...,
                 annual_energy_value: Array = ...,
                 gen: Array = ...,
                 degradation: Array = ...,
                 system_use_lifetime_output: float = ...,
                 lease_price: float = ...,
                 lease_escalation: float = ...,
                 ppa_price: float = ...,
                 ppa_escalation: float = ...,
                 elec_cost_with_system: Array = ...,
                 elec_cost_without_system: Array = ...) -> None: ...
    def to_dict(self) -> DataDict: ...  # type: ignore[override]

class Module(ssc.Module[Data]):
    def __init__(self) -> None: ...
