# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, active=None, birth_date=None, data=None, email=None, expiry=None, first_name=None, full_name=None, id=None, image_url=None, last_name=None, middle_name=None, mobile_phone=None, parent_email=None, password_change_required=None, preferred_languages=None, tenant_id=None, timezone=None, user_id=None, username=None, username_status=None):
        if active and not isinstance(active, bool):
            raise TypeError("Expected argument 'active' to be a bool")
        pulumi.set(__self__, "active", active)
        if birth_date and not isinstance(birth_date, str):
            raise TypeError("Expected argument 'birth_date' to be a str")
        pulumi.set(__self__, "birth_date", birth_date)
        if data and not isinstance(data, str):
            raise TypeError("Expected argument 'data' to be a str")
        pulumi.set(__self__, "data", data)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if expiry and not isinstance(expiry, int):
            raise TypeError("Expected argument 'expiry' to be a int")
        pulumi.set(__self__, "expiry", expiry)
        if first_name and not isinstance(first_name, str):
            raise TypeError("Expected argument 'first_name' to be a str")
        pulumi.set(__self__, "first_name", first_name)
        if full_name and not isinstance(full_name, str):
            raise TypeError("Expected argument 'full_name' to be a str")
        pulumi.set(__self__, "full_name", full_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_url and not isinstance(image_url, str):
            raise TypeError("Expected argument 'image_url' to be a str")
        pulumi.set(__self__, "image_url", image_url)
        if last_name and not isinstance(last_name, str):
            raise TypeError("Expected argument 'last_name' to be a str")
        pulumi.set(__self__, "last_name", last_name)
        if middle_name and not isinstance(middle_name, str):
            raise TypeError("Expected argument 'middle_name' to be a str")
        pulumi.set(__self__, "middle_name", middle_name)
        if mobile_phone and not isinstance(mobile_phone, str):
            raise TypeError("Expected argument 'mobile_phone' to be a str")
        pulumi.set(__self__, "mobile_phone", mobile_phone)
        if parent_email and not isinstance(parent_email, str):
            raise TypeError("Expected argument 'parent_email' to be a str")
        pulumi.set(__self__, "parent_email", parent_email)
        if password_change_required and not isinstance(password_change_required, bool):
            raise TypeError("Expected argument 'password_change_required' to be a bool")
        pulumi.set(__self__, "password_change_required", password_change_required)
        if preferred_languages and not isinstance(preferred_languages, list):
            raise TypeError("Expected argument 'preferred_languages' to be a list")
        pulumi.set(__self__, "preferred_languages", preferred_languages)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if timezone and not isinstance(timezone, str):
            raise TypeError("Expected argument 'timezone' to be a str")
        pulumi.set(__self__, "timezone", timezone)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)
        if username_status and not isinstance(username_status, str):
            raise TypeError("Expected argument 'username_status' to be a str")
        pulumi.set(__self__, "username_status", username_status)

    @property
    @pulumi.getter
    def active(self) -> bool:
        """
        True if the user is active. False if the user has been deactivated. Deactivated users will not be able to login.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="birthDate")
    def birth_date(self) -> str:
        """
        An ISO-8601 formatted date of the user’s birthdate such as YYYY-MM-DD.
        """
        return pulumi.get(self, "birth_date")

    @property
    @pulumi.getter
    def data(self) -> str:
        """
        A JSON serialised string that can hold any information about the user.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The user’s email address.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def expiry(self) -> int:
        """
        The expiration instant of the user’s account. An expired user is not permitted to login.
        """
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> str:
        """
        The first name of the user.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> str:
        """
        The user’s full name.
        """
        return pulumi.get(self, "full_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> str:
        """
        The URL that points to an image file that is the user’s profile image.
        """
        return pulumi.get(self, "image_url")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> str:
        """
        The user’s last name.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> str:
        """
        The user’s middle name.
        """
        return pulumi.get(self, "middle_name")

    @property
    @pulumi.getter(name="mobilePhone")
    def mobile_phone(self) -> str:
        """
        The user’s mobile phone number.
        """
        return pulumi.get(self, "mobile_phone")

    @property
    @pulumi.getter(name="parentEmail")
    def parent_email(self) -> str:
        """
        The email address of the user’s parent or guardian.
        """
        return pulumi.get(self, "parent_email")

    @property
    @pulumi.getter(name="passwordChangeRequired")
    def password_change_required(self) -> bool:
        """
        Indicates that the user’s password needs to be changed during their next login attempt.
        """
        return pulumi.get(self, "password_change_required")

    @property
    @pulumi.getter(name="preferredLanguages")
    def preferred_languages(self) -> Sequence[str]:
        """
        An array of locale strings that give, in order, the user’s preferred languages.
        """
        return pulumi.get(self, "preferred_languages")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def timezone(self) -> str:
        """
        The user’s preferred timezone.
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameStatus")
    def username_status(self) -> str:
        """
        The current status of the username. This is used if you are moderating usernames via CleanSpeak.
        """
        return pulumi.get(self, "username_status")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            active=self.active,
            birth_date=self.birth_date,
            data=self.data,
            email=self.email,
            expiry=self.expiry,
            first_name=self.first_name,
            full_name=self.full_name,
            id=self.id,
            image_url=self.image_url,
            last_name=self.last_name,
            middle_name=self.middle_name,
            mobile_phone=self.mobile_phone,
            parent_email=self.parent_email,
            password_change_required=self.password_change_required,
            preferred_languages=self.preferred_languages,
            tenant_id=self.tenant_id,
            timezone=self.timezone,
            user_id=self.user_id,
            username=self.username,
            username_status=self.username_status)


def get_user(tenant_id: Optional[str] = None,
             user_id: Optional[str] = None,
             username: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    ## # User Data Source

    This data source can be used to fetch information about a specific user.

    [Users API](https://fusionauth.io/docs/v1/tech/apis/users)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_fusionauth as fusionauth

    example = fusionauth.get_user(username="foo@example.com")
    ```


    :param str tenant_id: The Id of the tenant used to scope this API request.
    :param str user_id: The Id of the user. Either `user_id` or `username` must be specified.
    :param str username: The username of the user. Either `user_id` or `username` must be specified.
    """
    __args__ = dict()
    __args__['tenantId'] = tenant_id
    __args__['userId'] = user_id
    __args__['username'] = username
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
    __ret__ = pulumi.runtime.invoke('fusionauth:index/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        active=__ret__.active,
        birth_date=__ret__.birth_date,
        data=__ret__.data,
        email=__ret__.email,
        expiry=__ret__.expiry,
        first_name=__ret__.first_name,
        full_name=__ret__.full_name,
        id=__ret__.id,
        image_url=__ret__.image_url,
        last_name=__ret__.last_name,
        middle_name=__ret__.middle_name,
        mobile_phone=__ret__.mobile_phone,
        parent_email=__ret__.parent_email,
        password_change_required=__ret__.password_change_required,
        preferred_languages=__ret__.preferred_languages,
        tenant_id=__ret__.tenant_id,
        timezone=__ret__.timezone,
        user_id=__ret__.user_id,
        username=__ret__.username,
        username_status=__ret__.username_status)


@_utilities.lift_output_func(get_user)
def get_user_output(tenant_id: Optional[pulumi.Input[Optional[str]]] = None,
                    user_id: Optional[pulumi.Input[Optional[str]]] = None,
                    username: Optional[pulumi.Input[Optional[str]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserResult]:
    """
    ## # User Data Source

    This data source can be used to fetch information about a specific user.

    [Users API](https://fusionauth.io/docs/v1/tech/apis/users)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_fusionauth as fusionauth

    example = fusionauth.get_user(username="foo@example.com")
    ```


    :param str tenant_id: The Id of the tenant used to scope this API request.
    :param str user_id: The Id of the user. Either `user_id` or `username` must be specified.
    :param str username: The username of the user. Either `user_id` or `username` must be specified.
    """
    ...
