# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['FusionAuthThemeArgs', 'FusionAuthTheme']

@pulumi.input_type
class FusionAuthThemeArgs:
    def __init__(__self__, *,
                 account_edit: Optional[pulumi.Input[str]] = None,
                 account_index: Optional[pulumi.Input[str]] = None,
                 account_two_factor_disable: Optional[pulumi.Input[str]] = None,
                 account_two_factor_enable: Optional[pulumi.Input[str]] = None,
                 account_two_factor_index: Optional[pulumi.Input[str]] = None,
                 default_messages: Optional[pulumi.Input[str]] = None,
                 email_complete: Optional[pulumi.Input[str]] = None,
                 email_send: Optional[pulumi.Input[str]] = None,
                 email_sent: Optional[pulumi.Input[str]] = None,
                 email_verification_required: Optional[pulumi.Input[str]] = None,
                 email_verify: Optional[pulumi.Input[str]] = None,
                 helpers: Optional[pulumi.Input[str]] = None,
                 index: Optional[pulumi.Input[str]] = None,
                 localized_messages: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth2_authorize: Optional[pulumi.Input[str]] = None,
                 oauth2_authorized_not_registered: Optional[pulumi.Input[str]] = None,
                 oauth2_child_registration_not_allowed: Optional[pulumi.Input[str]] = None,
                 oauth2_child_registration_not_allowed_complete: Optional[pulumi.Input[str]] = None,
                 oauth2_complete_registration: Optional[pulumi.Input[str]] = None,
                 oauth2_device: Optional[pulumi.Input[str]] = None,
                 oauth2_device_complete: Optional[pulumi.Input[str]] = None,
                 oauth2_error: Optional[pulumi.Input[str]] = None,
                 oauth2_logout: Optional[pulumi.Input[str]] = None,
                 oauth2_passwordless: Optional[pulumi.Input[str]] = None,
                 oauth2_register: Optional[pulumi.Input[str]] = None,
                 oauth2_start_idp_link: Optional[pulumi.Input[str]] = None,
                 oauth2_two_factor: Optional[pulumi.Input[str]] = None,
                 oauth2_two_factor_methods: Optional[pulumi.Input[str]] = None,
                 oauth2_wait: Optional[pulumi.Input[str]] = None,
                 password_change: Optional[pulumi.Input[str]] = None,
                 password_complete: Optional[pulumi.Input[str]] = None,
                 password_forgot: Optional[pulumi.Input[str]] = None,
                 password_sent: Optional[pulumi.Input[str]] = None,
                 registration_complete: Optional[pulumi.Input[str]] = None,
                 registration_send: Optional[pulumi.Input[str]] = None,
                 registration_sent: Optional[pulumi.Input[str]] = None,
                 registration_verification_required: Optional[pulumi.Input[str]] = None,
                 registration_verify: Optional[pulumi.Input[str]] = None,
                 samlv2_logout: Optional[pulumi.Input[str]] = None,
                 source_theme_id: Optional[pulumi.Input[str]] = None,
                 stylesheet: Optional[pulumi.Input[str]] = None,
                 unauthorized: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FusionAuthTheme resource.
        :param pulumi.Input[str] account_edit: A FreeMarker template that is rendered when the user requests the /account/edit path. This page contains a form that enables authenticated users to update their profile.
        :param pulumi.Input[str] account_index: A FreeMarker template that is rendered when the user requests the /account path. This is the self-service account landing page. An authenticated user may use this as a starting point for operations such as updating their profile or configuring multi-factor authentication.
        :param pulumi.Input[str] account_two_factor_disable: A FreeMarker template that is rendered when the user requests the /account/two-factor/disable path. This page contains a form that accepts a verification code used to disable a multi-factor authentication method.
        :param pulumi.Input[str] account_two_factor_enable: A FreeMarker template that is rendered when the user requests the /account/two-factor/enable path. This page contains a form that accepts a verification code used to enable a multi-factor authentication method. Additionally, this page contains presentation of recovery codes when a user enables multi-factor authentication for the first time.
        :param pulumi.Input[str] account_two_factor_index: A FreeMarker template that is rendered when the user requests the /account/two-factor path. This page displays an authenticated user’s configured multi-factor authentication methods. Additionally, it provides links to enable and disable a method.
        :param pulumi.Input[str] default_messages: A properties file formatted String containing at least all of the message keys defined in the FusionAuth shipped messages file. Required if not copying an existing Theme.
        :param pulumi.Input[str] email_complete: A FreeMarker template that is rendered when the user requests the /email/complete path. This page is used after a user has verified their email address by clicking the URL in the email. After FusionAuth has updated their user object to indicate that their email was verified, the browser is redirected to this page.
        :param pulumi.Input[str] email_send: A FreeMarker template that is rendered when the user requests the /email/send page. This page is used after a user has asked for the verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        :param pulumi.Input[str] email_sent: A FreeMarker template that is rendered when the user requests the /email/sent path. This page is used after a user has asked for the verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        :param pulumi.Input[str] email_verification_required: A FreeMarker template that is rendered when the user requests the /email/verification-required path. This page is rendered when a user is required to verify their email address prior to being allowed to proceed with login. This occurs when Unverified behavior is set to Gated in email verification settings on the Tenant.
        :param pulumi.Input[str] email_verify: A FreeMarker template that is rendered when the user requests the /email/verify path. This page is rendered when a user clicks the URL from the verification email and the verificationId has expired. FusionAuth expires verificationId after a period of time (which is configurable). If the user has a URL from the verification email that has expired, this page will be rendered and the error will be displayed to the user.
        :param pulumi.Input[str] helpers: A FreeMarker template that contains all of the macros and templates used by the rest of the login Theme FreeMarker templates. This allows you to configure the general layout of your UI configuration and login theme without having to copy and paste HTML into each of the templates.
        :param pulumi.Input[str] index: A FreeMarker template that is rendered when the user requests the / path. This is the root landing page. This page is available to unauthenticated users and will be displayed whenever someone navigates to the FusionAuth host’s root page. Prior to version 1.27.0, navigating to this URL would redirect to /admin and would subsequently render the FusionAuth admin login page.
        :param pulumi.Input[Mapping[str, Any]] localized_messages: A Map of localized versions of the messages. The key is the Locale and the value is a properties file formatted String.
        :param pulumi.Input[str] name: A unique name for the Theme.
        :param pulumi.Input[str] oauth2_authorize: A FreeMarker template that is rendered when the user requests the /oauth2/authorize path. This is the main login page for FusionAuth and is used for all interactive OAuth2 and OpenID Connect workflows.
        :param pulumi.Input[str] oauth2_authorized_not_registered: A FreeMarker template that is rendered when the user requests the /oauth2/authorized-not-registered path. This page is rendered when a user is not registered and the Application configuration requires registration before FusionAuth will complete the redirect.
        :param pulumi.Input[str] oauth2_child_registration_not_allowed: A FreeMarker template that is rendered when the user requests the /oauth2/child-registration-not-allowed path. This page contains a form where a child must provide their parent’s email address to ask their parent to create an account for them in a Consent workflow.
        :param pulumi.Input[str] oauth2_child_registration_not_allowed_complete: A FreeMarker template that is rendered when the user requests the /oauth2/child-registration-not-allowed-complete path. This page is rendered is rendered after a child provides their parent’s email address for parental consent in a Consent workflow.
        :param pulumi.Input[str] oauth2_complete_registration: A FreeMarker template that is rendered when the user requests the /oauth2/complete-registration path. This page contains a form that is used for users that have accounts but might be missing required fields.
        :param pulumi.Input[str] oauth2_device: A FreeMarker template that is rendered when the user requests the /oauth2/device path. This page contains a form for accepting an end user’s short code for the interactive portion of the OAuth Device Authorization Grant workflow.
        :param pulumi.Input[str] oauth2_device_complete: A FreeMarker template that is rendered when the user requests the /oauth2/device-complete path. This page contains a complete message indicating the device authentication has completed.
        :param pulumi.Input[str] oauth2_error: This page is used if the user starts or is in the middle of the OAuth workflow and any type of error occurs. This could be caused by the user messing with the URL or internally some type of information wasn’t passed between the OAuth endpoints correctly. For example, if you are federating login to an external IdP and that IdP does not properly echo the state parameter, FusionAuth’s OAuth workflow will break and this page will be displayed.
        :param pulumi.Input[str] oauth2_logout: A FreeMarker template that is rendered when the user requests the /oauth2/logout page. This page is used if the user initiates a logout. This page causes the user to be logged out of all associated applications via a front-channel mechanism before being redirected.
        :param pulumi.Input[str] oauth2_passwordless: A FreeMarker template that is rendered when the user requests the /oauth2/passwordless path. This page is rendered when the user starts the passwordless login workflow. The page renders the form where the user types in their email address.
        :param pulumi.Input[str] oauth2_register: A FreeMarker template that is rendered when the user requests the /oauth2/register path. This page is used to register or sign up the user for the application when self-service registration is enabled.
        :param pulumi.Input[str] oauth2_start_idp_link: A FreeMarker template that is rendered when the user requests the /oauth2/start-idp-link path. This page is used if the Identity Provider is configured to have a pending link. The user is presented with the option to link their account with an existing FusionAuth user account.
        :param pulumi.Input[str] oauth2_two_factor: A FreeMarker template that is rendered when the user requests the /oauth2/two-factor path. This page is used if the user has two-factor authentication enabled and they need to type in their code again. FusionAuth will properly handle the processing on the back end. This page contains the form that the user will put their code into.
        :param pulumi.Input[str] oauth2_two_factor_methods: A FreeMarker template that is rendered when the user requests the /oauth2/two-factor-methods path. This page contains a form providing a user with their configured multi-factor authentication options that they may use to complete the authentication challenge.
        :param pulumi.Input[str] oauth2_wait: A FreeMarker template that is rendered when the user requests the /oauth2/wait path. This page is rendered when FusionAuth is waiting for an external provider to complete an out of band authentication request. For example, during a HYPR login this page will be displayed until the user completes authentication.
        :param pulumi.Input[str] password_change: A FreeMarker template that is rendered when the user requests the /password/change path. This page is used if the user is required to change their password or if they have requested a password reset. This page contains the form that allows the user to provide a new password.
        :param pulumi.Input[str] password_complete: A FreeMarker template that is rendered when the user requests the /password/complete path. This page is used after the user has successfully updated their password, or reset it. This page should instruct the user that their password was updated and that they need to login again.
        :param pulumi.Input[str] password_forgot: A FreeMarker template that is rendered when the user requests the /password/forgot path. This page is used when a user starts the forgot password workflow. This page renders the form where the user types in their email address.
        :param pulumi.Input[str] password_sent: A FreeMarker template that is rendered when the user requests the /password/sent path. This page is used when a user has submitted the forgot password form with their email. FusionAuth does not indicate back to the user if their email address was valid in order to prevent malicious activity that could reveal valid email addresses. Therefore, this page should indicate to the user that if their email was valid, they will receive an email shortly with a link to reset their password.
        :param pulumi.Input[str] registration_complete: A FreeMarker template that is rendered when the user requests the /registration/complete path. This page is used after a user has verified their email address for a specific application (i.e. a user registration) by clicking the URL in the email. After FusionAuth has updated their registration object to indicate that their email was verified, the browser is redirected to this page.
        :param pulumi.Input[str] registration_send: A FreeMarker template that is rendered when the user requests the /registration/send page. This page is used after a user has asked for the application specific verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        :param pulumi.Input[str] registration_sent: A FreeMarker template that is rendered when the user requests the /registration/sent path. This page is used after a user has asked for the application specific verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        :param pulumi.Input[str] registration_verification_required: A FreeMarker template that is rendered when the user requests the /registration/verification-required path. This page is rendered when a user is required to verify their registration prior to being allowed to proceed with the registration flow. This occurs when Unverified behavior is set to Gated in registration verification settings on the Application.
        :param pulumi.Input[str] registration_verify: A FreeMarker template that is rendered when the user requests the /registration/verify path. This page is used when a user clicks the URL from the application specific verification email and the verificationId has expired. FusionAuth expires verificationId after a period of time (which is configurable). If the user has a URL from the verification email that has expired, this page will be rendered and the error will be displayed to the user.
        :param pulumi.Input[str] samlv2_logout: A FreeMarker template that is rendered when the user requests the /samlv2/logout path. This page is used if the user initiates a SAML logout. This page causes the user to be logged out of all associated applications via a front-channel mechanism before being redirected.
        :param pulumi.Input[str] source_theme_id: The optional Id of an existing Theme to make a copy of. If present, the defaultMessages, localizedMessages, templates, and stylesheet from the source Theme will be copied to the new Theme.
        :param pulumi.Input[str] stylesheet: A CSS stylesheet used to style the templates.
        :param pulumi.Input[str] unauthorized: An optional FreeMarker template that contains the unauthorized page.
        """
        if account_edit is not None:
            pulumi.set(__self__, "account_edit", account_edit)
        if account_index is not None:
            pulumi.set(__self__, "account_index", account_index)
        if account_two_factor_disable is not None:
            pulumi.set(__self__, "account_two_factor_disable", account_two_factor_disable)
        if account_two_factor_enable is not None:
            pulumi.set(__self__, "account_two_factor_enable", account_two_factor_enable)
        if account_two_factor_index is not None:
            pulumi.set(__self__, "account_two_factor_index", account_two_factor_index)
        if default_messages is not None:
            pulumi.set(__self__, "default_messages", default_messages)
        if email_complete is not None:
            pulumi.set(__self__, "email_complete", email_complete)
        if email_send is not None:
            warnings.warn("""Use email_sent instead. API endpoint has been migrated from /email/send to /email/sent.""", DeprecationWarning)
            pulumi.log.warn("""email_send is deprecated: Use email_sent instead. API endpoint has been migrated from /email/send to /email/sent.""")
        if email_send is not None:
            pulumi.set(__self__, "email_send", email_send)
        if email_sent is not None:
            pulumi.set(__self__, "email_sent", email_sent)
        if email_verification_required is not None:
            pulumi.set(__self__, "email_verification_required", email_verification_required)
        if email_verify is not None:
            pulumi.set(__self__, "email_verify", email_verify)
        if helpers is not None:
            pulumi.set(__self__, "helpers", helpers)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if localized_messages is not None:
            pulumi.set(__self__, "localized_messages", localized_messages)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth2_authorize is not None:
            pulumi.set(__self__, "oauth2_authorize", oauth2_authorize)
        if oauth2_authorized_not_registered is not None:
            pulumi.set(__self__, "oauth2_authorized_not_registered", oauth2_authorized_not_registered)
        if oauth2_child_registration_not_allowed is not None:
            pulumi.set(__self__, "oauth2_child_registration_not_allowed", oauth2_child_registration_not_allowed)
        if oauth2_child_registration_not_allowed_complete is not None:
            pulumi.set(__self__, "oauth2_child_registration_not_allowed_complete", oauth2_child_registration_not_allowed_complete)
        if oauth2_complete_registration is not None:
            pulumi.set(__self__, "oauth2_complete_registration", oauth2_complete_registration)
        if oauth2_device is not None:
            pulumi.set(__self__, "oauth2_device", oauth2_device)
        if oauth2_device_complete is not None:
            pulumi.set(__self__, "oauth2_device_complete", oauth2_device_complete)
        if oauth2_error is not None:
            pulumi.set(__self__, "oauth2_error", oauth2_error)
        if oauth2_logout is not None:
            pulumi.set(__self__, "oauth2_logout", oauth2_logout)
        if oauth2_passwordless is not None:
            pulumi.set(__self__, "oauth2_passwordless", oauth2_passwordless)
        if oauth2_register is not None:
            pulumi.set(__self__, "oauth2_register", oauth2_register)
        if oauth2_start_idp_link is not None:
            pulumi.set(__self__, "oauth2_start_idp_link", oauth2_start_idp_link)
        if oauth2_two_factor is not None:
            pulumi.set(__self__, "oauth2_two_factor", oauth2_two_factor)
        if oauth2_two_factor_methods is not None:
            pulumi.set(__self__, "oauth2_two_factor_methods", oauth2_two_factor_methods)
        if oauth2_wait is not None:
            pulumi.set(__self__, "oauth2_wait", oauth2_wait)
        if password_change is not None:
            pulumi.set(__self__, "password_change", password_change)
        if password_complete is not None:
            pulumi.set(__self__, "password_complete", password_complete)
        if password_forgot is not None:
            pulumi.set(__self__, "password_forgot", password_forgot)
        if password_sent is not None:
            pulumi.set(__self__, "password_sent", password_sent)
        if registration_complete is not None:
            pulumi.set(__self__, "registration_complete", registration_complete)
        if registration_send is not None:
            warnings.warn("""Use registration_sent instead. API endpoint has been migrated from /registration/send to /registration/sent.""", DeprecationWarning)
            pulumi.log.warn("""registration_send is deprecated: Use registration_sent instead. API endpoint has been migrated from /registration/send to /registration/sent.""")
        if registration_send is not None:
            pulumi.set(__self__, "registration_send", registration_send)
        if registration_sent is not None:
            pulumi.set(__self__, "registration_sent", registration_sent)
        if registration_verification_required is not None:
            pulumi.set(__self__, "registration_verification_required", registration_verification_required)
        if registration_verify is not None:
            pulumi.set(__self__, "registration_verify", registration_verify)
        if samlv2_logout is not None:
            pulumi.set(__self__, "samlv2_logout", samlv2_logout)
        if source_theme_id is not None:
            pulumi.set(__self__, "source_theme_id", source_theme_id)
        if stylesheet is not None:
            pulumi.set(__self__, "stylesheet", stylesheet)
        if unauthorized is not None:
            pulumi.set(__self__, "unauthorized", unauthorized)

    @property
    @pulumi.getter(name="accountEdit")
    def account_edit(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /account/edit path. This page contains a form that enables authenticated users to update their profile.
        """
        return pulumi.get(self, "account_edit")

    @account_edit.setter
    def account_edit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_edit", value)

    @property
    @pulumi.getter(name="accountIndex")
    def account_index(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /account path. This is the self-service account landing page. An authenticated user may use this as a starting point for operations such as updating their profile or configuring multi-factor authentication.
        """
        return pulumi.get(self, "account_index")

    @account_index.setter
    def account_index(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_index", value)

    @property
    @pulumi.getter(name="accountTwoFactorDisable")
    def account_two_factor_disable(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /account/two-factor/disable path. This page contains a form that accepts a verification code used to disable a multi-factor authentication method.
        """
        return pulumi.get(self, "account_two_factor_disable")

    @account_two_factor_disable.setter
    def account_two_factor_disable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_two_factor_disable", value)

    @property
    @pulumi.getter(name="accountTwoFactorEnable")
    def account_two_factor_enable(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /account/two-factor/enable path. This page contains a form that accepts a verification code used to enable a multi-factor authentication method. Additionally, this page contains presentation of recovery codes when a user enables multi-factor authentication for the first time.
        """
        return pulumi.get(self, "account_two_factor_enable")

    @account_two_factor_enable.setter
    def account_two_factor_enable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_two_factor_enable", value)

    @property
    @pulumi.getter(name="accountTwoFactorIndex")
    def account_two_factor_index(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /account/two-factor path. This page displays an authenticated user’s configured multi-factor authentication methods. Additionally, it provides links to enable and disable a method.
        """
        return pulumi.get(self, "account_two_factor_index")

    @account_two_factor_index.setter
    def account_two_factor_index(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_two_factor_index", value)

    @property
    @pulumi.getter(name="defaultMessages")
    def default_messages(self) -> Optional[pulumi.Input[str]]:
        """
        A properties file formatted String containing at least all of the message keys defined in the FusionAuth shipped messages file. Required if not copying an existing Theme.
        """
        return pulumi.get(self, "default_messages")

    @default_messages.setter
    def default_messages(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_messages", value)

    @property
    @pulumi.getter(name="emailComplete")
    def email_complete(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /email/complete path. This page is used after a user has verified their email address by clicking the URL in the email. After FusionAuth has updated their user object to indicate that their email was verified, the browser is redirected to this page.
        """
        return pulumi.get(self, "email_complete")

    @email_complete.setter
    def email_complete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_complete", value)

    @property
    @pulumi.getter(name="emailSend")
    def email_send(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /email/send page. This page is used after a user has asked for the verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        """
        return pulumi.get(self, "email_send")

    @email_send.setter
    def email_send(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_send", value)

    @property
    @pulumi.getter(name="emailSent")
    def email_sent(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /email/sent path. This page is used after a user has asked for the verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        """
        return pulumi.get(self, "email_sent")

    @email_sent.setter
    def email_sent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_sent", value)

    @property
    @pulumi.getter(name="emailVerificationRequired")
    def email_verification_required(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /email/verification-required path. This page is rendered when a user is required to verify their email address prior to being allowed to proceed with login. This occurs when Unverified behavior is set to Gated in email verification settings on the Tenant.
        """
        return pulumi.get(self, "email_verification_required")

    @email_verification_required.setter
    def email_verification_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_verification_required", value)

    @property
    @pulumi.getter(name="emailVerify")
    def email_verify(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /email/verify path. This page is rendered when a user clicks the URL from the verification email and the verificationId has expired. FusionAuth expires verificationId after a period of time (which is configurable). If the user has a URL from the verification email that has expired, this page will be rendered and the error will be displayed to the user.
        """
        return pulumi.get(self, "email_verify")

    @email_verify.setter
    def email_verify(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_verify", value)

    @property
    @pulumi.getter
    def helpers(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that contains all of the macros and templates used by the rest of the login Theme FreeMarker templates. This allows you to configure the general layout of your UI configuration and login theme without having to copy and paste HTML into each of the templates.
        """
        return pulumi.get(self, "helpers")

    @helpers.setter
    def helpers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "helpers", value)

    @property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the / path. This is the root landing page. This page is available to unauthenticated users and will be displayed whenever someone navigates to the FusionAuth host’s root page. Prior to version 1.27.0, navigating to this URL would redirect to /admin and would subsequently render the FusionAuth admin login page.
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "index", value)

    @property
    @pulumi.getter(name="localizedMessages")
    def localized_messages(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A Map of localized versions of the messages. The key is the Locale and the value is a properties file formatted String.
        """
        return pulumi.get(self, "localized_messages")

    @localized_messages.setter
    def localized_messages(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "localized_messages", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name for the Theme.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauth2Authorize")
    def oauth2_authorize(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/authorize path. This is the main login page for FusionAuth and is used for all interactive OAuth2 and OpenID Connect workflows.
        """
        return pulumi.get(self, "oauth2_authorize")

    @oauth2_authorize.setter
    def oauth2_authorize(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_authorize", value)

    @property
    @pulumi.getter(name="oauth2AuthorizedNotRegistered")
    def oauth2_authorized_not_registered(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/authorized-not-registered path. This page is rendered when a user is not registered and the Application configuration requires registration before FusionAuth will complete the redirect.
        """
        return pulumi.get(self, "oauth2_authorized_not_registered")

    @oauth2_authorized_not_registered.setter
    def oauth2_authorized_not_registered(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_authorized_not_registered", value)

    @property
    @pulumi.getter(name="oauth2ChildRegistrationNotAllowed")
    def oauth2_child_registration_not_allowed(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/child-registration-not-allowed path. This page contains a form where a child must provide their parent’s email address to ask their parent to create an account for them in a Consent workflow.
        """
        return pulumi.get(self, "oauth2_child_registration_not_allowed")

    @oauth2_child_registration_not_allowed.setter
    def oauth2_child_registration_not_allowed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_child_registration_not_allowed", value)

    @property
    @pulumi.getter(name="oauth2ChildRegistrationNotAllowedComplete")
    def oauth2_child_registration_not_allowed_complete(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/child-registration-not-allowed-complete path. This page is rendered is rendered after a child provides their parent’s email address for parental consent in a Consent workflow.
        """
        return pulumi.get(self, "oauth2_child_registration_not_allowed_complete")

    @oauth2_child_registration_not_allowed_complete.setter
    def oauth2_child_registration_not_allowed_complete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_child_registration_not_allowed_complete", value)

    @property
    @pulumi.getter(name="oauth2CompleteRegistration")
    def oauth2_complete_registration(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/complete-registration path. This page contains a form that is used for users that have accounts but might be missing required fields.
        """
        return pulumi.get(self, "oauth2_complete_registration")

    @oauth2_complete_registration.setter
    def oauth2_complete_registration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_complete_registration", value)

    @property
    @pulumi.getter(name="oauth2Device")
    def oauth2_device(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/device path. This page contains a form for accepting an end user’s short code for the interactive portion of the OAuth Device Authorization Grant workflow.
        """
        return pulumi.get(self, "oauth2_device")

    @oauth2_device.setter
    def oauth2_device(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_device", value)

    @property
    @pulumi.getter(name="oauth2DeviceComplete")
    def oauth2_device_complete(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/device-complete path. This page contains a complete message indicating the device authentication has completed.
        """
        return pulumi.get(self, "oauth2_device_complete")

    @oauth2_device_complete.setter
    def oauth2_device_complete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_device_complete", value)

    @property
    @pulumi.getter(name="oauth2Error")
    def oauth2_error(self) -> Optional[pulumi.Input[str]]:
        """
        This page is used if the user starts or is in the middle of the OAuth workflow and any type of error occurs. This could be caused by the user messing with the URL or internally some type of information wasn’t passed between the OAuth endpoints correctly. For example, if you are federating login to an external IdP and that IdP does not properly echo the state parameter, FusionAuth’s OAuth workflow will break and this page will be displayed.
        """
        return pulumi.get(self, "oauth2_error")

    @oauth2_error.setter
    def oauth2_error(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_error", value)

    @property
    @pulumi.getter(name="oauth2Logout")
    def oauth2_logout(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/logout page. This page is used if the user initiates a logout. This page causes the user to be logged out of all associated applications via a front-channel mechanism before being redirected.
        """
        return pulumi.get(self, "oauth2_logout")

    @oauth2_logout.setter
    def oauth2_logout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_logout", value)

    @property
    @pulumi.getter(name="oauth2Passwordless")
    def oauth2_passwordless(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/passwordless path. This page is rendered when the user starts the passwordless login workflow. The page renders the form where the user types in their email address.
        """
        return pulumi.get(self, "oauth2_passwordless")

    @oauth2_passwordless.setter
    def oauth2_passwordless(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_passwordless", value)

    @property
    @pulumi.getter(name="oauth2Register")
    def oauth2_register(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/register path. This page is used to register or sign up the user for the application when self-service registration is enabled.
        """
        return pulumi.get(self, "oauth2_register")

    @oauth2_register.setter
    def oauth2_register(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_register", value)

    @property
    @pulumi.getter(name="oauth2StartIdpLink")
    def oauth2_start_idp_link(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/start-idp-link path. This page is used if the Identity Provider is configured to have a pending link. The user is presented with the option to link their account with an existing FusionAuth user account.
        """
        return pulumi.get(self, "oauth2_start_idp_link")

    @oauth2_start_idp_link.setter
    def oauth2_start_idp_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_start_idp_link", value)

    @property
    @pulumi.getter(name="oauth2TwoFactor")
    def oauth2_two_factor(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/two-factor path. This page is used if the user has two-factor authentication enabled and they need to type in their code again. FusionAuth will properly handle the processing on the back end. This page contains the form that the user will put their code into.
        """
        return pulumi.get(self, "oauth2_two_factor")

    @oauth2_two_factor.setter
    def oauth2_two_factor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_two_factor", value)

    @property
    @pulumi.getter(name="oauth2TwoFactorMethods")
    def oauth2_two_factor_methods(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/two-factor-methods path. This page contains a form providing a user with their configured multi-factor authentication options that they may use to complete the authentication challenge.
        """
        return pulumi.get(self, "oauth2_two_factor_methods")

    @oauth2_two_factor_methods.setter
    def oauth2_two_factor_methods(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_two_factor_methods", value)

    @property
    @pulumi.getter(name="oauth2Wait")
    def oauth2_wait(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/wait path. This page is rendered when FusionAuth is waiting for an external provider to complete an out of band authentication request. For example, during a HYPR login this page will be displayed until the user completes authentication.
        """
        return pulumi.get(self, "oauth2_wait")

    @oauth2_wait.setter
    def oauth2_wait(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_wait", value)

    @property
    @pulumi.getter(name="passwordChange")
    def password_change(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /password/change path. This page is used if the user is required to change their password or if they have requested a password reset. This page contains the form that allows the user to provide a new password.
        """
        return pulumi.get(self, "password_change")

    @password_change.setter
    def password_change(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_change", value)

    @property
    @pulumi.getter(name="passwordComplete")
    def password_complete(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /password/complete path. This page is used after the user has successfully updated their password, or reset it. This page should instruct the user that their password was updated and that they need to login again.
        """
        return pulumi.get(self, "password_complete")

    @password_complete.setter
    def password_complete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_complete", value)

    @property
    @pulumi.getter(name="passwordForgot")
    def password_forgot(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /password/forgot path. This page is used when a user starts the forgot password workflow. This page renders the form where the user types in their email address.
        """
        return pulumi.get(self, "password_forgot")

    @password_forgot.setter
    def password_forgot(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_forgot", value)

    @property
    @pulumi.getter(name="passwordSent")
    def password_sent(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /password/sent path. This page is used when a user has submitted the forgot password form with their email. FusionAuth does not indicate back to the user if their email address was valid in order to prevent malicious activity that could reveal valid email addresses. Therefore, this page should indicate to the user that if their email was valid, they will receive an email shortly with a link to reset their password.
        """
        return pulumi.get(self, "password_sent")

    @password_sent.setter
    def password_sent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_sent", value)

    @property
    @pulumi.getter(name="registrationComplete")
    def registration_complete(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /registration/complete path. This page is used after a user has verified their email address for a specific application (i.e. a user registration) by clicking the URL in the email. After FusionAuth has updated their registration object to indicate that their email was verified, the browser is redirected to this page.
        """
        return pulumi.get(self, "registration_complete")

    @registration_complete.setter
    def registration_complete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_complete", value)

    @property
    @pulumi.getter(name="registrationSend")
    def registration_send(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /registration/send page. This page is used after a user has asked for the application specific verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        """
        return pulumi.get(self, "registration_send")

    @registration_send.setter
    def registration_send(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_send", value)

    @property
    @pulumi.getter(name="registrationSent")
    def registration_sent(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /registration/sent path. This page is used after a user has asked for the application specific verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        """
        return pulumi.get(self, "registration_sent")

    @registration_sent.setter
    def registration_sent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_sent", value)

    @property
    @pulumi.getter(name="registrationVerificationRequired")
    def registration_verification_required(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /registration/verification-required path. This page is rendered when a user is required to verify their registration prior to being allowed to proceed with the registration flow. This occurs when Unverified behavior is set to Gated in registration verification settings on the Application.
        """
        return pulumi.get(self, "registration_verification_required")

    @registration_verification_required.setter
    def registration_verification_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_verification_required", value)

    @property
    @pulumi.getter(name="registrationVerify")
    def registration_verify(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /registration/verify path. This page is used when a user clicks the URL from the application specific verification email and the verificationId has expired. FusionAuth expires verificationId after a period of time (which is configurable). If the user has a URL from the verification email that has expired, this page will be rendered and the error will be displayed to the user.
        """
        return pulumi.get(self, "registration_verify")

    @registration_verify.setter
    def registration_verify(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_verify", value)

    @property
    @pulumi.getter(name="samlv2Logout")
    def samlv2_logout(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /samlv2/logout path. This page is used if the user initiates a SAML logout. This page causes the user to be logged out of all associated applications via a front-channel mechanism before being redirected.
        """
        return pulumi.get(self, "samlv2_logout")

    @samlv2_logout.setter
    def samlv2_logout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "samlv2_logout", value)

    @property
    @pulumi.getter(name="sourceThemeId")
    def source_theme_id(self) -> Optional[pulumi.Input[str]]:
        """
        The optional Id of an existing Theme to make a copy of. If present, the defaultMessages, localizedMessages, templates, and stylesheet from the source Theme will be copied to the new Theme.
        """
        return pulumi.get(self, "source_theme_id")

    @source_theme_id.setter
    def source_theme_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_theme_id", value)

    @property
    @pulumi.getter
    def stylesheet(self) -> Optional[pulumi.Input[str]]:
        """
        A CSS stylesheet used to style the templates.
        """
        return pulumi.get(self, "stylesheet")

    @stylesheet.setter
    def stylesheet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stylesheet", value)

    @property
    @pulumi.getter
    def unauthorized(self) -> Optional[pulumi.Input[str]]:
        """
        An optional FreeMarker template that contains the unauthorized page.
        """
        return pulumi.get(self, "unauthorized")

    @unauthorized.setter
    def unauthorized(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unauthorized", value)


@pulumi.input_type
class _FusionAuthThemeState:
    def __init__(__self__, *,
                 account_edit: Optional[pulumi.Input[str]] = None,
                 account_index: Optional[pulumi.Input[str]] = None,
                 account_two_factor_disable: Optional[pulumi.Input[str]] = None,
                 account_two_factor_enable: Optional[pulumi.Input[str]] = None,
                 account_two_factor_index: Optional[pulumi.Input[str]] = None,
                 default_messages: Optional[pulumi.Input[str]] = None,
                 email_complete: Optional[pulumi.Input[str]] = None,
                 email_send: Optional[pulumi.Input[str]] = None,
                 email_sent: Optional[pulumi.Input[str]] = None,
                 email_verification_required: Optional[pulumi.Input[str]] = None,
                 email_verify: Optional[pulumi.Input[str]] = None,
                 helpers: Optional[pulumi.Input[str]] = None,
                 index: Optional[pulumi.Input[str]] = None,
                 localized_messages: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth2_authorize: Optional[pulumi.Input[str]] = None,
                 oauth2_authorized_not_registered: Optional[pulumi.Input[str]] = None,
                 oauth2_child_registration_not_allowed: Optional[pulumi.Input[str]] = None,
                 oauth2_child_registration_not_allowed_complete: Optional[pulumi.Input[str]] = None,
                 oauth2_complete_registration: Optional[pulumi.Input[str]] = None,
                 oauth2_device: Optional[pulumi.Input[str]] = None,
                 oauth2_device_complete: Optional[pulumi.Input[str]] = None,
                 oauth2_error: Optional[pulumi.Input[str]] = None,
                 oauth2_logout: Optional[pulumi.Input[str]] = None,
                 oauth2_passwordless: Optional[pulumi.Input[str]] = None,
                 oauth2_register: Optional[pulumi.Input[str]] = None,
                 oauth2_start_idp_link: Optional[pulumi.Input[str]] = None,
                 oauth2_two_factor: Optional[pulumi.Input[str]] = None,
                 oauth2_two_factor_methods: Optional[pulumi.Input[str]] = None,
                 oauth2_wait: Optional[pulumi.Input[str]] = None,
                 password_change: Optional[pulumi.Input[str]] = None,
                 password_complete: Optional[pulumi.Input[str]] = None,
                 password_forgot: Optional[pulumi.Input[str]] = None,
                 password_sent: Optional[pulumi.Input[str]] = None,
                 registration_complete: Optional[pulumi.Input[str]] = None,
                 registration_send: Optional[pulumi.Input[str]] = None,
                 registration_sent: Optional[pulumi.Input[str]] = None,
                 registration_verification_required: Optional[pulumi.Input[str]] = None,
                 registration_verify: Optional[pulumi.Input[str]] = None,
                 samlv2_logout: Optional[pulumi.Input[str]] = None,
                 source_theme_id: Optional[pulumi.Input[str]] = None,
                 stylesheet: Optional[pulumi.Input[str]] = None,
                 unauthorized: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FusionAuthTheme resources.
        :param pulumi.Input[str] account_edit: A FreeMarker template that is rendered when the user requests the /account/edit path. This page contains a form that enables authenticated users to update their profile.
        :param pulumi.Input[str] account_index: A FreeMarker template that is rendered when the user requests the /account path. This is the self-service account landing page. An authenticated user may use this as a starting point for operations such as updating their profile or configuring multi-factor authentication.
        :param pulumi.Input[str] account_two_factor_disable: A FreeMarker template that is rendered when the user requests the /account/two-factor/disable path. This page contains a form that accepts a verification code used to disable a multi-factor authentication method.
        :param pulumi.Input[str] account_two_factor_enable: A FreeMarker template that is rendered when the user requests the /account/two-factor/enable path. This page contains a form that accepts a verification code used to enable a multi-factor authentication method. Additionally, this page contains presentation of recovery codes when a user enables multi-factor authentication for the first time.
        :param pulumi.Input[str] account_two_factor_index: A FreeMarker template that is rendered when the user requests the /account/two-factor path. This page displays an authenticated user’s configured multi-factor authentication methods. Additionally, it provides links to enable and disable a method.
        :param pulumi.Input[str] default_messages: A properties file formatted String containing at least all of the message keys defined in the FusionAuth shipped messages file. Required if not copying an existing Theme.
        :param pulumi.Input[str] email_complete: A FreeMarker template that is rendered when the user requests the /email/complete path. This page is used after a user has verified their email address by clicking the URL in the email. After FusionAuth has updated their user object to indicate that their email was verified, the browser is redirected to this page.
        :param pulumi.Input[str] email_send: A FreeMarker template that is rendered when the user requests the /email/send page. This page is used after a user has asked for the verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        :param pulumi.Input[str] email_sent: A FreeMarker template that is rendered when the user requests the /email/sent path. This page is used after a user has asked for the verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        :param pulumi.Input[str] email_verification_required: A FreeMarker template that is rendered when the user requests the /email/verification-required path. This page is rendered when a user is required to verify their email address prior to being allowed to proceed with login. This occurs when Unverified behavior is set to Gated in email verification settings on the Tenant.
        :param pulumi.Input[str] email_verify: A FreeMarker template that is rendered when the user requests the /email/verify path. This page is rendered when a user clicks the URL from the verification email and the verificationId has expired. FusionAuth expires verificationId after a period of time (which is configurable). If the user has a URL from the verification email that has expired, this page will be rendered and the error will be displayed to the user.
        :param pulumi.Input[str] helpers: A FreeMarker template that contains all of the macros and templates used by the rest of the login Theme FreeMarker templates. This allows you to configure the general layout of your UI configuration and login theme without having to copy and paste HTML into each of the templates.
        :param pulumi.Input[str] index: A FreeMarker template that is rendered when the user requests the / path. This is the root landing page. This page is available to unauthenticated users and will be displayed whenever someone navigates to the FusionAuth host’s root page. Prior to version 1.27.0, navigating to this URL would redirect to /admin and would subsequently render the FusionAuth admin login page.
        :param pulumi.Input[Mapping[str, Any]] localized_messages: A Map of localized versions of the messages. The key is the Locale and the value is a properties file formatted String.
        :param pulumi.Input[str] name: A unique name for the Theme.
        :param pulumi.Input[str] oauth2_authorize: A FreeMarker template that is rendered when the user requests the /oauth2/authorize path. This is the main login page for FusionAuth and is used for all interactive OAuth2 and OpenID Connect workflows.
        :param pulumi.Input[str] oauth2_authorized_not_registered: A FreeMarker template that is rendered when the user requests the /oauth2/authorized-not-registered path. This page is rendered when a user is not registered and the Application configuration requires registration before FusionAuth will complete the redirect.
        :param pulumi.Input[str] oauth2_child_registration_not_allowed: A FreeMarker template that is rendered when the user requests the /oauth2/child-registration-not-allowed path. This page contains a form where a child must provide their parent’s email address to ask their parent to create an account for them in a Consent workflow.
        :param pulumi.Input[str] oauth2_child_registration_not_allowed_complete: A FreeMarker template that is rendered when the user requests the /oauth2/child-registration-not-allowed-complete path. This page is rendered is rendered after a child provides their parent’s email address for parental consent in a Consent workflow.
        :param pulumi.Input[str] oauth2_complete_registration: A FreeMarker template that is rendered when the user requests the /oauth2/complete-registration path. This page contains a form that is used for users that have accounts but might be missing required fields.
        :param pulumi.Input[str] oauth2_device: A FreeMarker template that is rendered when the user requests the /oauth2/device path. This page contains a form for accepting an end user’s short code for the interactive portion of the OAuth Device Authorization Grant workflow.
        :param pulumi.Input[str] oauth2_device_complete: A FreeMarker template that is rendered when the user requests the /oauth2/device-complete path. This page contains a complete message indicating the device authentication has completed.
        :param pulumi.Input[str] oauth2_error: This page is used if the user starts or is in the middle of the OAuth workflow and any type of error occurs. This could be caused by the user messing with the URL or internally some type of information wasn’t passed between the OAuth endpoints correctly. For example, if you are federating login to an external IdP and that IdP does not properly echo the state parameter, FusionAuth’s OAuth workflow will break and this page will be displayed.
        :param pulumi.Input[str] oauth2_logout: A FreeMarker template that is rendered when the user requests the /oauth2/logout page. This page is used if the user initiates a logout. This page causes the user to be logged out of all associated applications via a front-channel mechanism before being redirected.
        :param pulumi.Input[str] oauth2_passwordless: A FreeMarker template that is rendered when the user requests the /oauth2/passwordless path. This page is rendered when the user starts the passwordless login workflow. The page renders the form where the user types in their email address.
        :param pulumi.Input[str] oauth2_register: A FreeMarker template that is rendered when the user requests the /oauth2/register path. This page is used to register or sign up the user for the application when self-service registration is enabled.
        :param pulumi.Input[str] oauth2_start_idp_link: A FreeMarker template that is rendered when the user requests the /oauth2/start-idp-link path. This page is used if the Identity Provider is configured to have a pending link. The user is presented with the option to link their account with an existing FusionAuth user account.
        :param pulumi.Input[str] oauth2_two_factor: A FreeMarker template that is rendered when the user requests the /oauth2/two-factor path. This page is used if the user has two-factor authentication enabled and they need to type in their code again. FusionAuth will properly handle the processing on the back end. This page contains the form that the user will put their code into.
        :param pulumi.Input[str] oauth2_two_factor_methods: A FreeMarker template that is rendered when the user requests the /oauth2/two-factor-methods path. This page contains a form providing a user with their configured multi-factor authentication options that they may use to complete the authentication challenge.
        :param pulumi.Input[str] oauth2_wait: A FreeMarker template that is rendered when the user requests the /oauth2/wait path. This page is rendered when FusionAuth is waiting for an external provider to complete an out of band authentication request. For example, during a HYPR login this page will be displayed until the user completes authentication.
        :param pulumi.Input[str] password_change: A FreeMarker template that is rendered when the user requests the /password/change path. This page is used if the user is required to change their password or if they have requested a password reset. This page contains the form that allows the user to provide a new password.
        :param pulumi.Input[str] password_complete: A FreeMarker template that is rendered when the user requests the /password/complete path. This page is used after the user has successfully updated their password, or reset it. This page should instruct the user that their password was updated and that they need to login again.
        :param pulumi.Input[str] password_forgot: A FreeMarker template that is rendered when the user requests the /password/forgot path. This page is used when a user starts the forgot password workflow. This page renders the form where the user types in their email address.
        :param pulumi.Input[str] password_sent: A FreeMarker template that is rendered when the user requests the /password/sent path. This page is used when a user has submitted the forgot password form with their email. FusionAuth does not indicate back to the user if their email address was valid in order to prevent malicious activity that could reveal valid email addresses. Therefore, this page should indicate to the user that if their email was valid, they will receive an email shortly with a link to reset their password.
        :param pulumi.Input[str] registration_complete: A FreeMarker template that is rendered when the user requests the /registration/complete path. This page is used after a user has verified their email address for a specific application (i.e. a user registration) by clicking the URL in the email. After FusionAuth has updated their registration object to indicate that their email was verified, the browser is redirected to this page.
        :param pulumi.Input[str] registration_send: A FreeMarker template that is rendered when the user requests the /registration/send page. This page is used after a user has asked for the application specific verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        :param pulumi.Input[str] registration_sent: A FreeMarker template that is rendered when the user requests the /registration/sent path. This page is used after a user has asked for the application specific verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        :param pulumi.Input[str] registration_verification_required: A FreeMarker template that is rendered when the user requests the /registration/verification-required path. This page is rendered when a user is required to verify their registration prior to being allowed to proceed with the registration flow. This occurs when Unverified behavior is set to Gated in registration verification settings on the Application.
        :param pulumi.Input[str] registration_verify: A FreeMarker template that is rendered when the user requests the /registration/verify path. This page is used when a user clicks the URL from the application specific verification email and the verificationId has expired. FusionAuth expires verificationId after a period of time (which is configurable). If the user has a URL from the verification email that has expired, this page will be rendered and the error will be displayed to the user.
        :param pulumi.Input[str] samlv2_logout: A FreeMarker template that is rendered when the user requests the /samlv2/logout path. This page is used if the user initiates a SAML logout. This page causes the user to be logged out of all associated applications via a front-channel mechanism before being redirected.
        :param pulumi.Input[str] source_theme_id: The optional Id of an existing Theme to make a copy of. If present, the defaultMessages, localizedMessages, templates, and stylesheet from the source Theme will be copied to the new Theme.
        :param pulumi.Input[str] stylesheet: A CSS stylesheet used to style the templates.
        :param pulumi.Input[str] unauthorized: An optional FreeMarker template that contains the unauthorized page.
        """
        if account_edit is not None:
            pulumi.set(__self__, "account_edit", account_edit)
        if account_index is not None:
            pulumi.set(__self__, "account_index", account_index)
        if account_two_factor_disable is not None:
            pulumi.set(__self__, "account_two_factor_disable", account_two_factor_disable)
        if account_two_factor_enable is not None:
            pulumi.set(__self__, "account_two_factor_enable", account_two_factor_enable)
        if account_two_factor_index is not None:
            pulumi.set(__self__, "account_two_factor_index", account_two_factor_index)
        if default_messages is not None:
            pulumi.set(__self__, "default_messages", default_messages)
        if email_complete is not None:
            pulumi.set(__self__, "email_complete", email_complete)
        if email_send is not None:
            warnings.warn("""Use email_sent instead. API endpoint has been migrated from /email/send to /email/sent.""", DeprecationWarning)
            pulumi.log.warn("""email_send is deprecated: Use email_sent instead. API endpoint has been migrated from /email/send to /email/sent.""")
        if email_send is not None:
            pulumi.set(__self__, "email_send", email_send)
        if email_sent is not None:
            pulumi.set(__self__, "email_sent", email_sent)
        if email_verification_required is not None:
            pulumi.set(__self__, "email_verification_required", email_verification_required)
        if email_verify is not None:
            pulumi.set(__self__, "email_verify", email_verify)
        if helpers is not None:
            pulumi.set(__self__, "helpers", helpers)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if localized_messages is not None:
            pulumi.set(__self__, "localized_messages", localized_messages)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth2_authorize is not None:
            pulumi.set(__self__, "oauth2_authorize", oauth2_authorize)
        if oauth2_authorized_not_registered is not None:
            pulumi.set(__self__, "oauth2_authorized_not_registered", oauth2_authorized_not_registered)
        if oauth2_child_registration_not_allowed is not None:
            pulumi.set(__self__, "oauth2_child_registration_not_allowed", oauth2_child_registration_not_allowed)
        if oauth2_child_registration_not_allowed_complete is not None:
            pulumi.set(__self__, "oauth2_child_registration_not_allowed_complete", oauth2_child_registration_not_allowed_complete)
        if oauth2_complete_registration is not None:
            pulumi.set(__self__, "oauth2_complete_registration", oauth2_complete_registration)
        if oauth2_device is not None:
            pulumi.set(__self__, "oauth2_device", oauth2_device)
        if oauth2_device_complete is not None:
            pulumi.set(__self__, "oauth2_device_complete", oauth2_device_complete)
        if oauth2_error is not None:
            pulumi.set(__self__, "oauth2_error", oauth2_error)
        if oauth2_logout is not None:
            pulumi.set(__self__, "oauth2_logout", oauth2_logout)
        if oauth2_passwordless is not None:
            pulumi.set(__self__, "oauth2_passwordless", oauth2_passwordless)
        if oauth2_register is not None:
            pulumi.set(__self__, "oauth2_register", oauth2_register)
        if oauth2_start_idp_link is not None:
            pulumi.set(__self__, "oauth2_start_idp_link", oauth2_start_idp_link)
        if oauth2_two_factor is not None:
            pulumi.set(__self__, "oauth2_two_factor", oauth2_two_factor)
        if oauth2_two_factor_methods is not None:
            pulumi.set(__self__, "oauth2_two_factor_methods", oauth2_two_factor_methods)
        if oauth2_wait is not None:
            pulumi.set(__self__, "oauth2_wait", oauth2_wait)
        if password_change is not None:
            pulumi.set(__self__, "password_change", password_change)
        if password_complete is not None:
            pulumi.set(__self__, "password_complete", password_complete)
        if password_forgot is not None:
            pulumi.set(__self__, "password_forgot", password_forgot)
        if password_sent is not None:
            pulumi.set(__self__, "password_sent", password_sent)
        if registration_complete is not None:
            pulumi.set(__self__, "registration_complete", registration_complete)
        if registration_send is not None:
            warnings.warn("""Use registration_sent instead. API endpoint has been migrated from /registration/send to /registration/sent.""", DeprecationWarning)
            pulumi.log.warn("""registration_send is deprecated: Use registration_sent instead. API endpoint has been migrated from /registration/send to /registration/sent.""")
        if registration_send is not None:
            pulumi.set(__self__, "registration_send", registration_send)
        if registration_sent is not None:
            pulumi.set(__self__, "registration_sent", registration_sent)
        if registration_verification_required is not None:
            pulumi.set(__self__, "registration_verification_required", registration_verification_required)
        if registration_verify is not None:
            pulumi.set(__self__, "registration_verify", registration_verify)
        if samlv2_logout is not None:
            pulumi.set(__self__, "samlv2_logout", samlv2_logout)
        if source_theme_id is not None:
            pulumi.set(__self__, "source_theme_id", source_theme_id)
        if stylesheet is not None:
            pulumi.set(__self__, "stylesheet", stylesheet)
        if unauthorized is not None:
            pulumi.set(__self__, "unauthorized", unauthorized)

    @property
    @pulumi.getter(name="accountEdit")
    def account_edit(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /account/edit path. This page contains a form that enables authenticated users to update their profile.
        """
        return pulumi.get(self, "account_edit")

    @account_edit.setter
    def account_edit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_edit", value)

    @property
    @pulumi.getter(name="accountIndex")
    def account_index(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /account path. This is the self-service account landing page. An authenticated user may use this as a starting point for operations such as updating their profile or configuring multi-factor authentication.
        """
        return pulumi.get(self, "account_index")

    @account_index.setter
    def account_index(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_index", value)

    @property
    @pulumi.getter(name="accountTwoFactorDisable")
    def account_two_factor_disable(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /account/two-factor/disable path. This page contains a form that accepts a verification code used to disable a multi-factor authentication method.
        """
        return pulumi.get(self, "account_two_factor_disable")

    @account_two_factor_disable.setter
    def account_two_factor_disable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_two_factor_disable", value)

    @property
    @pulumi.getter(name="accountTwoFactorEnable")
    def account_two_factor_enable(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /account/two-factor/enable path. This page contains a form that accepts a verification code used to enable a multi-factor authentication method. Additionally, this page contains presentation of recovery codes when a user enables multi-factor authentication for the first time.
        """
        return pulumi.get(self, "account_two_factor_enable")

    @account_two_factor_enable.setter
    def account_two_factor_enable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_two_factor_enable", value)

    @property
    @pulumi.getter(name="accountTwoFactorIndex")
    def account_two_factor_index(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /account/two-factor path. This page displays an authenticated user’s configured multi-factor authentication methods. Additionally, it provides links to enable and disable a method.
        """
        return pulumi.get(self, "account_two_factor_index")

    @account_two_factor_index.setter
    def account_two_factor_index(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_two_factor_index", value)

    @property
    @pulumi.getter(name="defaultMessages")
    def default_messages(self) -> Optional[pulumi.Input[str]]:
        """
        A properties file formatted String containing at least all of the message keys defined in the FusionAuth shipped messages file. Required if not copying an existing Theme.
        """
        return pulumi.get(self, "default_messages")

    @default_messages.setter
    def default_messages(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_messages", value)

    @property
    @pulumi.getter(name="emailComplete")
    def email_complete(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /email/complete path. This page is used after a user has verified their email address by clicking the URL in the email. After FusionAuth has updated their user object to indicate that their email was verified, the browser is redirected to this page.
        """
        return pulumi.get(self, "email_complete")

    @email_complete.setter
    def email_complete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_complete", value)

    @property
    @pulumi.getter(name="emailSend")
    def email_send(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /email/send page. This page is used after a user has asked for the verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        """
        return pulumi.get(self, "email_send")

    @email_send.setter
    def email_send(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_send", value)

    @property
    @pulumi.getter(name="emailSent")
    def email_sent(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /email/sent path. This page is used after a user has asked for the verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        """
        return pulumi.get(self, "email_sent")

    @email_sent.setter
    def email_sent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_sent", value)

    @property
    @pulumi.getter(name="emailVerificationRequired")
    def email_verification_required(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /email/verification-required path. This page is rendered when a user is required to verify their email address prior to being allowed to proceed with login. This occurs when Unverified behavior is set to Gated in email verification settings on the Tenant.
        """
        return pulumi.get(self, "email_verification_required")

    @email_verification_required.setter
    def email_verification_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_verification_required", value)

    @property
    @pulumi.getter(name="emailVerify")
    def email_verify(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /email/verify path. This page is rendered when a user clicks the URL from the verification email and the verificationId has expired. FusionAuth expires verificationId after a period of time (which is configurable). If the user has a URL from the verification email that has expired, this page will be rendered and the error will be displayed to the user.
        """
        return pulumi.get(self, "email_verify")

    @email_verify.setter
    def email_verify(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_verify", value)

    @property
    @pulumi.getter
    def helpers(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that contains all of the macros and templates used by the rest of the login Theme FreeMarker templates. This allows you to configure the general layout of your UI configuration and login theme without having to copy and paste HTML into each of the templates.
        """
        return pulumi.get(self, "helpers")

    @helpers.setter
    def helpers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "helpers", value)

    @property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the / path. This is the root landing page. This page is available to unauthenticated users and will be displayed whenever someone navigates to the FusionAuth host’s root page. Prior to version 1.27.0, navigating to this URL would redirect to /admin and would subsequently render the FusionAuth admin login page.
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "index", value)

    @property
    @pulumi.getter(name="localizedMessages")
    def localized_messages(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A Map of localized versions of the messages. The key is the Locale and the value is a properties file formatted String.
        """
        return pulumi.get(self, "localized_messages")

    @localized_messages.setter
    def localized_messages(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "localized_messages", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name for the Theme.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauth2Authorize")
    def oauth2_authorize(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/authorize path. This is the main login page for FusionAuth and is used for all interactive OAuth2 and OpenID Connect workflows.
        """
        return pulumi.get(self, "oauth2_authorize")

    @oauth2_authorize.setter
    def oauth2_authorize(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_authorize", value)

    @property
    @pulumi.getter(name="oauth2AuthorizedNotRegistered")
    def oauth2_authorized_not_registered(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/authorized-not-registered path. This page is rendered when a user is not registered and the Application configuration requires registration before FusionAuth will complete the redirect.
        """
        return pulumi.get(self, "oauth2_authorized_not_registered")

    @oauth2_authorized_not_registered.setter
    def oauth2_authorized_not_registered(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_authorized_not_registered", value)

    @property
    @pulumi.getter(name="oauth2ChildRegistrationNotAllowed")
    def oauth2_child_registration_not_allowed(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/child-registration-not-allowed path. This page contains a form where a child must provide their parent’s email address to ask their parent to create an account for them in a Consent workflow.
        """
        return pulumi.get(self, "oauth2_child_registration_not_allowed")

    @oauth2_child_registration_not_allowed.setter
    def oauth2_child_registration_not_allowed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_child_registration_not_allowed", value)

    @property
    @pulumi.getter(name="oauth2ChildRegistrationNotAllowedComplete")
    def oauth2_child_registration_not_allowed_complete(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/child-registration-not-allowed-complete path. This page is rendered is rendered after a child provides their parent’s email address for parental consent in a Consent workflow.
        """
        return pulumi.get(self, "oauth2_child_registration_not_allowed_complete")

    @oauth2_child_registration_not_allowed_complete.setter
    def oauth2_child_registration_not_allowed_complete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_child_registration_not_allowed_complete", value)

    @property
    @pulumi.getter(name="oauth2CompleteRegistration")
    def oauth2_complete_registration(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/complete-registration path. This page contains a form that is used for users that have accounts but might be missing required fields.
        """
        return pulumi.get(self, "oauth2_complete_registration")

    @oauth2_complete_registration.setter
    def oauth2_complete_registration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_complete_registration", value)

    @property
    @pulumi.getter(name="oauth2Device")
    def oauth2_device(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/device path. This page contains a form for accepting an end user’s short code for the interactive portion of the OAuth Device Authorization Grant workflow.
        """
        return pulumi.get(self, "oauth2_device")

    @oauth2_device.setter
    def oauth2_device(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_device", value)

    @property
    @pulumi.getter(name="oauth2DeviceComplete")
    def oauth2_device_complete(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/device-complete path. This page contains a complete message indicating the device authentication has completed.
        """
        return pulumi.get(self, "oauth2_device_complete")

    @oauth2_device_complete.setter
    def oauth2_device_complete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_device_complete", value)

    @property
    @pulumi.getter(name="oauth2Error")
    def oauth2_error(self) -> Optional[pulumi.Input[str]]:
        """
        This page is used if the user starts or is in the middle of the OAuth workflow and any type of error occurs. This could be caused by the user messing with the URL or internally some type of information wasn’t passed between the OAuth endpoints correctly. For example, if you are federating login to an external IdP and that IdP does not properly echo the state parameter, FusionAuth’s OAuth workflow will break and this page will be displayed.
        """
        return pulumi.get(self, "oauth2_error")

    @oauth2_error.setter
    def oauth2_error(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_error", value)

    @property
    @pulumi.getter(name="oauth2Logout")
    def oauth2_logout(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/logout page. This page is used if the user initiates a logout. This page causes the user to be logged out of all associated applications via a front-channel mechanism before being redirected.
        """
        return pulumi.get(self, "oauth2_logout")

    @oauth2_logout.setter
    def oauth2_logout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_logout", value)

    @property
    @pulumi.getter(name="oauth2Passwordless")
    def oauth2_passwordless(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/passwordless path. This page is rendered when the user starts the passwordless login workflow. The page renders the form where the user types in their email address.
        """
        return pulumi.get(self, "oauth2_passwordless")

    @oauth2_passwordless.setter
    def oauth2_passwordless(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_passwordless", value)

    @property
    @pulumi.getter(name="oauth2Register")
    def oauth2_register(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/register path. This page is used to register or sign up the user for the application when self-service registration is enabled.
        """
        return pulumi.get(self, "oauth2_register")

    @oauth2_register.setter
    def oauth2_register(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_register", value)

    @property
    @pulumi.getter(name="oauth2StartIdpLink")
    def oauth2_start_idp_link(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/start-idp-link path. This page is used if the Identity Provider is configured to have a pending link. The user is presented with the option to link their account with an existing FusionAuth user account.
        """
        return pulumi.get(self, "oauth2_start_idp_link")

    @oauth2_start_idp_link.setter
    def oauth2_start_idp_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_start_idp_link", value)

    @property
    @pulumi.getter(name="oauth2TwoFactor")
    def oauth2_two_factor(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/two-factor path. This page is used if the user has two-factor authentication enabled and they need to type in their code again. FusionAuth will properly handle the processing on the back end. This page contains the form that the user will put their code into.
        """
        return pulumi.get(self, "oauth2_two_factor")

    @oauth2_two_factor.setter
    def oauth2_two_factor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_two_factor", value)

    @property
    @pulumi.getter(name="oauth2TwoFactorMethods")
    def oauth2_two_factor_methods(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/two-factor-methods path. This page contains a form providing a user with their configured multi-factor authentication options that they may use to complete the authentication challenge.
        """
        return pulumi.get(self, "oauth2_two_factor_methods")

    @oauth2_two_factor_methods.setter
    def oauth2_two_factor_methods(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_two_factor_methods", value)

    @property
    @pulumi.getter(name="oauth2Wait")
    def oauth2_wait(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/wait path. This page is rendered when FusionAuth is waiting for an external provider to complete an out of band authentication request. For example, during a HYPR login this page will be displayed until the user completes authentication.
        """
        return pulumi.get(self, "oauth2_wait")

    @oauth2_wait.setter
    def oauth2_wait(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_wait", value)

    @property
    @pulumi.getter(name="passwordChange")
    def password_change(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /password/change path. This page is used if the user is required to change their password or if they have requested a password reset. This page contains the form that allows the user to provide a new password.
        """
        return pulumi.get(self, "password_change")

    @password_change.setter
    def password_change(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_change", value)

    @property
    @pulumi.getter(name="passwordComplete")
    def password_complete(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /password/complete path. This page is used after the user has successfully updated their password, or reset it. This page should instruct the user that their password was updated and that they need to login again.
        """
        return pulumi.get(self, "password_complete")

    @password_complete.setter
    def password_complete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_complete", value)

    @property
    @pulumi.getter(name="passwordForgot")
    def password_forgot(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /password/forgot path. This page is used when a user starts the forgot password workflow. This page renders the form where the user types in their email address.
        """
        return pulumi.get(self, "password_forgot")

    @password_forgot.setter
    def password_forgot(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_forgot", value)

    @property
    @pulumi.getter(name="passwordSent")
    def password_sent(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /password/sent path. This page is used when a user has submitted the forgot password form with their email. FusionAuth does not indicate back to the user if their email address was valid in order to prevent malicious activity that could reveal valid email addresses. Therefore, this page should indicate to the user that if their email was valid, they will receive an email shortly with a link to reset their password.
        """
        return pulumi.get(self, "password_sent")

    @password_sent.setter
    def password_sent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_sent", value)

    @property
    @pulumi.getter(name="registrationComplete")
    def registration_complete(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /registration/complete path. This page is used after a user has verified their email address for a specific application (i.e. a user registration) by clicking the URL in the email. After FusionAuth has updated their registration object to indicate that their email was verified, the browser is redirected to this page.
        """
        return pulumi.get(self, "registration_complete")

    @registration_complete.setter
    def registration_complete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_complete", value)

    @property
    @pulumi.getter(name="registrationSend")
    def registration_send(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /registration/send page. This page is used after a user has asked for the application specific verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        """
        return pulumi.get(self, "registration_send")

    @registration_send.setter
    def registration_send(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_send", value)

    @property
    @pulumi.getter(name="registrationSent")
    def registration_sent(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /registration/sent path. This page is used after a user has asked for the application specific verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        """
        return pulumi.get(self, "registration_sent")

    @registration_sent.setter
    def registration_sent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_sent", value)

    @property
    @pulumi.getter(name="registrationVerificationRequired")
    def registration_verification_required(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /registration/verification-required path. This page is rendered when a user is required to verify their registration prior to being allowed to proceed with the registration flow. This occurs when Unverified behavior is set to Gated in registration verification settings on the Application.
        """
        return pulumi.get(self, "registration_verification_required")

    @registration_verification_required.setter
    def registration_verification_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_verification_required", value)

    @property
    @pulumi.getter(name="registrationVerify")
    def registration_verify(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /registration/verify path. This page is used when a user clicks the URL from the application specific verification email and the verificationId has expired. FusionAuth expires verificationId after a period of time (which is configurable). If the user has a URL from the verification email that has expired, this page will be rendered and the error will be displayed to the user.
        """
        return pulumi.get(self, "registration_verify")

    @registration_verify.setter
    def registration_verify(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_verify", value)

    @property
    @pulumi.getter(name="samlv2Logout")
    def samlv2_logout(self) -> Optional[pulumi.Input[str]]:
        """
        A FreeMarker template that is rendered when the user requests the /samlv2/logout path. This page is used if the user initiates a SAML logout. This page causes the user to be logged out of all associated applications via a front-channel mechanism before being redirected.
        """
        return pulumi.get(self, "samlv2_logout")

    @samlv2_logout.setter
    def samlv2_logout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "samlv2_logout", value)

    @property
    @pulumi.getter(name="sourceThemeId")
    def source_theme_id(self) -> Optional[pulumi.Input[str]]:
        """
        The optional Id of an existing Theme to make a copy of. If present, the defaultMessages, localizedMessages, templates, and stylesheet from the source Theme will be copied to the new Theme.
        """
        return pulumi.get(self, "source_theme_id")

    @source_theme_id.setter
    def source_theme_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_theme_id", value)

    @property
    @pulumi.getter
    def stylesheet(self) -> Optional[pulumi.Input[str]]:
        """
        A CSS stylesheet used to style the templates.
        """
        return pulumi.get(self, "stylesheet")

    @stylesheet.setter
    def stylesheet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stylesheet", value)

    @property
    @pulumi.getter
    def unauthorized(self) -> Optional[pulumi.Input[str]]:
        """
        An optional FreeMarker template that contains the unauthorized page.
        """
        return pulumi.get(self, "unauthorized")

    @unauthorized.setter
    def unauthorized(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unauthorized", value)


class FusionAuthTheme(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_edit: Optional[pulumi.Input[str]] = None,
                 account_index: Optional[pulumi.Input[str]] = None,
                 account_two_factor_disable: Optional[pulumi.Input[str]] = None,
                 account_two_factor_enable: Optional[pulumi.Input[str]] = None,
                 account_two_factor_index: Optional[pulumi.Input[str]] = None,
                 default_messages: Optional[pulumi.Input[str]] = None,
                 email_complete: Optional[pulumi.Input[str]] = None,
                 email_send: Optional[pulumi.Input[str]] = None,
                 email_sent: Optional[pulumi.Input[str]] = None,
                 email_verification_required: Optional[pulumi.Input[str]] = None,
                 email_verify: Optional[pulumi.Input[str]] = None,
                 helpers: Optional[pulumi.Input[str]] = None,
                 index: Optional[pulumi.Input[str]] = None,
                 localized_messages: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth2_authorize: Optional[pulumi.Input[str]] = None,
                 oauth2_authorized_not_registered: Optional[pulumi.Input[str]] = None,
                 oauth2_child_registration_not_allowed: Optional[pulumi.Input[str]] = None,
                 oauth2_child_registration_not_allowed_complete: Optional[pulumi.Input[str]] = None,
                 oauth2_complete_registration: Optional[pulumi.Input[str]] = None,
                 oauth2_device: Optional[pulumi.Input[str]] = None,
                 oauth2_device_complete: Optional[pulumi.Input[str]] = None,
                 oauth2_error: Optional[pulumi.Input[str]] = None,
                 oauth2_logout: Optional[pulumi.Input[str]] = None,
                 oauth2_passwordless: Optional[pulumi.Input[str]] = None,
                 oauth2_register: Optional[pulumi.Input[str]] = None,
                 oauth2_start_idp_link: Optional[pulumi.Input[str]] = None,
                 oauth2_two_factor: Optional[pulumi.Input[str]] = None,
                 oauth2_two_factor_methods: Optional[pulumi.Input[str]] = None,
                 oauth2_wait: Optional[pulumi.Input[str]] = None,
                 password_change: Optional[pulumi.Input[str]] = None,
                 password_complete: Optional[pulumi.Input[str]] = None,
                 password_forgot: Optional[pulumi.Input[str]] = None,
                 password_sent: Optional[pulumi.Input[str]] = None,
                 registration_complete: Optional[pulumi.Input[str]] = None,
                 registration_send: Optional[pulumi.Input[str]] = None,
                 registration_sent: Optional[pulumi.Input[str]] = None,
                 registration_verification_required: Optional[pulumi.Input[str]] = None,
                 registration_verify: Optional[pulumi.Input[str]] = None,
                 samlv2_logout: Optional[pulumi.Input[str]] = None,
                 source_theme_id: Optional[pulumi.Input[str]] = None,
                 stylesheet: Optional[pulumi.Input[str]] = None,
                 unauthorized: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Theme Resource

        This Resource is used to create a role for an Application.

        [Themes API]https://fusionauth.io/docs/v1/tech/apis/themes)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        mytheme = fusionauth.FusionAuthTheme("mytheme",
            account_edit="[#ftl/]",
            account_index="[#ftl/]",
            account_two_factor_disable="[#ftl/]",
            account_two_factor_enable="[#ftl/]",
            account_two_factor_index="[#ftl/]",
            default_messages="[#ftl/]",
            email_complete="[#ftl/]",
            email_send="[#ftl/]",
            email_sent="[#ftl/]",
            email_verification_required="[#ftl/]",
            email_verify="[#ftl/]",
            helpers="[#ftl/]",
            index="[#ftl/]",
            oauth2_authorize="[#ftl/]",
            oauth2_authorized_not_registered="[#ftl/]",
            oauth2_child_registration_not_allowed="[#ftl/]",
            oauth2_child_registration_not_allowed_complete="[#ftl/]",
            oauth2_complete_registration="[#ftl/]",
            oauth2_device="[#ftl/]",
            oauth2_device_complete="[#ftl/]",
            oauth2_error="[#ftl/]",
            oauth2_logout="[#ftl/]",
            oauth2_passwordless="[#ftl/]",
            oauth2_register="[#ftl/]",
            oauth2_start_idp_link="[#ftl/]",
            oauth2_two_factor="[#ftl/]",
            oauth2_two_factor_methods="[#ftl/]",
            oauth2_wait="[#ftl/]",
            password_change="[#ftl/]",
            password_complete="[#ftl/]",
            password_forgot="[#ftl/]",
            password_sent="[#ftl/]",
            registration_complete="[#ftl/]",
            registration_send="[#ftl/]",
            registration_sent="[#ftl/]",
            registration_verification_required="[#ftl/]",
            registration_verify="[#ftl/]",
            samlv2_logout="[#ftl/]",
            stylesheet="/* stylish */",
            unauthorized="[#ftl/]")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_edit: A FreeMarker template that is rendered when the user requests the /account/edit path. This page contains a form that enables authenticated users to update their profile.
        :param pulumi.Input[str] account_index: A FreeMarker template that is rendered when the user requests the /account path. This is the self-service account landing page. An authenticated user may use this as a starting point for operations such as updating their profile or configuring multi-factor authentication.
        :param pulumi.Input[str] account_two_factor_disable: A FreeMarker template that is rendered when the user requests the /account/two-factor/disable path. This page contains a form that accepts a verification code used to disable a multi-factor authentication method.
        :param pulumi.Input[str] account_two_factor_enable: A FreeMarker template that is rendered when the user requests the /account/two-factor/enable path. This page contains a form that accepts a verification code used to enable a multi-factor authentication method. Additionally, this page contains presentation of recovery codes when a user enables multi-factor authentication for the first time.
        :param pulumi.Input[str] account_two_factor_index: A FreeMarker template that is rendered when the user requests the /account/two-factor path. This page displays an authenticated user’s configured multi-factor authentication methods. Additionally, it provides links to enable and disable a method.
        :param pulumi.Input[str] default_messages: A properties file formatted String containing at least all of the message keys defined in the FusionAuth shipped messages file. Required if not copying an existing Theme.
        :param pulumi.Input[str] email_complete: A FreeMarker template that is rendered when the user requests the /email/complete path. This page is used after a user has verified their email address by clicking the URL in the email. After FusionAuth has updated their user object to indicate that their email was verified, the browser is redirected to this page.
        :param pulumi.Input[str] email_send: A FreeMarker template that is rendered when the user requests the /email/send page. This page is used after a user has asked for the verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        :param pulumi.Input[str] email_sent: A FreeMarker template that is rendered when the user requests the /email/sent path. This page is used after a user has asked for the verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        :param pulumi.Input[str] email_verification_required: A FreeMarker template that is rendered when the user requests the /email/verification-required path. This page is rendered when a user is required to verify their email address prior to being allowed to proceed with login. This occurs when Unverified behavior is set to Gated in email verification settings on the Tenant.
        :param pulumi.Input[str] email_verify: A FreeMarker template that is rendered when the user requests the /email/verify path. This page is rendered when a user clicks the URL from the verification email and the verificationId has expired. FusionAuth expires verificationId after a period of time (which is configurable). If the user has a URL from the verification email that has expired, this page will be rendered and the error will be displayed to the user.
        :param pulumi.Input[str] helpers: A FreeMarker template that contains all of the macros and templates used by the rest of the login Theme FreeMarker templates. This allows you to configure the general layout of your UI configuration and login theme without having to copy and paste HTML into each of the templates.
        :param pulumi.Input[str] index: A FreeMarker template that is rendered when the user requests the / path. This is the root landing page. This page is available to unauthenticated users and will be displayed whenever someone navigates to the FusionAuth host’s root page. Prior to version 1.27.0, navigating to this URL would redirect to /admin and would subsequently render the FusionAuth admin login page.
        :param pulumi.Input[Mapping[str, Any]] localized_messages: A Map of localized versions of the messages. The key is the Locale and the value is a properties file formatted String.
        :param pulumi.Input[str] name: A unique name for the Theme.
        :param pulumi.Input[str] oauth2_authorize: A FreeMarker template that is rendered when the user requests the /oauth2/authorize path. This is the main login page for FusionAuth and is used for all interactive OAuth2 and OpenID Connect workflows.
        :param pulumi.Input[str] oauth2_authorized_not_registered: A FreeMarker template that is rendered when the user requests the /oauth2/authorized-not-registered path. This page is rendered when a user is not registered and the Application configuration requires registration before FusionAuth will complete the redirect.
        :param pulumi.Input[str] oauth2_child_registration_not_allowed: A FreeMarker template that is rendered when the user requests the /oauth2/child-registration-not-allowed path. This page contains a form where a child must provide their parent’s email address to ask their parent to create an account for them in a Consent workflow.
        :param pulumi.Input[str] oauth2_child_registration_not_allowed_complete: A FreeMarker template that is rendered when the user requests the /oauth2/child-registration-not-allowed-complete path. This page is rendered is rendered after a child provides their parent’s email address for parental consent in a Consent workflow.
        :param pulumi.Input[str] oauth2_complete_registration: A FreeMarker template that is rendered when the user requests the /oauth2/complete-registration path. This page contains a form that is used for users that have accounts but might be missing required fields.
        :param pulumi.Input[str] oauth2_device: A FreeMarker template that is rendered when the user requests the /oauth2/device path. This page contains a form for accepting an end user’s short code for the interactive portion of the OAuth Device Authorization Grant workflow.
        :param pulumi.Input[str] oauth2_device_complete: A FreeMarker template that is rendered when the user requests the /oauth2/device-complete path. This page contains a complete message indicating the device authentication has completed.
        :param pulumi.Input[str] oauth2_error: This page is used if the user starts or is in the middle of the OAuth workflow and any type of error occurs. This could be caused by the user messing with the URL or internally some type of information wasn’t passed between the OAuth endpoints correctly. For example, if you are federating login to an external IdP and that IdP does not properly echo the state parameter, FusionAuth’s OAuth workflow will break and this page will be displayed.
        :param pulumi.Input[str] oauth2_logout: A FreeMarker template that is rendered when the user requests the /oauth2/logout page. This page is used if the user initiates a logout. This page causes the user to be logged out of all associated applications via a front-channel mechanism before being redirected.
        :param pulumi.Input[str] oauth2_passwordless: A FreeMarker template that is rendered when the user requests the /oauth2/passwordless path. This page is rendered when the user starts the passwordless login workflow. The page renders the form where the user types in their email address.
        :param pulumi.Input[str] oauth2_register: A FreeMarker template that is rendered when the user requests the /oauth2/register path. This page is used to register or sign up the user for the application when self-service registration is enabled.
        :param pulumi.Input[str] oauth2_start_idp_link: A FreeMarker template that is rendered when the user requests the /oauth2/start-idp-link path. This page is used if the Identity Provider is configured to have a pending link. The user is presented with the option to link their account with an existing FusionAuth user account.
        :param pulumi.Input[str] oauth2_two_factor: A FreeMarker template that is rendered when the user requests the /oauth2/two-factor path. This page is used if the user has two-factor authentication enabled and they need to type in their code again. FusionAuth will properly handle the processing on the back end. This page contains the form that the user will put their code into.
        :param pulumi.Input[str] oauth2_two_factor_methods: A FreeMarker template that is rendered when the user requests the /oauth2/two-factor-methods path. This page contains a form providing a user with their configured multi-factor authentication options that they may use to complete the authentication challenge.
        :param pulumi.Input[str] oauth2_wait: A FreeMarker template that is rendered when the user requests the /oauth2/wait path. This page is rendered when FusionAuth is waiting for an external provider to complete an out of band authentication request. For example, during a HYPR login this page will be displayed until the user completes authentication.
        :param pulumi.Input[str] password_change: A FreeMarker template that is rendered when the user requests the /password/change path. This page is used if the user is required to change their password or if they have requested a password reset. This page contains the form that allows the user to provide a new password.
        :param pulumi.Input[str] password_complete: A FreeMarker template that is rendered when the user requests the /password/complete path. This page is used after the user has successfully updated their password, or reset it. This page should instruct the user that their password was updated and that they need to login again.
        :param pulumi.Input[str] password_forgot: A FreeMarker template that is rendered when the user requests the /password/forgot path. This page is used when a user starts the forgot password workflow. This page renders the form where the user types in their email address.
        :param pulumi.Input[str] password_sent: A FreeMarker template that is rendered when the user requests the /password/sent path. This page is used when a user has submitted the forgot password form with their email. FusionAuth does not indicate back to the user if their email address was valid in order to prevent malicious activity that could reveal valid email addresses. Therefore, this page should indicate to the user that if their email was valid, they will receive an email shortly with a link to reset their password.
        :param pulumi.Input[str] registration_complete: A FreeMarker template that is rendered when the user requests the /registration/complete path. This page is used after a user has verified their email address for a specific application (i.e. a user registration) by clicking the URL in the email. After FusionAuth has updated their registration object to indicate that their email was verified, the browser is redirected to this page.
        :param pulumi.Input[str] registration_send: A FreeMarker template that is rendered when the user requests the /registration/send page. This page is used after a user has asked for the application specific verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        :param pulumi.Input[str] registration_sent: A FreeMarker template that is rendered when the user requests the /registration/sent path. This page is used after a user has asked for the application specific verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        :param pulumi.Input[str] registration_verification_required: A FreeMarker template that is rendered when the user requests the /registration/verification-required path. This page is rendered when a user is required to verify their registration prior to being allowed to proceed with the registration flow. This occurs when Unverified behavior is set to Gated in registration verification settings on the Application.
        :param pulumi.Input[str] registration_verify: A FreeMarker template that is rendered when the user requests the /registration/verify path. This page is used when a user clicks the URL from the application specific verification email and the verificationId has expired. FusionAuth expires verificationId after a period of time (which is configurable). If the user has a URL from the verification email that has expired, this page will be rendered and the error will be displayed to the user.
        :param pulumi.Input[str] samlv2_logout: A FreeMarker template that is rendered when the user requests the /samlv2/logout path. This page is used if the user initiates a SAML logout. This page causes the user to be logged out of all associated applications via a front-channel mechanism before being redirected.
        :param pulumi.Input[str] source_theme_id: The optional Id of an existing Theme to make a copy of. If present, the defaultMessages, localizedMessages, templates, and stylesheet from the source Theme will be copied to the new Theme.
        :param pulumi.Input[str] stylesheet: A CSS stylesheet used to style the templates.
        :param pulumi.Input[str] unauthorized: An optional FreeMarker template that contains the unauthorized page.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FusionAuthThemeArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Theme Resource

        This Resource is used to create a role for an Application.

        [Themes API]https://fusionauth.io/docs/v1/tech/apis/themes)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        mytheme = fusionauth.FusionAuthTheme("mytheme",
            account_edit="[#ftl/]",
            account_index="[#ftl/]",
            account_two_factor_disable="[#ftl/]",
            account_two_factor_enable="[#ftl/]",
            account_two_factor_index="[#ftl/]",
            default_messages="[#ftl/]",
            email_complete="[#ftl/]",
            email_send="[#ftl/]",
            email_sent="[#ftl/]",
            email_verification_required="[#ftl/]",
            email_verify="[#ftl/]",
            helpers="[#ftl/]",
            index="[#ftl/]",
            oauth2_authorize="[#ftl/]",
            oauth2_authorized_not_registered="[#ftl/]",
            oauth2_child_registration_not_allowed="[#ftl/]",
            oauth2_child_registration_not_allowed_complete="[#ftl/]",
            oauth2_complete_registration="[#ftl/]",
            oauth2_device="[#ftl/]",
            oauth2_device_complete="[#ftl/]",
            oauth2_error="[#ftl/]",
            oauth2_logout="[#ftl/]",
            oauth2_passwordless="[#ftl/]",
            oauth2_register="[#ftl/]",
            oauth2_start_idp_link="[#ftl/]",
            oauth2_two_factor="[#ftl/]",
            oauth2_two_factor_methods="[#ftl/]",
            oauth2_wait="[#ftl/]",
            password_change="[#ftl/]",
            password_complete="[#ftl/]",
            password_forgot="[#ftl/]",
            password_sent="[#ftl/]",
            registration_complete="[#ftl/]",
            registration_send="[#ftl/]",
            registration_sent="[#ftl/]",
            registration_verification_required="[#ftl/]",
            registration_verify="[#ftl/]",
            samlv2_logout="[#ftl/]",
            stylesheet="/* stylish */",
            unauthorized="[#ftl/]")
        ```

        :param str resource_name: The name of the resource.
        :param FusionAuthThemeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthThemeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_edit: Optional[pulumi.Input[str]] = None,
                 account_index: Optional[pulumi.Input[str]] = None,
                 account_two_factor_disable: Optional[pulumi.Input[str]] = None,
                 account_two_factor_enable: Optional[pulumi.Input[str]] = None,
                 account_two_factor_index: Optional[pulumi.Input[str]] = None,
                 default_messages: Optional[pulumi.Input[str]] = None,
                 email_complete: Optional[pulumi.Input[str]] = None,
                 email_send: Optional[pulumi.Input[str]] = None,
                 email_sent: Optional[pulumi.Input[str]] = None,
                 email_verification_required: Optional[pulumi.Input[str]] = None,
                 email_verify: Optional[pulumi.Input[str]] = None,
                 helpers: Optional[pulumi.Input[str]] = None,
                 index: Optional[pulumi.Input[str]] = None,
                 localized_messages: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth2_authorize: Optional[pulumi.Input[str]] = None,
                 oauth2_authorized_not_registered: Optional[pulumi.Input[str]] = None,
                 oauth2_child_registration_not_allowed: Optional[pulumi.Input[str]] = None,
                 oauth2_child_registration_not_allowed_complete: Optional[pulumi.Input[str]] = None,
                 oauth2_complete_registration: Optional[pulumi.Input[str]] = None,
                 oauth2_device: Optional[pulumi.Input[str]] = None,
                 oauth2_device_complete: Optional[pulumi.Input[str]] = None,
                 oauth2_error: Optional[pulumi.Input[str]] = None,
                 oauth2_logout: Optional[pulumi.Input[str]] = None,
                 oauth2_passwordless: Optional[pulumi.Input[str]] = None,
                 oauth2_register: Optional[pulumi.Input[str]] = None,
                 oauth2_start_idp_link: Optional[pulumi.Input[str]] = None,
                 oauth2_two_factor: Optional[pulumi.Input[str]] = None,
                 oauth2_two_factor_methods: Optional[pulumi.Input[str]] = None,
                 oauth2_wait: Optional[pulumi.Input[str]] = None,
                 password_change: Optional[pulumi.Input[str]] = None,
                 password_complete: Optional[pulumi.Input[str]] = None,
                 password_forgot: Optional[pulumi.Input[str]] = None,
                 password_sent: Optional[pulumi.Input[str]] = None,
                 registration_complete: Optional[pulumi.Input[str]] = None,
                 registration_send: Optional[pulumi.Input[str]] = None,
                 registration_sent: Optional[pulumi.Input[str]] = None,
                 registration_verification_required: Optional[pulumi.Input[str]] = None,
                 registration_verify: Optional[pulumi.Input[str]] = None,
                 samlv2_logout: Optional[pulumi.Input[str]] = None,
                 source_theme_id: Optional[pulumi.Input[str]] = None,
                 stylesheet: Optional[pulumi.Input[str]] = None,
                 unauthorized: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthThemeArgs.__new__(FusionAuthThemeArgs)

            __props__.__dict__["account_edit"] = account_edit
            __props__.__dict__["account_index"] = account_index
            __props__.__dict__["account_two_factor_disable"] = account_two_factor_disable
            __props__.__dict__["account_two_factor_enable"] = account_two_factor_enable
            __props__.__dict__["account_two_factor_index"] = account_two_factor_index
            __props__.__dict__["default_messages"] = default_messages
            __props__.__dict__["email_complete"] = email_complete
            if email_send is not None and not opts.urn:
                warnings.warn("""Use email_sent instead. API endpoint has been migrated from /email/send to /email/sent.""", DeprecationWarning)
                pulumi.log.warn("""email_send is deprecated: Use email_sent instead. API endpoint has been migrated from /email/send to /email/sent.""")
            __props__.__dict__["email_send"] = email_send
            __props__.__dict__["email_sent"] = email_sent
            __props__.__dict__["email_verification_required"] = email_verification_required
            __props__.__dict__["email_verify"] = email_verify
            __props__.__dict__["helpers"] = helpers
            __props__.__dict__["index"] = index
            __props__.__dict__["localized_messages"] = localized_messages
            __props__.__dict__["name"] = name
            __props__.__dict__["oauth2_authorize"] = oauth2_authorize
            __props__.__dict__["oauth2_authorized_not_registered"] = oauth2_authorized_not_registered
            __props__.__dict__["oauth2_child_registration_not_allowed"] = oauth2_child_registration_not_allowed
            __props__.__dict__["oauth2_child_registration_not_allowed_complete"] = oauth2_child_registration_not_allowed_complete
            __props__.__dict__["oauth2_complete_registration"] = oauth2_complete_registration
            __props__.__dict__["oauth2_device"] = oauth2_device
            __props__.__dict__["oauth2_device_complete"] = oauth2_device_complete
            __props__.__dict__["oauth2_error"] = oauth2_error
            __props__.__dict__["oauth2_logout"] = oauth2_logout
            __props__.__dict__["oauth2_passwordless"] = oauth2_passwordless
            __props__.__dict__["oauth2_register"] = oauth2_register
            __props__.__dict__["oauth2_start_idp_link"] = oauth2_start_idp_link
            __props__.__dict__["oauth2_two_factor"] = oauth2_two_factor
            __props__.__dict__["oauth2_two_factor_methods"] = oauth2_two_factor_methods
            __props__.__dict__["oauth2_wait"] = oauth2_wait
            __props__.__dict__["password_change"] = password_change
            __props__.__dict__["password_complete"] = password_complete
            __props__.__dict__["password_forgot"] = password_forgot
            __props__.__dict__["password_sent"] = password_sent
            __props__.__dict__["registration_complete"] = registration_complete
            if registration_send is not None and not opts.urn:
                warnings.warn("""Use registration_sent instead. API endpoint has been migrated from /registration/send to /registration/sent.""", DeprecationWarning)
                pulumi.log.warn("""registration_send is deprecated: Use registration_sent instead. API endpoint has been migrated from /registration/send to /registration/sent.""")
            __props__.__dict__["registration_send"] = registration_send
            __props__.__dict__["registration_sent"] = registration_sent
            __props__.__dict__["registration_verification_required"] = registration_verification_required
            __props__.__dict__["registration_verify"] = registration_verify
            __props__.__dict__["samlv2_logout"] = samlv2_logout
            __props__.__dict__["source_theme_id"] = source_theme_id
            __props__.__dict__["stylesheet"] = stylesheet
            __props__.__dict__["unauthorized"] = unauthorized
        super(FusionAuthTheme, __self__).__init__(
            'fusionauth:index/fusionAuthTheme:FusionAuthTheme',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_edit: Optional[pulumi.Input[str]] = None,
            account_index: Optional[pulumi.Input[str]] = None,
            account_two_factor_disable: Optional[pulumi.Input[str]] = None,
            account_two_factor_enable: Optional[pulumi.Input[str]] = None,
            account_two_factor_index: Optional[pulumi.Input[str]] = None,
            default_messages: Optional[pulumi.Input[str]] = None,
            email_complete: Optional[pulumi.Input[str]] = None,
            email_send: Optional[pulumi.Input[str]] = None,
            email_sent: Optional[pulumi.Input[str]] = None,
            email_verification_required: Optional[pulumi.Input[str]] = None,
            email_verify: Optional[pulumi.Input[str]] = None,
            helpers: Optional[pulumi.Input[str]] = None,
            index: Optional[pulumi.Input[str]] = None,
            localized_messages: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            oauth2_authorize: Optional[pulumi.Input[str]] = None,
            oauth2_authorized_not_registered: Optional[pulumi.Input[str]] = None,
            oauth2_child_registration_not_allowed: Optional[pulumi.Input[str]] = None,
            oauth2_child_registration_not_allowed_complete: Optional[pulumi.Input[str]] = None,
            oauth2_complete_registration: Optional[pulumi.Input[str]] = None,
            oauth2_device: Optional[pulumi.Input[str]] = None,
            oauth2_device_complete: Optional[pulumi.Input[str]] = None,
            oauth2_error: Optional[pulumi.Input[str]] = None,
            oauth2_logout: Optional[pulumi.Input[str]] = None,
            oauth2_passwordless: Optional[pulumi.Input[str]] = None,
            oauth2_register: Optional[pulumi.Input[str]] = None,
            oauth2_start_idp_link: Optional[pulumi.Input[str]] = None,
            oauth2_two_factor: Optional[pulumi.Input[str]] = None,
            oauth2_two_factor_methods: Optional[pulumi.Input[str]] = None,
            oauth2_wait: Optional[pulumi.Input[str]] = None,
            password_change: Optional[pulumi.Input[str]] = None,
            password_complete: Optional[pulumi.Input[str]] = None,
            password_forgot: Optional[pulumi.Input[str]] = None,
            password_sent: Optional[pulumi.Input[str]] = None,
            registration_complete: Optional[pulumi.Input[str]] = None,
            registration_send: Optional[pulumi.Input[str]] = None,
            registration_sent: Optional[pulumi.Input[str]] = None,
            registration_verification_required: Optional[pulumi.Input[str]] = None,
            registration_verify: Optional[pulumi.Input[str]] = None,
            samlv2_logout: Optional[pulumi.Input[str]] = None,
            source_theme_id: Optional[pulumi.Input[str]] = None,
            stylesheet: Optional[pulumi.Input[str]] = None,
            unauthorized: Optional[pulumi.Input[str]] = None) -> 'FusionAuthTheme':
        """
        Get an existing FusionAuthTheme resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_edit: A FreeMarker template that is rendered when the user requests the /account/edit path. This page contains a form that enables authenticated users to update their profile.
        :param pulumi.Input[str] account_index: A FreeMarker template that is rendered when the user requests the /account path. This is the self-service account landing page. An authenticated user may use this as a starting point for operations such as updating their profile or configuring multi-factor authentication.
        :param pulumi.Input[str] account_two_factor_disable: A FreeMarker template that is rendered when the user requests the /account/two-factor/disable path. This page contains a form that accepts a verification code used to disable a multi-factor authentication method.
        :param pulumi.Input[str] account_two_factor_enable: A FreeMarker template that is rendered when the user requests the /account/two-factor/enable path. This page contains a form that accepts a verification code used to enable a multi-factor authentication method. Additionally, this page contains presentation of recovery codes when a user enables multi-factor authentication for the first time.
        :param pulumi.Input[str] account_two_factor_index: A FreeMarker template that is rendered when the user requests the /account/two-factor path. This page displays an authenticated user’s configured multi-factor authentication methods. Additionally, it provides links to enable and disable a method.
        :param pulumi.Input[str] default_messages: A properties file formatted String containing at least all of the message keys defined in the FusionAuth shipped messages file. Required if not copying an existing Theme.
        :param pulumi.Input[str] email_complete: A FreeMarker template that is rendered when the user requests the /email/complete path. This page is used after a user has verified their email address by clicking the URL in the email. After FusionAuth has updated their user object to indicate that their email was verified, the browser is redirected to this page.
        :param pulumi.Input[str] email_send: A FreeMarker template that is rendered when the user requests the /email/send page. This page is used after a user has asked for the verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        :param pulumi.Input[str] email_sent: A FreeMarker template that is rendered when the user requests the /email/sent path. This page is used after a user has asked for the verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        :param pulumi.Input[str] email_verification_required: A FreeMarker template that is rendered when the user requests the /email/verification-required path. This page is rendered when a user is required to verify their email address prior to being allowed to proceed with login. This occurs when Unverified behavior is set to Gated in email verification settings on the Tenant.
        :param pulumi.Input[str] email_verify: A FreeMarker template that is rendered when the user requests the /email/verify path. This page is rendered when a user clicks the URL from the verification email and the verificationId has expired. FusionAuth expires verificationId after a period of time (which is configurable). If the user has a URL from the verification email that has expired, this page will be rendered and the error will be displayed to the user.
        :param pulumi.Input[str] helpers: A FreeMarker template that contains all of the macros and templates used by the rest of the login Theme FreeMarker templates. This allows you to configure the general layout of your UI configuration and login theme without having to copy and paste HTML into each of the templates.
        :param pulumi.Input[str] index: A FreeMarker template that is rendered when the user requests the / path. This is the root landing page. This page is available to unauthenticated users and will be displayed whenever someone navigates to the FusionAuth host’s root page. Prior to version 1.27.0, navigating to this URL would redirect to /admin and would subsequently render the FusionAuth admin login page.
        :param pulumi.Input[Mapping[str, Any]] localized_messages: A Map of localized versions of the messages. The key is the Locale and the value is a properties file formatted String.
        :param pulumi.Input[str] name: A unique name for the Theme.
        :param pulumi.Input[str] oauth2_authorize: A FreeMarker template that is rendered when the user requests the /oauth2/authorize path. This is the main login page for FusionAuth and is used for all interactive OAuth2 and OpenID Connect workflows.
        :param pulumi.Input[str] oauth2_authorized_not_registered: A FreeMarker template that is rendered when the user requests the /oauth2/authorized-not-registered path. This page is rendered when a user is not registered and the Application configuration requires registration before FusionAuth will complete the redirect.
        :param pulumi.Input[str] oauth2_child_registration_not_allowed: A FreeMarker template that is rendered when the user requests the /oauth2/child-registration-not-allowed path. This page contains a form where a child must provide their parent’s email address to ask their parent to create an account for them in a Consent workflow.
        :param pulumi.Input[str] oauth2_child_registration_not_allowed_complete: A FreeMarker template that is rendered when the user requests the /oauth2/child-registration-not-allowed-complete path. This page is rendered is rendered after a child provides their parent’s email address for parental consent in a Consent workflow.
        :param pulumi.Input[str] oauth2_complete_registration: A FreeMarker template that is rendered when the user requests the /oauth2/complete-registration path. This page contains a form that is used for users that have accounts but might be missing required fields.
        :param pulumi.Input[str] oauth2_device: A FreeMarker template that is rendered when the user requests the /oauth2/device path. This page contains a form for accepting an end user’s short code for the interactive portion of the OAuth Device Authorization Grant workflow.
        :param pulumi.Input[str] oauth2_device_complete: A FreeMarker template that is rendered when the user requests the /oauth2/device-complete path. This page contains a complete message indicating the device authentication has completed.
        :param pulumi.Input[str] oauth2_error: This page is used if the user starts or is in the middle of the OAuth workflow and any type of error occurs. This could be caused by the user messing with the URL or internally some type of information wasn’t passed between the OAuth endpoints correctly. For example, if you are federating login to an external IdP and that IdP does not properly echo the state parameter, FusionAuth’s OAuth workflow will break and this page will be displayed.
        :param pulumi.Input[str] oauth2_logout: A FreeMarker template that is rendered when the user requests the /oauth2/logout page. This page is used if the user initiates a logout. This page causes the user to be logged out of all associated applications via a front-channel mechanism before being redirected.
        :param pulumi.Input[str] oauth2_passwordless: A FreeMarker template that is rendered when the user requests the /oauth2/passwordless path. This page is rendered when the user starts the passwordless login workflow. The page renders the form where the user types in their email address.
        :param pulumi.Input[str] oauth2_register: A FreeMarker template that is rendered when the user requests the /oauth2/register path. This page is used to register or sign up the user for the application when self-service registration is enabled.
        :param pulumi.Input[str] oauth2_start_idp_link: A FreeMarker template that is rendered when the user requests the /oauth2/start-idp-link path. This page is used if the Identity Provider is configured to have a pending link. The user is presented with the option to link their account with an existing FusionAuth user account.
        :param pulumi.Input[str] oauth2_two_factor: A FreeMarker template that is rendered when the user requests the /oauth2/two-factor path. This page is used if the user has two-factor authentication enabled and they need to type in their code again. FusionAuth will properly handle the processing on the back end. This page contains the form that the user will put their code into.
        :param pulumi.Input[str] oauth2_two_factor_methods: A FreeMarker template that is rendered when the user requests the /oauth2/two-factor-methods path. This page contains a form providing a user with their configured multi-factor authentication options that they may use to complete the authentication challenge.
        :param pulumi.Input[str] oauth2_wait: A FreeMarker template that is rendered when the user requests the /oauth2/wait path. This page is rendered when FusionAuth is waiting for an external provider to complete an out of band authentication request. For example, during a HYPR login this page will be displayed until the user completes authentication.
        :param pulumi.Input[str] password_change: A FreeMarker template that is rendered when the user requests the /password/change path. This page is used if the user is required to change their password or if they have requested a password reset. This page contains the form that allows the user to provide a new password.
        :param pulumi.Input[str] password_complete: A FreeMarker template that is rendered when the user requests the /password/complete path. This page is used after the user has successfully updated their password, or reset it. This page should instruct the user that their password was updated and that they need to login again.
        :param pulumi.Input[str] password_forgot: A FreeMarker template that is rendered when the user requests the /password/forgot path. This page is used when a user starts the forgot password workflow. This page renders the form where the user types in their email address.
        :param pulumi.Input[str] password_sent: A FreeMarker template that is rendered when the user requests the /password/sent path. This page is used when a user has submitted the forgot password form with their email. FusionAuth does not indicate back to the user if their email address was valid in order to prevent malicious activity that could reveal valid email addresses. Therefore, this page should indicate to the user that if their email was valid, they will receive an email shortly with a link to reset their password.
        :param pulumi.Input[str] registration_complete: A FreeMarker template that is rendered when the user requests the /registration/complete path. This page is used after a user has verified their email address for a specific application (i.e. a user registration) by clicking the URL in the email. After FusionAuth has updated their registration object to indicate that their email was verified, the browser is redirected to this page.
        :param pulumi.Input[str] registration_send: A FreeMarker template that is rendered when the user requests the /registration/send page. This page is used after a user has asked for the application specific verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        :param pulumi.Input[str] registration_sent: A FreeMarker template that is rendered when the user requests the /registration/sent path. This page is used after a user has asked for the application specific verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        :param pulumi.Input[str] registration_verification_required: A FreeMarker template that is rendered when the user requests the /registration/verification-required path. This page is rendered when a user is required to verify their registration prior to being allowed to proceed with the registration flow. This occurs when Unverified behavior is set to Gated in registration verification settings on the Application.
        :param pulumi.Input[str] registration_verify: A FreeMarker template that is rendered when the user requests the /registration/verify path. This page is used when a user clicks the URL from the application specific verification email and the verificationId has expired. FusionAuth expires verificationId after a period of time (which is configurable). If the user has a URL from the verification email that has expired, this page will be rendered and the error will be displayed to the user.
        :param pulumi.Input[str] samlv2_logout: A FreeMarker template that is rendered when the user requests the /samlv2/logout path. This page is used if the user initiates a SAML logout. This page causes the user to be logged out of all associated applications via a front-channel mechanism before being redirected.
        :param pulumi.Input[str] source_theme_id: The optional Id of an existing Theme to make a copy of. If present, the defaultMessages, localizedMessages, templates, and stylesheet from the source Theme will be copied to the new Theme.
        :param pulumi.Input[str] stylesheet: A CSS stylesheet used to style the templates.
        :param pulumi.Input[str] unauthorized: An optional FreeMarker template that contains the unauthorized page.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthThemeState.__new__(_FusionAuthThemeState)

        __props__.__dict__["account_edit"] = account_edit
        __props__.__dict__["account_index"] = account_index
        __props__.__dict__["account_two_factor_disable"] = account_two_factor_disable
        __props__.__dict__["account_two_factor_enable"] = account_two_factor_enable
        __props__.__dict__["account_two_factor_index"] = account_two_factor_index
        __props__.__dict__["default_messages"] = default_messages
        __props__.__dict__["email_complete"] = email_complete
        __props__.__dict__["email_send"] = email_send
        __props__.__dict__["email_sent"] = email_sent
        __props__.__dict__["email_verification_required"] = email_verification_required
        __props__.__dict__["email_verify"] = email_verify
        __props__.__dict__["helpers"] = helpers
        __props__.__dict__["index"] = index
        __props__.__dict__["localized_messages"] = localized_messages
        __props__.__dict__["name"] = name
        __props__.__dict__["oauth2_authorize"] = oauth2_authorize
        __props__.__dict__["oauth2_authorized_not_registered"] = oauth2_authorized_not_registered
        __props__.__dict__["oauth2_child_registration_not_allowed"] = oauth2_child_registration_not_allowed
        __props__.__dict__["oauth2_child_registration_not_allowed_complete"] = oauth2_child_registration_not_allowed_complete
        __props__.__dict__["oauth2_complete_registration"] = oauth2_complete_registration
        __props__.__dict__["oauth2_device"] = oauth2_device
        __props__.__dict__["oauth2_device_complete"] = oauth2_device_complete
        __props__.__dict__["oauth2_error"] = oauth2_error
        __props__.__dict__["oauth2_logout"] = oauth2_logout
        __props__.__dict__["oauth2_passwordless"] = oauth2_passwordless
        __props__.__dict__["oauth2_register"] = oauth2_register
        __props__.__dict__["oauth2_start_idp_link"] = oauth2_start_idp_link
        __props__.__dict__["oauth2_two_factor"] = oauth2_two_factor
        __props__.__dict__["oauth2_two_factor_methods"] = oauth2_two_factor_methods
        __props__.__dict__["oauth2_wait"] = oauth2_wait
        __props__.__dict__["password_change"] = password_change
        __props__.__dict__["password_complete"] = password_complete
        __props__.__dict__["password_forgot"] = password_forgot
        __props__.__dict__["password_sent"] = password_sent
        __props__.__dict__["registration_complete"] = registration_complete
        __props__.__dict__["registration_send"] = registration_send
        __props__.__dict__["registration_sent"] = registration_sent
        __props__.__dict__["registration_verification_required"] = registration_verification_required
        __props__.__dict__["registration_verify"] = registration_verify
        __props__.__dict__["samlv2_logout"] = samlv2_logout
        __props__.__dict__["source_theme_id"] = source_theme_id
        __props__.__dict__["stylesheet"] = stylesheet
        __props__.__dict__["unauthorized"] = unauthorized
        return FusionAuthTheme(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountEdit")
    def account_edit(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /account/edit path. This page contains a form that enables authenticated users to update their profile.
        """
        return pulumi.get(self, "account_edit")

    @property
    @pulumi.getter(name="accountIndex")
    def account_index(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /account path. This is the self-service account landing page. An authenticated user may use this as a starting point for operations such as updating their profile or configuring multi-factor authentication.
        """
        return pulumi.get(self, "account_index")

    @property
    @pulumi.getter(name="accountTwoFactorDisable")
    def account_two_factor_disable(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /account/two-factor/disable path. This page contains a form that accepts a verification code used to disable a multi-factor authentication method.
        """
        return pulumi.get(self, "account_two_factor_disable")

    @property
    @pulumi.getter(name="accountTwoFactorEnable")
    def account_two_factor_enable(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /account/two-factor/enable path. This page contains a form that accepts a verification code used to enable a multi-factor authentication method. Additionally, this page contains presentation of recovery codes when a user enables multi-factor authentication for the first time.
        """
        return pulumi.get(self, "account_two_factor_enable")

    @property
    @pulumi.getter(name="accountTwoFactorIndex")
    def account_two_factor_index(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /account/two-factor path. This page displays an authenticated user’s configured multi-factor authentication methods. Additionally, it provides links to enable and disable a method.
        """
        return pulumi.get(self, "account_two_factor_index")

    @property
    @pulumi.getter(name="defaultMessages")
    def default_messages(self) -> pulumi.Output[str]:
        """
        A properties file formatted String containing at least all of the message keys defined in the FusionAuth shipped messages file. Required if not copying an existing Theme.
        """
        return pulumi.get(self, "default_messages")

    @property
    @pulumi.getter(name="emailComplete")
    def email_complete(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /email/complete path. This page is used after a user has verified their email address by clicking the URL in the email. After FusionAuth has updated their user object to indicate that their email was verified, the browser is redirected to this page.
        """
        return pulumi.get(self, "email_complete")

    @property
    @pulumi.getter(name="emailSend")
    def email_send(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /email/send page. This page is used after a user has asked for the verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        """
        return pulumi.get(self, "email_send")

    @property
    @pulumi.getter(name="emailSent")
    def email_sent(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /email/sent path. This page is used after a user has asked for the verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        """
        return pulumi.get(self, "email_sent")

    @property
    @pulumi.getter(name="emailVerificationRequired")
    def email_verification_required(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /email/verification-required path. This page is rendered when a user is required to verify their email address prior to being allowed to proceed with login. This occurs when Unverified behavior is set to Gated in email verification settings on the Tenant.
        """
        return pulumi.get(self, "email_verification_required")

    @property
    @pulumi.getter(name="emailVerify")
    def email_verify(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /email/verify path. This page is rendered when a user clicks the URL from the verification email and the verificationId has expired. FusionAuth expires verificationId after a period of time (which is configurable). If the user has a URL from the verification email that has expired, this page will be rendered and the error will be displayed to the user.
        """
        return pulumi.get(self, "email_verify")

    @property
    @pulumi.getter
    def helpers(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that contains all of the macros and templates used by the rest of the login Theme FreeMarker templates. This allows you to configure the general layout of your UI configuration and login theme without having to copy and paste HTML into each of the templates.
        """
        return pulumi.get(self, "helpers")

    @property
    @pulumi.getter
    def index(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the / path. This is the root landing page. This page is available to unauthenticated users and will be displayed whenever someone navigates to the FusionAuth host’s root page. Prior to version 1.27.0, navigating to this URL would redirect to /admin and would subsequently render the FusionAuth admin login page.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter(name="localizedMessages")
    def localized_messages(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A Map of localized versions of the messages. The key is the Locale and the value is a properties file formatted String.
        """
        return pulumi.get(self, "localized_messages")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A unique name for the Theme.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oauth2Authorize")
    def oauth2_authorize(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/authorize path. This is the main login page for FusionAuth and is used for all interactive OAuth2 and OpenID Connect workflows.
        """
        return pulumi.get(self, "oauth2_authorize")

    @property
    @pulumi.getter(name="oauth2AuthorizedNotRegistered")
    def oauth2_authorized_not_registered(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/authorized-not-registered path. This page is rendered when a user is not registered and the Application configuration requires registration before FusionAuth will complete the redirect.
        """
        return pulumi.get(self, "oauth2_authorized_not_registered")

    @property
    @pulumi.getter(name="oauth2ChildRegistrationNotAllowed")
    def oauth2_child_registration_not_allowed(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/child-registration-not-allowed path. This page contains a form where a child must provide their parent’s email address to ask their parent to create an account for them in a Consent workflow.
        """
        return pulumi.get(self, "oauth2_child_registration_not_allowed")

    @property
    @pulumi.getter(name="oauth2ChildRegistrationNotAllowedComplete")
    def oauth2_child_registration_not_allowed_complete(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/child-registration-not-allowed-complete path. This page is rendered is rendered after a child provides their parent’s email address for parental consent in a Consent workflow.
        """
        return pulumi.get(self, "oauth2_child_registration_not_allowed_complete")

    @property
    @pulumi.getter(name="oauth2CompleteRegistration")
    def oauth2_complete_registration(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/complete-registration path. This page contains a form that is used for users that have accounts but might be missing required fields.
        """
        return pulumi.get(self, "oauth2_complete_registration")

    @property
    @pulumi.getter(name="oauth2Device")
    def oauth2_device(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/device path. This page contains a form for accepting an end user’s short code for the interactive portion of the OAuth Device Authorization Grant workflow.
        """
        return pulumi.get(self, "oauth2_device")

    @property
    @pulumi.getter(name="oauth2DeviceComplete")
    def oauth2_device_complete(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/device-complete path. This page contains a complete message indicating the device authentication has completed.
        """
        return pulumi.get(self, "oauth2_device_complete")

    @property
    @pulumi.getter(name="oauth2Error")
    def oauth2_error(self) -> pulumi.Output[str]:
        """
        This page is used if the user starts or is in the middle of the OAuth workflow and any type of error occurs. This could be caused by the user messing with the URL or internally some type of information wasn’t passed between the OAuth endpoints correctly. For example, if you are federating login to an external IdP and that IdP does not properly echo the state parameter, FusionAuth’s OAuth workflow will break and this page will be displayed.
        """
        return pulumi.get(self, "oauth2_error")

    @property
    @pulumi.getter(name="oauth2Logout")
    def oauth2_logout(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/logout page. This page is used if the user initiates a logout. This page causes the user to be logged out of all associated applications via a front-channel mechanism before being redirected.
        """
        return pulumi.get(self, "oauth2_logout")

    @property
    @pulumi.getter(name="oauth2Passwordless")
    def oauth2_passwordless(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/passwordless path. This page is rendered when the user starts the passwordless login workflow. The page renders the form where the user types in their email address.
        """
        return pulumi.get(self, "oauth2_passwordless")

    @property
    @pulumi.getter(name="oauth2Register")
    def oauth2_register(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/register path. This page is used to register or sign up the user for the application when self-service registration is enabled.
        """
        return pulumi.get(self, "oauth2_register")

    @property
    @pulumi.getter(name="oauth2StartIdpLink")
    def oauth2_start_idp_link(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/start-idp-link path. This page is used if the Identity Provider is configured to have a pending link. The user is presented with the option to link their account with an existing FusionAuth user account.
        """
        return pulumi.get(self, "oauth2_start_idp_link")

    @property
    @pulumi.getter(name="oauth2TwoFactor")
    def oauth2_two_factor(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/two-factor path. This page is used if the user has two-factor authentication enabled and they need to type in their code again. FusionAuth will properly handle the processing on the back end. This page contains the form that the user will put their code into.
        """
        return pulumi.get(self, "oauth2_two_factor")

    @property
    @pulumi.getter(name="oauth2TwoFactorMethods")
    def oauth2_two_factor_methods(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/two-factor-methods path. This page contains a form providing a user with their configured multi-factor authentication options that they may use to complete the authentication challenge.
        """
        return pulumi.get(self, "oauth2_two_factor_methods")

    @property
    @pulumi.getter(name="oauth2Wait")
    def oauth2_wait(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /oauth2/wait path. This page is rendered when FusionAuth is waiting for an external provider to complete an out of band authentication request. For example, during a HYPR login this page will be displayed until the user completes authentication.
        """
        return pulumi.get(self, "oauth2_wait")

    @property
    @pulumi.getter(name="passwordChange")
    def password_change(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /password/change path. This page is used if the user is required to change their password or if they have requested a password reset. This page contains the form that allows the user to provide a new password.
        """
        return pulumi.get(self, "password_change")

    @property
    @pulumi.getter(name="passwordComplete")
    def password_complete(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /password/complete path. This page is used after the user has successfully updated their password, or reset it. This page should instruct the user that their password was updated and that they need to login again.
        """
        return pulumi.get(self, "password_complete")

    @property
    @pulumi.getter(name="passwordForgot")
    def password_forgot(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /password/forgot path. This page is used when a user starts the forgot password workflow. This page renders the form where the user types in their email address.
        """
        return pulumi.get(self, "password_forgot")

    @property
    @pulumi.getter(name="passwordSent")
    def password_sent(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /password/sent path. This page is used when a user has submitted the forgot password form with their email. FusionAuth does not indicate back to the user if their email address was valid in order to prevent malicious activity that could reveal valid email addresses. Therefore, this page should indicate to the user that if their email was valid, they will receive an email shortly with a link to reset their password.
        """
        return pulumi.get(self, "password_sent")

    @property
    @pulumi.getter(name="registrationComplete")
    def registration_complete(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /registration/complete path. This page is used after a user has verified their email address for a specific application (i.e. a user registration) by clicking the URL in the email. After FusionAuth has updated their registration object to indicate that their email was verified, the browser is redirected to this page.
        """
        return pulumi.get(self, "registration_complete")

    @property
    @pulumi.getter(name="registrationSend")
    def registration_send(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /registration/send page. This page is used after a user has asked for the application specific verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        """
        return pulumi.get(self, "registration_send")

    @property
    @pulumi.getter(name="registrationSent")
    def registration_sent(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /registration/sent path. This page is used after a user has asked for the application specific verification email to be resent. This can happen if the URL in the email expired and the user clicked it. In this case, the user can provide their email address again and FusionAuth will resend the email. After the user submits their email and FusionAuth re-sends a verification email to them, the browser is redirected to this page.
        """
        return pulumi.get(self, "registration_sent")

    @property
    @pulumi.getter(name="registrationVerificationRequired")
    def registration_verification_required(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /registration/verification-required path. This page is rendered when a user is required to verify their registration prior to being allowed to proceed with the registration flow. This occurs when Unverified behavior is set to Gated in registration verification settings on the Application.
        """
        return pulumi.get(self, "registration_verification_required")

    @property
    @pulumi.getter(name="registrationVerify")
    def registration_verify(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /registration/verify path. This page is used when a user clicks the URL from the application specific verification email and the verificationId has expired. FusionAuth expires verificationId after a period of time (which is configurable). If the user has a URL from the verification email that has expired, this page will be rendered and the error will be displayed to the user.
        """
        return pulumi.get(self, "registration_verify")

    @property
    @pulumi.getter(name="samlv2Logout")
    def samlv2_logout(self) -> pulumi.Output[str]:
        """
        A FreeMarker template that is rendered when the user requests the /samlv2/logout path. This page is used if the user initiates a SAML logout. This page causes the user to be logged out of all associated applications via a front-channel mechanism before being redirected.
        """
        return pulumi.get(self, "samlv2_logout")

    @property
    @pulumi.getter(name="sourceThemeId")
    def source_theme_id(self) -> pulumi.Output[Optional[str]]:
        """
        The optional Id of an existing Theme to make a copy of. If present, the defaultMessages, localizedMessages, templates, and stylesheet from the source Theme will be copied to the new Theme.
        """
        return pulumi.get(self, "source_theme_id")

    @property
    @pulumi.getter
    def stylesheet(self) -> pulumi.Output[str]:
        """
        A CSS stylesheet used to style the templates.
        """
        return pulumi.get(self, "stylesheet")

    @property
    @pulumi.getter
    def unauthorized(self) -> pulumi.Output[str]:
        """
        An optional FreeMarker template that contains the unauthorized page.
        """
        return pulumi.get(self, "unauthorized")

