# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['FusionAuthRegistrationArgs', 'FusionAuthRegistration']

@pulumi.input_type
class FusionAuthRegistrationArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[str],
                 user_id: pulumi.Input[str],
                 authentication_token: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 generate_authentication_token: Optional[pulumi.Input[bool]] = None,
                 preferred_languages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 skip_registration_validation: Optional[pulumi.Input[bool]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FusionAuthRegistration resource.
        :param pulumi.Input[str] application_id: The Id of the Application that this registration is for.
        :param pulumi.Input[str] user_id: The Id of the User that is registering for the Application.
        :param pulumi.Input[str] authentication_token: The authentication token that may be used in place of the User’s password when authenticating against this application represented by this registration. This parameter is ignored if generateAuthenticationToken is set to true and instead the value will be generated.
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the User for this registration that should be persisted.
        :param pulumi.Input[bool] generate_authentication_token: Determines if FusionAuth should generate an Authentication Token for this registration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] preferred_languages: An array of locale strings that give, in order, the User’s preferred languages for this registration. These are important for email templates and other localizable text.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The list of roles that the User has for this registration.
        :param pulumi.Input[bool] skip_registration_validation: Indicates to FusionAuth that it should skip registration verification even if it is enabled for the Application.
        :param pulumi.Input[str] timezone: The User’s preferred timezone for this registration. The string will be in an IANA time zone format.
        :param pulumi.Input[str] username: The username of the User for this registration only.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "user_id", user_id)
        if authentication_token is not None:
            pulumi.set(__self__, "authentication_token", authentication_token)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if generate_authentication_token is not None:
            pulumi.set(__self__, "generate_authentication_token", generate_authentication_token)
        if preferred_languages is not None:
            pulumi.set(__self__, "preferred_languages", preferred_languages)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if skip_registration_validation is not None:
            pulumi.set(__self__, "skip_registration_validation", skip_registration_validation)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[str]:
        """
        The Id of the Application that this registration is for.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[str]:
        """
        The Id of the User that is registering for the Application.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter(name="authenticationToken")
    def authentication_token(self) -> Optional[pulumi.Input[str]]:
        """
        The authentication token that may be used in place of the User’s password when authenticating against this application represented by this registration. This parameter is ignored if generateAuthenticationToken is set to true and instead the value will be generated.
        """
        return pulumi.get(self, "authentication_token")

    @authentication_token.setter
    def authentication_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_token", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An object that can hold any information about the User for this registration that should be persisted.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="generateAuthenticationToken")
    def generate_authentication_token(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if FusionAuth should generate an Authentication Token for this registration.
        """
        return pulumi.get(self, "generate_authentication_token")

    @generate_authentication_token.setter
    def generate_authentication_token(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "generate_authentication_token", value)

    @property
    @pulumi.getter(name="preferredLanguages")
    def preferred_languages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of locale strings that give, in order, the User’s preferred languages for this registration. These are important for email templates and other localizable text.
        """
        return pulumi.get(self, "preferred_languages")

    @preferred_languages.setter
    def preferred_languages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "preferred_languages", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of roles that the User has for this registration.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter(name="skipRegistrationValidation")
    def skip_registration_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates to FusionAuth that it should skip registration verification even if it is enabled for the Application.
        """
        return pulumi.get(self, "skip_registration_validation")

    @skip_registration_validation.setter
    def skip_registration_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_registration_validation", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        The User’s preferred timezone for this registration. The string will be in an IANA time zone format.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username of the User for this registration only.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _FusionAuthRegistrationState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[str]] = None,
                 authentication_token: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 generate_authentication_token: Optional[pulumi.Input[bool]] = None,
                 preferred_languages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 skip_registration_validation: Optional[pulumi.Input[bool]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FusionAuthRegistration resources.
        :param pulumi.Input[str] application_id: The Id of the Application that this registration is for.
        :param pulumi.Input[str] authentication_token: The authentication token that may be used in place of the User’s password when authenticating against this application represented by this registration. This parameter is ignored if generateAuthenticationToken is set to true and instead the value will be generated.
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the User for this registration that should be persisted.
        :param pulumi.Input[bool] generate_authentication_token: Determines if FusionAuth should generate an Authentication Token for this registration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] preferred_languages: An array of locale strings that give, in order, the User’s preferred languages for this registration. These are important for email templates and other localizable text.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The list of roles that the User has for this registration.
        :param pulumi.Input[bool] skip_registration_validation: Indicates to FusionAuth that it should skip registration verification even if it is enabled for the Application.
        :param pulumi.Input[str] timezone: The User’s preferred timezone for this registration. The string will be in an IANA time zone format.
        :param pulumi.Input[str] user_id: The Id of the User that is registering for the Application.
        :param pulumi.Input[str] username: The username of the User for this registration only.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if authentication_token is not None:
            pulumi.set(__self__, "authentication_token", authentication_token)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if generate_authentication_token is not None:
            pulumi.set(__self__, "generate_authentication_token", generate_authentication_token)
        if preferred_languages is not None:
            pulumi.set(__self__, "preferred_languages", preferred_languages)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if skip_registration_validation is not None:
            pulumi.set(__self__, "skip_registration_validation", skip_registration_validation)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the Application that this registration is for.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="authenticationToken")
    def authentication_token(self) -> Optional[pulumi.Input[str]]:
        """
        The authentication token that may be used in place of the User’s password when authenticating against this application represented by this registration. This parameter is ignored if generateAuthenticationToken is set to true and instead the value will be generated.
        """
        return pulumi.get(self, "authentication_token")

    @authentication_token.setter
    def authentication_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_token", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An object that can hold any information about the User for this registration that should be persisted.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="generateAuthenticationToken")
    def generate_authentication_token(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if FusionAuth should generate an Authentication Token for this registration.
        """
        return pulumi.get(self, "generate_authentication_token")

    @generate_authentication_token.setter
    def generate_authentication_token(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "generate_authentication_token", value)

    @property
    @pulumi.getter(name="preferredLanguages")
    def preferred_languages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of locale strings that give, in order, the User’s preferred languages for this registration. These are important for email templates and other localizable text.
        """
        return pulumi.get(self, "preferred_languages")

    @preferred_languages.setter
    def preferred_languages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "preferred_languages", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of roles that the User has for this registration.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter(name="skipRegistrationValidation")
    def skip_registration_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates to FusionAuth that it should skip registration verification even if it is enabled for the Application.
        """
        return pulumi.get(self, "skip_registration_validation")

    @skip_registration_validation.setter
    def skip_registration_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_registration_validation", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        The User’s preferred timezone for this registration. The string will be in an IANA time zone format.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the User that is registering for the Application.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username of the User for this registration only.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class FusionAuthRegistration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 authentication_token: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 generate_authentication_token: Optional[pulumi.Input[bool]] = None,
                 preferred_languages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 skip_registration_validation: Optional[pulumi.Input[bool]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Registration Resource

        A registration is the association between a User and an Application that they log into.

        [Registrations API](https://fusionauth.io/docs/v1/tech/apis/registrations)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        example = fusionauth.FusionAuthRegistration("example",
            user_id=fusionauth_user["example"]["id"],
            application_id=data["fusionauth_application"]["FusionAuth"]["id"],
            roles=["admin"],
            username="theadmin")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: The Id of the Application that this registration is for.
        :param pulumi.Input[str] authentication_token: The authentication token that may be used in place of the User’s password when authenticating against this application represented by this registration. This parameter is ignored if generateAuthenticationToken is set to true and instead the value will be generated.
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the User for this registration that should be persisted.
        :param pulumi.Input[bool] generate_authentication_token: Determines if FusionAuth should generate an Authentication Token for this registration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] preferred_languages: An array of locale strings that give, in order, the User’s preferred languages for this registration. These are important for email templates and other localizable text.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The list of roles that the User has for this registration.
        :param pulumi.Input[bool] skip_registration_validation: Indicates to FusionAuth that it should skip registration verification even if it is enabled for the Application.
        :param pulumi.Input[str] timezone: The User’s preferred timezone for this registration. The string will be in an IANA time zone format.
        :param pulumi.Input[str] user_id: The Id of the User that is registering for the Application.
        :param pulumi.Input[str] username: The username of the User for this registration only.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionAuthRegistrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Registration Resource

        A registration is the association between a User and an Application that they log into.

        [Registrations API](https://fusionauth.io/docs/v1/tech/apis/registrations)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        example = fusionauth.FusionAuthRegistration("example",
            user_id=fusionauth_user["example"]["id"],
            application_id=data["fusionauth_application"]["FusionAuth"]["id"],
            roles=["admin"],
            username="theadmin")
        ```

        :param str resource_name: The name of the resource.
        :param FusionAuthRegistrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthRegistrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 authentication_token: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 generate_authentication_token: Optional[pulumi.Input[bool]] = None,
                 preferred_languages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 skip_registration_validation: Optional[pulumi.Input[bool]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthRegistrationArgs.__new__(FusionAuthRegistrationArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["authentication_token"] = authentication_token
            __props__.__dict__["data"] = data
            __props__.__dict__["generate_authentication_token"] = generate_authentication_token
            __props__.__dict__["preferred_languages"] = preferred_languages
            __props__.__dict__["roles"] = roles
            __props__.__dict__["skip_registration_validation"] = skip_registration_validation
            __props__.__dict__["timezone"] = timezone
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["username"] = username
        super(FusionAuthRegistration, __self__).__init__(
            'fusionauth:index/fusionAuthRegistration:FusionAuthRegistration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[str]] = None,
            authentication_token: Optional[pulumi.Input[str]] = None,
            data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            generate_authentication_token: Optional[pulumi.Input[bool]] = None,
            preferred_languages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            skip_registration_validation: Optional[pulumi.Input[bool]] = None,
            timezone: Optional[pulumi.Input[str]] = None,
            user_id: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'FusionAuthRegistration':
        """
        Get an existing FusionAuthRegistration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: The Id of the Application that this registration is for.
        :param pulumi.Input[str] authentication_token: The authentication token that may be used in place of the User’s password when authenticating against this application represented by this registration. This parameter is ignored if generateAuthenticationToken is set to true and instead the value will be generated.
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the User for this registration that should be persisted.
        :param pulumi.Input[bool] generate_authentication_token: Determines if FusionAuth should generate an Authentication Token for this registration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] preferred_languages: An array of locale strings that give, in order, the User’s preferred languages for this registration. These are important for email templates and other localizable text.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The list of roles that the User has for this registration.
        :param pulumi.Input[bool] skip_registration_validation: Indicates to FusionAuth that it should skip registration verification even if it is enabled for the Application.
        :param pulumi.Input[str] timezone: The User’s preferred timezone for this registration. The string will be in an IANA time zone format.
        :param pulumi.Input[str] user_id: The Id of the User that is registering for the Application.
        :param pulumi.Input[str] username: The username of the User for this registration only.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthRegistrationState.__new__(_FusionAuthRegistrationState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["authentication_token"] = authentication_token
        __props__.__dict__["data"] = data
        __props__.__dict__["generate_authentication_token"] = generate_authentication_token
        __props__.__dict__["preferred_languages"] = preferred_languages
        __props__.__dict__["roles"] = roles
        __props__.__dict__["skip_registration_validation"] = skip_registration_validation
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["user_id"] = user_id
        __props__.__dict__["username"] = username
        return FusionAuthRegistration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[str]:
        """
        The Id of the Application that this registration is for.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="authenticationToken")
    def authentication_token(self) -> pulumi.Output[str]:
        """
        The authentication token that may be used in place of the User’s password when authenticating against this application represented by this registration. This parameter is ignored if generateAuthenticationToken is set to true and instead the value will be generated.
        """
        return pulumi.get(self, "authentication_token")

    @property
    @pulumi.getter
    def data(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        An object that can hold any information about the User for this registration that should be persisted.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="generateAuthenticationToken")
    def generate_authentication_token(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if FusionAuth should generate an Authentication Token for this registration.
        """
        return pulumi.get(self, "generate_authentication_token")

    @property
    @pulumi.getter(name="preferredLanguages")
    def preferred_languages(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An array of locale strings that give, in order, the User’s preferred languages for this registration. These are important for email templates and other localizable text.
        """
        return pulumi.get(self, "preferred_languages")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of roles that the User has for this registration.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter(name="skipRegistrationValidation")
    def skip_registration_validation(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates to FusionAuth that it should skip registration verification even if it is enabled for the Application.
        """
        return pulumi.get(self, "skip_registration_validation")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[str]]:
        """
        The User’s preferred timezone for this registration. The string will be in an IANA time zone format.
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        The Id of the User that is registering for the Application.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[str]]:
        """
        The username of the User for this registration only.
        """
        return pulumi.get(self, "username")

