# Generated by Django 4.1.6 on 2023-07-27 07:23

from decimal import Decimal
from django.db import migrations, models
import django.db.models.deletion
import django_ticketbai.validators


class Migration(migrations.Migration):

    dependencies = [
        ("django_ticketbai", "0008_remove_invoice_user_invoice_email"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="config",
            options={
                "verbose_name": "Konfigurazioa",
                "verbose_name_plural": "Konfigurazioak",
            },
        ),
        migrations.AlterModelOptions(
            name="invoice",
            options={"verbose_name": "Faktura", "verbose_name_plural": "Fakturak"},
        ),
        migrations.AlterModelOptions(
            name="invoiceline",
            options={
                "verbose_name": "Faktura lerroa",
                "verbose_name_plural": "Faktura lerroak",
            },
        ),
        migrations.AddField(
            model_name="invoice",
            name="signature_value",
            field=models.CharField(
                blank=True, max_length=100, null=True, verbose_name="Signature Value"
            ),
        ),
        migrations.AlterField(
            model_name="config",
            name="is_active",
            field=models.BooleanField(default=True, verbose_name="Aktibo dago"),
        ),
        migrations.AlterField(
            model_name="config",
            name="password",
            field=models.CharField(
                blank=True, max_length=200, null=True, verbose_name="Pasahitza"
            ),
        ),
        migrations.AlterField(
            model_name="config",
            name="pks12",
            field=models.FileField(
                blank=True,
                null=True,
                upload_to="certs",
                validators=[django_ticketbai.validators.validate_pks_extension],
                verbose_name="Zertifikatua",
            ),
        ),
        migrations.AlterField(
            model_name="config",
            name="prefix",
            field=models.CharField(max_length=5, verbose_name="Aurrizkia"),
        ),
        migrations.AlterField(
            model_name="config",
            name="suffix",
            field=models.CharField(
                blank=True, max_length=5, null=True, verbose_name="Atzizkia"
            ),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="csv_code",
            field=models.CharField(
                blank=True, max_length=40, null=True, verbose_name="CSV"
            ),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="description",
            field=models.CharField(max_length=255, verbose_name="Deskribapena"),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="email",
            field=models.EmailField(
                blank=True, max_length=254, null=True, verbose_name="Emaila"
            ),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="errorxml",
            field=models.TextField(blank=True, null=True, verbose_name="Errore XMLa"),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="expedition_date",
            field=models.DateField(verbose_name="Jaulkipen data"),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="expedition_time",
            field=models.TimeField(verbose_name="Jaulkipen ordua"),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="num",
            field=models.IntegerField(verbose_name="Zenbakia"),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="pdf",
            field=models.FileField(
                blank=True,
                null=True,
                upload_to="ticketbai",
                validators=[django_ticketbai.validators.validate_pdf_extension],
                verbose_name="PDF fitxategia",
            ),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="serial_code",
            field=models.CharField(max_length=20, verbose_name="Serie kodea"),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="signedxml",
            field=models.TextField(
                blank=True, null=True, verbose_name="Sinatutako XMLa"
            ),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="simplified",
            field=models.CharField(
                default="N", max_length=2, verbose_name="Sinplifikatua"
            ),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="substitution",
            field=models.CharField(
                default="N", max_length=2, verbose_name="Ordezkapena"
            ),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="tbai_code",
            field=models.CharField(
                blank=True, max_length=40, null=True, verbose_name="TicketBai kodea"
            ),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="total_amount",
            field=models.DecimalField(
                decimal_places=2, default=0, max_digits=7, verbose_name="Guztira"
            ),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="transaction_date",
            field=models.DateField(verbose_name="Eragiketa data"),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="vat_regime",
            field=models.CharField(
                default="01", max_length=2, verbose_name="BEZ erregimena"
            ),
        ),
        migrations.AlterField(
            model_name="invoiceline",
            name="description",
            field=models.CharField(max_length=255, verbose_name="Deskribapena"),
        ),
        migrations.AlterField(
            model_name="invoiceline",
            name="discount",
            field=models.DecimalField(
                decimal_places=2, default=0, max_digits=4, verbose_name="Deskontua"
            ),
        ),
        migrations.AlterField(
            model_name="invoiceline",
            name="invoice",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="lines",
                to="django_ticketbai.invoice",
            ),
        ),
        migrations.AlterField(
            model_name="invoiceline",
            name="quantity",
            field=models.DecimalField(
                decimal_places=2, default=0, max_digits=7, verbose_name="Kopurua"
            ),
        ),
        migrations.AlterField(
            model_name="invoiceline",
            name="total",
            field=models.DecimalField(
                decimal_places=2, default=0, max_digits=7, verbose_name="Guztira"
            ),
        ),
        migrations.AlterField(
            model_name="invoiceline",
            name="unit_amount",
            field=models.DecimalField(
                decimal_places=2, default=0, max_digits=7, verbose_name="Unitatea"
            ),
        ),
        migrations.AlterField(
            model_name="invoiceline",
            name="vat_base",
            field=models.DecimalField(
                decimal_places=2, default=0, max_digits=7, verbose_name="BEZ oinarria"
            ),
        ),
        migrations.AlterField(
            model_name="invoiceline",
            name="vat_fee",
            field=models.DecimalField(
                decimal_places=2, default=0, max_digits=7, verbose_name="BEZ tasa"
            ),
        ),
        migrations.AlterField(
            model_name="invoiceline",
            name="vat_rate",
            field=models.DecimalField(
                decimal_places=2,
                default=Decimal("21"),
                max_digits=4,
                verbose_name="BEZ ratioa",
            ),
        ),
        migrations.AlterField(
            model_name="invoiceline",
            name="vat_type",
            field=models.CharField(
                choices=[("S1", "S1"), ("S2", "S2")],
                default="S1",
                max_length=2,
                verbose_name="BEZ mota",
            ),
        ),
    ]
