# Generated by Django 4.1.6 on 2023-07-06 13:46

from decimal import Decimal
from django.db import migrations, models
import django.db.models.deletion
import django_ticketbai.validators


class Migration(migrations.Migration):

    dependencies = [
        ("django_ticketbai", "0002_invoice_pdf_invoice_signedxml"),
    ]

    operations = [
        migrations.AlterField(
            model_name="invoice",
            name="pdf",
            field=models.FileField(
                blank=True,
                null=True,
                upload_to="ticketbai",
                validators=[django_ticketbai.validators.validate_pdf_extension],
                verbose_name="PDF file",
            ),
        ),
        migrations.CreateModel(
            name="InvoiceLine",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("description", models.CharField(max_length=255)),
                (
                    "quantity",
                    models.DecimalField(decimal_places=2, default=0, max_digits=7),
                ),
                (
                    "unit_amount",
                    models.DecimalField(decimal_places=2, default=0, max_digits=7),
                ),
                (
                    "discount",
                    models.DecimalField(decimal_places=2, default=0, max_digits=4),
                ),
                (
                    "vat_rate",
                    models.DecimalField(
                        decimal_places=2, default=Decimal("21"), max_digits=4
                    ),
                ),
                (
                    "vat_type",
                    models.CharField(
                        choices=[("S1", "S1"), ("S2", "S2")], default="S1", max_length=2
                    ),
                ),
                (
                    "vat_base",
                    models.DecimalField(decimal_places=2, default=0, max_digits=7),
                ),
                (
                    "vat_fee",
                    models.DecimalField(decimal_places=2, default=0, max_digits=7),
                ),
                (
                    "total",
                    models.DecimalField(decimal_places=2, default=0, max_digits=7),
                ),
                (
                    "invoice",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="django_ticketbai.invoice",
                    ),
                ),
            ],
            options={
                "verbose_name": "Invoice Line",
                "verbose_name_plural": "Invoice lines",
            },
        ),
    ]
