![Logo](docs/assets/logo.png)

_An educational project teaching how to open-source an interactive Python quiz app_

|  | quizli |
| --- | --- |
| Project                | [![GitHub Repo stars](https://img.shields.io/github/stars/pwenker/quizli?style=social)](https://github.com/pwenker/quizli) ![GitHub code size in bytes](https://img.shields.io/github/languages/code-size/pwenker/quizli) ![Lines of code](https://img.shields.io/tokei/lines/github/pwenker/quizli)
| Activity & Issue Tracking | ![GitHub last commit](https://img.shields.io/github/last-commit/pwenker/quizli) [![GitHub issues](https://img.shields.io/github/issues-raw/pwenker/quizli)](https://github.com/pwenker/quizli/issues?q=is%3Aopen+is%3Aissue) [![GitHub closed issues](https://img.shields.io/github/issues-closed-raw/pwenker/quizli)](https://github.com/pwenker/quizli/issues?q=is%3Aissue+is%3Aclosed)  |
| PyPI                      | [![PyPI](https://img.shields.io/pypi/v/quizli)](https://pypi.org/project/quizli/)                                                                                                                                  ![PyPI - Python Version](https://img.shields.io/pypi/pyversions/quizli) [![Downloads](https://pepy.tech/badge/quizli/month)](https://pepy.tech/project/quizli)|
| Build & Health                  | ![GitHub Workflow Status](https://img.shields.io/github/workflow/status/pwenker/quizli/CI) ![Codecov](https://img.shields.io/codecov/c/github/pwenker/quizli) |
| User Guide | [![Documentation Status](https://img.shields.io/badge/Docs-live-green)](https://pwenker.github.io/quizli/user_guide) [![Learning Guide](https://img.shields.io/badge/Tutorial-active-brightgreen)](https://pwenker.github.io/quizli/learning_guide/) |
| News & Updates | [![Twitter Follow](https://img.shields.io/twitter/follow/PascalWenker?style=social)](https://twitter.com/PascalWenker) [![GitHub followers](https://img.shields.io/github/followers/pwenker?style=social)](https://github.com/pwenker)|

## Demo

:information_source: Check the [demo page](https://pwenker.github.io/quizli/demos.html) for more examples on how to use `quizli` :information_source:

[![asciicast](https://asciinema.org/a/474148.svg)](https://asciinema.org/a/474148)

## :mortar_board: Learning Guide

This guide teaches you how to effectively share a Python app with the open-source community.

|  | Learning Guide |
| --- | --- |
Interactive quiz app| [How to create an interactive Python quiz app?](https://pwenker.github.io/quizli/learning_guide/quiz.html)
Command Line Interface | [How to add a CLI to your quiz app?](https://pwenker.github.io/quizli/learning_guide/cli.html)
Documentation | [How to create a slick documentation for your app?](https://pwenker.github.io/quizli/learning_guide/documentation.html)
Publishing | [How to build, manage and publish your Python package to PyPi?](https://pwenker.github.io/quizli/learning_guide/publishing.html)

## :rocket: User Guide

This guide contains usage and reference material for the `quizli` app.

|  | User Guide |
| --- | --- |
CLI Reference | [Usage & reference for `quizli's` CLI](https://pwenker.github.io/quizli/user_guide/cli.html)
Code Reference | [Usage & reference for `quizli's` source code](https://pwenker.github.io/quizli/code_reference/index.html)


## Quickstart

### :package: Installation

Install quizli with [`pip`](https://pip.pypa.io/en/stable/getting-started/):

```console
pip install quizli
```

### :zap: Entrypoint
To get help about `quizli's` commands open your console and type:

```console
quizli --help
```

The same works for subcommands, e.g. :

```console
quizli demos --help
```
