/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.bigquery.sqlgenerator;

import java.util.List;
import liquibase.database.Database;
import liquibase.ext.bigquery.database.BigqueryDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.DeleteGenerator;
import liquibase.statement.core.DeleteStatement;
import liquibase.structure.DatabaseObject;
import liquibase.util.SqlUtil;

public class BigqueryDeleteGenerator
extends DeleteGenerator {
    public int getPriority() {
        return 510;
    }

    public Sql[] generateSql(DeleteStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sql = new StringBuilder("DELETE FROM ").append(database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()));
        if (statement.getWhere() != null) {
            sql.append(" WHERE ").append(SqlUtil.replacePredicatePlaceholders((Database)database, (String)statement.getWhere(), (List)statement.getWhereColumnNames(), (List)statement.getWhereParameters()));
        } else {
            sql.append(" WHERE 1=1");
        }
        return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[]{this.getAffectedTable(statement)})};
    }

    public boolean supports(DeleteStatement statement, Database database) {
        return database instanceof BigqueryDatabase;
    }
}

