/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine.metadata;

import com.simba.googlebigquery.dsi.dataengine.filters.IFilter;
import com.simba.googlebigquery.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.googlebigquery.dsi.dataengine.utilities.DataWrapper;
import com.simba.googlebigquery.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.googlebigquery.googlebigquery.core.BQConnection;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQFunction;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQMetadataSource;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.Map;

public class BQFunctionsMetadataSource
extends BQMetadataSource {
    private boolean m_isFunction = true;

    public BQFunctionsMetadataSource(ILogger iLogger, BQConnection bQConnection, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        super(iLogger, bQConnection, map);
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_filters = new IFilter[5];
        if (null != this.m_restrictions.get((Object)MetadataSourceColumnTag.CATALOG_NAME) && null != this.m_restrictions.get((Object)MetadataSourceColumnTag.SCHEMA_NAME)) {
            this.m_haveAllRestrictions = true;
        }
    }

    public BQFunctionsMetadataSource(ILogger iLogger, BQConnection bQConnection, Map<MetadataSourceColumnTag, String> map, boolean bl) throws ErrorException {
        this(iLogger, bQConnection, map);
        this.m_isFunction = bl;
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.closeCursor();
    }

    @Override
    public void closeCursor() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_hasStartedFunctionsFetch = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        if (null != this.m_cachedException) {
            throw this.m_cachedException;
        }
        BQFunction bQFunction = (BQFunction)this.m_functions.get(this.m_functionIdx);
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(bQFunction.getCatalogName(), dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(bQFunction.getSchemaName(), dataWrapper, l, l2);
            }
            case PROCEDURE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(bQFunction.getFunctionName(), dataWrapper, l, l2);
            }
            case REMARKS: {
                dataWrapper.setNull(12);
                return false;
            }
            case SPECIFIC_NAME: {
                return DSITypeUtilities.outputVarCharStringData(bQFunction.getFunctionName(), dataWrapper, l, l2);
            }
            case PROCEDURE_TYPE: {
                return DSITypeUtilities.outputVarCharStringData(String.valueOf(bQFunction.getReturnType()), dataWrapper, l, l2);
            }
            case NUM_INPUT_PARAMS: 
            case NUM_OUTPUT_PARAMS: 
            case NUM_RESULT_SETS: {
                dataWrapper.setNull(4);
                return false;
            }
        }
        throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.METADATA_FUNCTION_NOT_FOUND_ERR.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return !this.m_hasStartedFunctionsFetch;
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        boolean bl = false;
        try {
            bl = this.moveToNextFunction(this.m_isFunction);
        }
        catch (ErrorException errorException) {
            this.m_cachedException = errorException;
            return true;
        }
        return bl;
    }
}

