/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine;

import com.simba.googlebigquery.dsi.dataengine.impl.DSIEmptyResultSet;
import com.simba.googlebigquery.dsi.dataengine.utilities.ExecutionContext;
import com.simba.googlebigquery.dsi.dataengine.utilities.ExecutionContexts;
import com.simba.googlebigquery.dsi.dataengine.utilities.ParameterMetadata;
import com.simba.googlebigquery.dsi.exceptions.BadDefaultParamException;
import com.simba.googlebigquery.dsi.exceptions.ExecutingException;
import com.simba.googlebigquery.dsi.exceptions.OperationCanceledException;
import com.simba.googlebigquery.dsi.exceptions.ParsingException;
import com.simba.googlebigquery.googlebigquery.client.IBQResponse;
import com.simba.googlebigquery.googlebigquery.core.BQConnection;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.googlebigquery.dataengine.BQAbstractExecutor;
import com.simba.googlebigquery.googlebigquery.dataengine.BQResultSet;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.IWarningListener;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BQLegacySQLExecutor
extends BQAbstractExecutor {
    private static final String REGEX_LIMIT_CLAUSE_PATTERN = "(\\s(?i)limit\\s\\d+$)";

    public BQLegacySQLExecutor(ILogger iLogger, BQConnection bQConnection, List<String> list, boolean bl, boolean bl2) throws ErrorException {
        super(iLogger, bQConnection, list);
        LogUtilities.logFunctionEntrance(iLogger, bQConnection, list.get(0), bl, bl2);
        if (bl) {
            this.m_results.addResultSet(new DSIEmptyResultSet());
        } else {
            this.internalPrepare();
            BQResultSet bQResultSet = new BQResultSet(this.m_logger, this.m_connection, (IBQResponse)this.m_preparedQueryInfoList.get(0), true);
            this.m_results.addResultSet(bQResultSet);
        }
    }

    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws BadDefaultParamException, ParsingException, ExecutingException, OperationCanceledException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, executionContexts, iWarningListener);
        Iterator<ExecutionContext> iterator = executionContexts.contextIterator();
        this.m_results.getResults().clear();
        while (iterator.hasNext()) {
            iterator.next();
            this.m_executedQueryInfoList = new Vector();
            for (String string : this.m_queries) {
                this.m_useDestinationTable = this.m_connectionOptions.m_largeResultsEnabled;
                boolean bl = !this.m_isParameterized && !this.m_useDestinationTable;
                super.execute(string, bl);
            }
            this.m_results.addResultSet(new BQResultSet(this.m_logger, this.m_connection, (IBQResponse)this.m_executedQueryInfoList.get(0), false));
        }
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_parameters;
    }

    @Override
    public void internalPrepare() throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)this.m_queries.get(0));
        Pattern pattern = Pattern.compile(REGEX_LIMIT_CLAUSE_PATTERN);
        Matcher matcher = pattern.matcher(stringBuilder);
        if (matcher.find()) {
            int n = matcher.start();
            stringBuilder.replace(n, stringBuilder.length(), " limit 0");
        } else {
            stringBuilder.append(" limit 0");
        }
        this.m_preparedQueryInfoList = new Vector();
        this.m_preparedQueryInfoList.add(this.m_client.executeQuery(stringBuilder.toString(), this.m_bqParameters, this.m_connectionOptions.m_projectId, this.m_connectionOptions.m_defaultDataSet, this.m_connectionOptions.m_allowLargeResults, BQConnectionOptions.QueryDialect.BIG_QUERY, this.m_connectionOptions.m_KMSKeyName, false, this.m_isCancelledFlagLock, this.m_isCancelledFlag));
    }
}

