/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import com.google.api.core.InternalApi;
import com.google.api.gax.batching.AutoValue_DynamicFlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

@InternalApi(value="For google-cloud-java client use only")
public abstract class DynamicFlowControlSettings {
    @Nullable
    public abstract Long getInitialOutstandingElementCount();

    @Nullable
    public abstract Long getInitialOutstandingRequestBytes();

    @Nullable
    public abstract Long getMaxOutstandingElementCount();

    @Nullable
    public abstract Long getMaxOutstandingRequestBytes();

    @Nullable
    public abstract Long getMinOutstandingElementCount();

    @Nullable
    public abstract Long getMinOutstandingRequestBytes();

    public abstract FlowController.LimitExceededBehavior getLimitExceededBehavior();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_DynamicFlowControlSettings.Builder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block);
    }

    public static abstract class Builder {
        public abstract Builder setInitialOutstandingElementCount(Long var1);

        public abstract Builder setInitialOutstandingRequestBytes(Long var1);

        public abstract Builder setMaxOutstandingElementCount(Long var1);

        public abstract Builder setMaxOutstandingRequestBytes(Long var1);

        public abstract Builder setMinOutstandingElementCount(Long var1);

        public abstract Builder setMinOutstandingRequestBytes(Long var1);

        public abstract Builder setLimitExceededBehavior(FlowController.LimitExceededBehavior var1);

        abstract DynamicFlowControlSettings autoBuild();

        public DynamicFlowControlSettings build() {
            DynamicFlowControlSettings settings = this.autoBuild();
            this.verifyElementCountSettings(settings);
            this.verifyRequestBytesSettings(settings);
            return settings;
        }

        private void verifyElementCountSettings(DynamicFlowControlSettings settings) {
            boolean isEnabled;
            boolean bl = isEnabled = settings.getInitialOutstandingElementCount() != null || settings.getMinOutstandingElementCount() != null || settings.getMaxOutstandingElementCount() != null;
            if (!isEnabled) {
                return;
            }
            Preconditions.checkState((settings.getInitialOutstandingElementCount() != null && settings.getMinOutstandingElementCount() != null && settings.getMaxOutstandingElementCount() != null ? 1 : 0) != 0, (Object)"Throttling on element count is disabled by default. To enable this setting, minOutstandingElementCount, initialOutstandingElementCount, and maxOutstandingElementCount must all be set.");
            Preconditions.checkState((settings.getMinOutstandingElementCount() > 0L && settings.getInitialOutstandingElementCount() <= settings.getMaxOutstandingElementCount() && settings.getInitialOutstandingElementCount() >= settings.getMinOutstandingElementCount() ? 1 : 0) != 0, (Object)"If throttling on element count is set, minOutstandingElementCount must be greater than 0, and minOutstandingElementCount <= initialOutstandingElementCount <= maxOutstandingElementCount");
        }

        private void verifyRequestBytesSettings(DynamicFlowControlSettings settings) {
            boolean isEnabled;
            boolean bl = isEnabled = settings.getInitialOutstandingRequestBytes() != null || settings.getMinOutstandingRequestBytes() != null || settings.getMaxOutstandingRequestBytes() != null;
            if (!isEnabled) {
                return;
            }
            Preconditions.checkState((settings.getInitialOutstandingRequestBytes() != null && settings.getMinOutstandingRequestBytes() != null && settings.getMaxOutstandingRequestBytes() != null ? 1 : 0) != 0, (Object)"Throttling on number of bytes is disabled by default. To enable this setting, minOutstandingRequestBytes, initialOutstandingRequestBytes, and maxOutstandingRequestBytes must all be set");
            Preconditions.checkState((settings.getMinOutstandingRequestBytes() > 0L && settings.getInitialOutstandingRequestBytes() <= settings.getMaxOutstandingRequestBytes() && settings.getInitialOutstandingRequestBytes() >= settings.getMinOutstandingRequestBytes() ? 1 : 0) != 0, (Object)"If throttling on number of bytes is set, minOutstandingRequestBytes must be greater than 0, and minOutstandingRequestBytes <= initialOutstandingRequestBytes <= maxOutstandingRequestBytes");
        }
    }
}

