/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client;

import com.amazon.redshift.client.messages.inbound.KeyData;
import com.amazon.redshift.client.messages.outbound.CancelRequest;
import com.amazon.redshift.client.messages.outbound.SSLRequest;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslContext;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;

public class ClientHandler
extends ChannelDuplexHandler {
    private SSLEngine m_sslEngine = null;
    private final IPGLogger m_log;
    private ByteBuf m_sslRequestInBuf;
    public ByteBuf m_cancelMessageInBuf;
    private KeyData m_keyData;

    public ClientHandler(SSLEngine sSLEngine, IPGLogger iPGLogger, String string, int n, SslContext sslContext, KeyData keyData) {
        LogUtilities.logFunctionEntrance(iPGLogger, new Object[0]);
        this.m_sslEngine = sSLEngine;
        this.m_log = iPGLogger;
        this.m_keyData = keyData;
        if (null != sSLEngine) {
            this.m_sslRequestInBuf = null;
            SSLRequest sSLRequest = new SSLRequest(this.m_log);
            this.m_sslRequestInBuf = ByteBufAllocator.DEFAULT.buffer();
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(sSLRequest.getSize() + 1);
            sSLRequest.serialize(byteBuffer);
            byteBuffer.flip();
            this.m_sslRequestInBuf.writeBytes(byteBuffer);
            byteBuffer.clear();
        }
    }

    public void write(final ChannelHandlerContext channelHandlerContext, Object object) throws SSLException {
        CancelRequest cancelRequest = new CancelRequest(this.m_keyData, this.m_log);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(cancelRequest.getSize() + 1);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(cancelRequest.getSize() + 1);
        cancelRequest.serialize(byteBuffer);
        byteBuffer.flip();
        this.m_cancelMessageInBuf = ByteBufAllocator.DEFAULT.buffer();
        if (this.m_log.isEnabled()) {
            LogUtilities.logDebug("Cancel message is encrypted and prepared to be sent to the server.", (ILogger)this.m_log);
        }
        if (null != this.m_sslEngine) {
            this.m_sslEngine.wrap(byteBuffer, byteBuffer2);
            this.m_cancelMessageInBuf.writeBytes(byteBuffer2);
        } else {
            this.m_cancelMessageInBuf.writeBytes(byteBuffer);
        }
        final ChannelFuture channelFuture = channelHandlerContext.writeAndFlush(this.m_cancelMessageInBuf);
        ChannelFutureListener channelFutureListener = new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture channelFuture2) {
                assert (channelFuture.equals(channelFuture2));
                if (ClientHandler.this.m_log.isEnabled()) {
                    LogUtilities.logDebug("Writing the encrypted cancel message to the ChannelHandlerContext object is done.", (ILogger)ClientHandler.this.m_log);
                }
                channelHandlerContext.close();
                channelHandlerContext.channel().close();
            }
        };
        channelFuture.addListener(channelFutureListener);
    }

    @Override
    public void channelActive(final ChannelHandlerContext channelHandlerContext) throws Exception {
        channelHandlerContext.fireChannelActive();
        if (null != this.m_sslEngine) {
            final ChannelFuture channelFuture = channelHandlerContext.writeAndFlush(this.m_sslRequestInBuf);
            channelFuture.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture channelFuture2) {
                    assert (channelFuture.equals(channelFuture2));
                    channelHandlerContext.read();
                    if (ClientHandler.this.m_log.isEnabled()) {
                        LogUtilities.logDebug("Writing the SSL request to the ChannelHandlerContext object is done.", (ILogger)ClientHandler.this.m_log);
                    }
                }
            });
        } else {
            CancelRequest cancelRequest = new CancelRequest(this.m_keyData, this.m_log);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(cancelRequest.getSize() + 1);
            cancelRequest.serialize(byteBuffer);
            byteBuffer.flip();
            this.m_cancelMessageInBuf = ByteBufAllocator.DEFAULT.buffer();
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("Cancel message is prepared to be sent to the server without encryption.", (ILogger)this.m_log);
            }
            this.m_cancelMessageInBuf.writeBytes(byteBuffer);
            final ChannelFuture channelFuture = channelHandlerContext.writeAndFlush(this.m_cancelMessageInBuf);
            ChannelFutureListener channelFutureListener = new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture channelFuture2) {
                    assert (channelFuture.equals(channelFuture2));
                    if (ClientHandler.this.m_log.isEnabled()) {
                        LogUtilities.logDebug("Writing the unencrypted cancel message to the ChannelHandlerContext object is done.", (ILogger)ClientHandler.this.m_log);
                    }
                    channelHandlerContext.close();
                    channelHandlerContext.channel().close();
                }
            };
            channelFuture.addListener(channelFutureListener);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        throwable.printStackTrace();
        channelHandlerContext.close();
    }
}

