# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FusionAuthWebhookArgs', 'FusionAuthWebhook']

@pulumi.input_type
class FusionAuthWebhookArgs:
    def __init__(__self__, *,
                 connect_timeout: pulumi.Input[int],
                 read_timeout: pulumi.Input[int],
                 url: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 events_enabled: Optional[pulumi.Input['FusionAuthWebhookEventsEnabledArgs']] = None,
                 global_: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 http_authentication_password: Optional[pulumi.Input[str]] = None,
                 http_authentication_username: Optional[pulumi.Input[str]] = None,
                 ssl_certificate: Optional[pulumi.Input[str]] = None,
                 tenant_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a FusionAuthWebhook resource.
        :param pulumi.Input[int] connect_timeout: The connection timeout in milliseconds used when FusionAuth sends events to the Webhook.
        :param pulumi.Input[int] read_timeout: The read timeout in milliseconds used when FusionAuth sends events to the Webhook.
        :param pulumi.Input[str] url: The fully qualified URL of the Webhook’s endpoint that will accept the event requests from FusionAuth.
        :param pulumi.Input[str] description: A description of the Webhook. This is used for display purposes only.
        :param pulumi.Input['FusionAuthWebhookEventsEnabledArgs'] events_enabled: A mapping for the events that are enabled for this Webhook.
        :param pulumi.Input[bool] global_: Whether or not this Webhook is used for all events or just for specific Applications.
        :param pulumi.Input[Mapping[str, Any]] headers: An object that contains headers that are sent as part of the HTTP request for the events.
        :param pulumi.Input[str] http_authentication_password: The HTTP basic authentication password that is sent as part of the HTTP request for the events.
        :param pulumi.Input[str] http_authentication_username: -(Optional) The HTTP basic authentication username that is sent as part of the HTTP request for the events.
        :param pulumi.Input[str] ssl_certificate: An SSL certificate in PEM format that is used to establish the a SSL (TLS specifically) connection to the Webhook.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tenant_ids: The Ids of the tenants that this Webhook should be associated with. If no Ids are specified and the global field is false, this Webhook will not be used.
        """
        pulumi.set(__self__, "connect_timeout", connect_timeout)
        pulumi.set(__self__, "read_timeout", read_timeout)
        pulumi.set(__self__, "url", url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if events_enabled is not None:
            pulumi.set(__self__, "events_enabled", events_enabled)
        if global_ is not None:
            pulumi.set(__self__, "global_", global_)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if http_authentication_password is not None:
            pulumi.set(__self__, "http_authentication_password", http_authentication_password)
        if http_authentication_username is not None:
            pulumi.set(__self__, "http_authentication_username", http_authentication_username)
        if ssl_certificate is not None:
            pulumi.set(__self__, "ssl_certificate", ssl_certificate)
        if tenant_ids is not None:
            pulumi.set(__self__, "tenant_ids", tenant_ids)

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> pulumi.Input[int]:
        """
        The connection timeout in milliseconds used when FusionAuth sends events to the Webhook.
        """
        return pulumi.get(self, "connect_timeout")

    @connect_timeout.setter
    def connect_timeout(self, value: pulumi.Input[int]):
        pulumi.set(self, "connect_timeout", value)

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> pulumi.Input[int]:
        """
        The read timeout in milliseconds used when FusionAuth sends events to the Webhook.
        """
        return pulumi.get(self, "read_timeout")

    @read_timeout.setter
    def read_timeout(self, value: pulumi.Input[int]):
        pulumi.set(self, "read_timeout", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The fully qualified URL of the Webhook’s endpoint that will accept the event requests from FusionAuth.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the Webhook. This is used for display purposes only.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eventsEnabled")
    def events_enabled(self) -> Optional[pulumi.Input['FusionAuthWebhookEventsEnabledArgs']]:
        """
        A mapping for the events that are enabled for this Webhook.
        """
        return pulumi.get(self, "events_enabled")

    @events_enabled.setter
    def events_enabled(self, value: Optional[pulumi.Input['FusionAuthWebhookEventsEnabledArgs']]):
        pulumi.set(self, "events_enabled", value)

    @property
    @pulumi.getter(name="global")
    def global_(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this Webhook is used for all events or just for specific Applications.
        """
        return pulumi.get(self, "global_")

    @global_.setter
    def global_(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "global_", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An object that contains headers that are sent as part of the HTTP request for the events.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="httpAuthenticationPassword")
    def http_authentication_password(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP basic authentication password that is sent as part of the HTTP request for the events.
        """
        return pulumi.get(self, "http_authentication_password")

    @http_authentication_password.setter
    def http_authentication_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_authentication_password", value)

    @property
    @pulumi.getter(name="httpAuthenticationUsername")
    def http_authentication_username(self) -> Optional[pulumi.Input[str]]:
        """
        -(Optional) The HTTP basic authentication username that is sent as part of the HTTP request for the events.
        """
        return pulumi.get(self, "http_authentication_username")

    @http_authentication_username.setter
    def http_authentication_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_authentication_username", value)

    @property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        An SSL certificate in PEM format that is used to establish the a SSL (TLS specifically) connection to the Webhook.
        """
        return pulumi.get(self, "ssl_certificate")

    @ssl_certificate.setter
    def ssl_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_certificate", value)

    @property
    @pulumi.getter(name="tenantIds")
    def tenant_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The Ids of the tenants that this Webhook should be associated with. If no Ids are specified and the global field is false, this Webhook will not be used.
        """
        return pulumi.get(self, "tenant_ids")

    @tenant_ids.setter
    def tenant_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tenant_ids", value)


@pulumi.input_type
class _FusionAuthWebhookState:
    def __init__(__self__, *,
                 connect_timeout: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 events_enabled: Optional[pulumi.Input['FusionAuthWebhookEventsEnabledArgs']] = None,
                 global_: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 http_authentication_password: Optional[pulumi.Input[str]] = None,
                 http_authentication_username: Optional[pulumi.Input[str]] = None,
                 read_timeout: Optional[pulumi.Input[int]] = None,
                 ssl_certificate: Optional[pulumi.Input[str]] = None,
                 tenant_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FusionAuthWebhook resources.
        :param pulumi.Input[int] connect_timeout: The connection timeout in milliseconds used when FusionAuth sends events to the Webhook.
        :param pulumi.Input[str] description: A description of the Webhook. This is used for display purposes only.
        :param pulumi.Input['FusionAuthWebhookEventsEnabledArgs'] events_enabled: A mapping for the events that are enabled for this Webhook.
        :param pulumi.Input[bool] global_: Whether or not this Webhook is used for all events or just for specific Applications.
        :param pulumi.Input[Mapping[str, Any]] headers: An object that contains headers that are sent as part of the HTTP request for the events.
        :param pulumi.Input[str] http_authentication_password: The HTTP basic authentication password that is sent as part of the HTTP request for the events.
        :param pulumi.Input[str] http_authentication_username: -(Optional) The HTTP basic authentication username that is sent as part of the HTTP request for the events.
        :param pulumi.Input[int] read_timeout: The read timeout in milliseconds used when FusionAuth sends events to the Webhook.
        :param pulumi.Input[str] ssl_certificate: An SSL certificate in PEM format that is used to establish the a SSL (TLS specifically) connection to the Webhook.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tenant_ids: The Ids of the tenants that this Webhook should be associated with. If no Ids are specified and the global field is false, this Webhook will not be used.
        :param pulumi.Input[str] url: The fully qualified URL of the Webhook’s endpoint that will accept the event requests from FusionAuth.
        """
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if events_enabled is not None:
            pulumi.set(__self__, "events_enabled", events_enabled)
        if global_ is not None:
            pulumi.set(__self__, "global_", global_)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if http_authentication_password is not None:
            pulumi.set(__self__, "http_authentication_password", http_authentication_password)
        if http_authentication_username is not None:
            pulumi.set(__self__, "http_authentication_username", http_authentication_username)
        if read_timeout is not None:
            pulumi.set(__self__, "read_timeout", read_timeout)
        if ssl_certificate is not None:
            pulumi.set(__self__, "ssl_certificate", ssl_certificate)
        if tenant_ids is not None:
            pulumi.set(__self__, "tenant_ids", tenant_ids)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The connection timeout in milliseconds used when FusionAuth sends events to the Webhook.
        """
        return pulumi.get(self, "connect_timeout")

    @connect_timeout.setter
    def connect_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connect_timeout", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the Webhook. This is used for display purposes only.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eventsEnabled")
    def events_enabled(self) -> Optional[pulumi.Input['FusionAuthWebhookEventsEnabledArgs']]:
        """
        A mapping for the events that are enabled for this Webhook.
        """
        return pulumi.get(self, "events_enabled")

    @events_enabled.setter
    def events_enabled(self, value: Optional[pulumi.Input['FusionAuthWebhookEventsEnabledArgs']]):
        pulumi.set(self, "events_enabled", value)

    @property
    @pulumi.getter(name="global")
    def global_(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this Webhook is used for all events or just for specific Applications.
        """
        return pulumi.get(self, "global_")

    @global_.setter
    def global_(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "global_", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An object that contains headers that are sent as part of the HTTP request for the events.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="httpAuthenticationPassword")
    def http_authentication_password(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP basic authentication password that is sent as part of the HTTP request for the events.
        """
        return pulumi.get(self, "http_authentication_password")

    @http_authentication_password.setter
    def http_authentication_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_authentication_password", value)

    @property
    @pulumi.getter(name="httpAuthenticationUsername")
    def http_authentication_username(self) -> Optional[pulumi.Input[str]]:
        """
        -(Optional) The HTTP basic authentication username that is sent as part of the HTTP request for the events.
        """
        return pulumi.get(self, "http_authentication_username")

    @http_authentication_username.setter
    def http_authentication_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_authentication_username", value)

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The read timeout in milliseconds used when FusionAuth sends events to the Webhook.
        """
        return pulumi.get(self, "read_timeout")

    @read_timeout.setter
    def read_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "read_timeout", value)

    @property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        An SSL certificate in PEM format that is used to establish the a SSL (TLS specifically) connection to the Webhook.
        """
        return pulumi.get(self, "ssl_certificate")

    @ssl_certificate.setter
    def ssl_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_certificate", value)

    @property
    @pulumi.getter(name="tenantIds")
    def tenant_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The Ids of the tenants that this Webhook should be associated with. If no Ids are specified and the global field is false, this Webhook will not be used.
        """
        return pulumi.get(self, "tenant_ids")

    @tenant_ids.setter
    def tenant_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tenant_ids", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified URL of the Webhook’s endpoint that will accept the event requests from FusionAuth.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


class FusionAuthWebhook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connect_timeout: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 events_enabled: Optional[pulumi.Input[pulumi.InputType['FusionAuthWebhookEventsEnabledArgs']]] = None,
                 global_: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 http_authentication_password: Optional[pulumi.Input[str]] = None,
                 http_authentication_username: Optional[pulumi.Input[str]] = None,
                 read_timeout: Optional[pulumi.Input[int]] = None,
                 ssl_certificate: Optional[pulumi.Input[str]] = None,
                 tenant_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Webhook Resource

        A FusionAuth Webhook is intended to consume JSON events emitted by FusionAuth. Creating a Webhook allows you to tell FusionAuth where you would like to receive these JSON events.

        [Webhooks API](https://fusionauth.io/docs/v1/tech/apis/webhooks)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        example = fusionauth.FusionAuthWebhook("example",
            tenant_ids=[
                "00000000-0000-0000-0000-000000000003",
                fusionauth_tenant["example"]["id"],
            ],
            connect_timeout=1000,
            description="The standard game Webhook",
            events_enabled=fusionauth.FusionAuthWebhookEventsEnabledArgs(
                user_create=True,
                user_delete=False,
            ),
            global_=False,
            headers={
                "foo": "bar",
                "bar": "baz",
            },
            http_authentication_password="password",
            http_authentication_username="username",
            read_timeout=2000,
            ssl_certificate="  -----BEGIN CERTIFICATE-----\\\\nMIIDUjCCArugAwIBAgIJANZCTNN98L9ZMA0GCSqGSIb3DQEBBQUAMHoxCzAJBgNV\\\\nBAYTAlVTMQswCQYDVQQIEwJDTzEPMA0GA1UEBxMGZGVudmVyMQ8wDQYDVQQKEwZz\\\\nZXRoLXMxCjAIBgNVBAsTAXMxDjAMBgNVBAMTBWludmVyMSAwHgYJKoZIhvcNAQkB\\\\nFhFzamZkZkBsc2tkamZjLmNvbTAeFw0xNDA0MDkyMTA2MDdaFw0xNDA1MDkyMTA2\\\\nMDdaMHoxCzAJBgNVBAYTAlVTMQswCQYDVQQIEwJDTzEPMA0GA1UEBxMGZGVudmVy\\\\nMQ8wDQYDVQQKEwZzZXRoLXMxCjAIBgNVBAsTAXMxDjAMBgNVBAMTBWludmVyMSAw\\\\nHgYJKoZIhvcNAQkBFhFzamZkZkBsc2tkamZjLmNvbTCBnzANBgkqhkiG9w0BAQEF\\\\nAAOBjQAwgYkCgYEAxnQBqyuYvjUE4aFQ6vVZU5RqHmy3KiTg2NcxELIlZztUTK3a\\\\nVFbJoBB4ixHXCCYslujthILyBjgT3F+IhSpPAcrlu8O5LVPaPCysh/SNrGNwH4lq\\\\neiW9Z5WAhRO/nG7NZNa0USPHAei6b9Sv9PxuKCY+GJfAIwlO4/bltIH06/kCAwEA\\\\nAaOB3zCB3DAdBgNVHQ4EFgQUU4SqJEFm1zW+CcLxmLlARrqtMN0wgawGA1UdIwSB\\\\npDCBoYAUU4SqJEFm1zW+CcLxmLlARrqtMN2hfqR8MHoxCzAJBgNVBAYTAlVTMQsw\\\\nCQYDVQQIEwJDTzEPMA0GA1UEBxMGZGVudmVyMQ8wDQYDVQQKEwZzZXRoLXMxCjAI\\\\nBgNVBAsTAXMxDjAMBgNVBAMTBWludmVyMSAwHgYJKoZIhvcNAQkBFhFzamZkZkBs\\\\nc2tkamZjLmNvbYIJANZCTNN98L9ZMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEF\\\\nBQADgYEAY/cJsi3w6R4hF4PzAXLhGOg1tzTDYvol3w024WoehJur+qM0AY6UqtoJ\\\\nneCq9af32IKbbOKkoaok+t1+/tylQVF/0FXMTKepxaMbG22vr4TmN3idPUYYbPfW\\\\n5GkF7Hh96BjerrtiUPGuBZL50HoLZ5aR5oZUMAu7TXhOFp+vZp8=\\\\n-----END CERTIFICATE-----\\n",
            url="http://mygameserver.local:7001/fusionauth-webhook")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] connect_timeout: The connection timeout in milliseconds used when FusionAuth sends events to the Webhook.
        :param pulumi.Input[str] description: A description of the Webhook. This is used for display purposes only.
        :param pulumi.Input[pulumi.InputType['FusionAuthWebhookEventsEnabledArgs']] events_enabled: A mapping for the events that are enabled for this Webhook.
        :param pulumi.Input[bool] global_: Whether or not this Webhook is used for all events or just for specific Applications.
        :param pulumi.Input[Mapping[str, Any]] headers: An object that contains headers that are sent as part of the HTTP request for the events.
        :param pulumi.Input[str] http_authentication_password: The HTTP basic authentication password that is sent as part of the HTTP request for the events.
        :param pulumi.Input[str] http_authentication_username: -(Optional) The HTTP basic authentication username that is sent as part of the HTTP request for the events.
        :param pulumi.Input[int] read_timeout: The read timeout in milliseconds used when FusionAuth sends events to the Webhook.
        :param pulumi.Input[str] ssl_certificate: An SSL certificate in PEM format that is used to establish the a SSL (TLS specifically) connection to the Webhook.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tenant_ids: The Ids of the tenants that this Webhook should be associated with. If no Ids are specified and the global field is false, this Webhook will not be used.
        :param pulumi.Input[str] url: The fully qualified URL of the Webhook’s endpoint that will accept the event requests from FusionAuth.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionAuthWebhookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Webhook Resource

        A FusionAuth Webhook is intended to consume JSON events emitted by FusionAuth. Creating a Webhook allows you to tell FusionAuth where you would like to receive these JSON events.

        [Webhooks API](https://fusionauth.io/docs/v1/tech/apis/webhooks)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        example = fusionauth.FusionAuthWebhook("example",
            tenant_ids=[
                "00000000-0000-0000-0000-000000000003",
                fusionauth_tenant["example"]["id"],
            ],
            connect_timeout=1000,
            description="The standard game Webhook",
            events_enabled=fusionauth.FusionAuthWebhookEventsEnabledArgs(
                user_create=True,
                user_delete=False,
            ),
            global_=False,
            headers={
                "foo": "bar",
                "bar": "baz",
            },
            http_authentication_password="password",
            http_authentication_username="username",
            read_timeout=2000,
            ssl_certificate="  -----BEGIN CERTIFICATE-----\\\\nMIIDUjCCArugAwIBAgIJANZCTNN98L9ZMA0GCSqGSIb3DQEBBQUAMHoxCzAJBgNV\\\\nBAYTAlVTMQswCQYDVQQIEwJDTzEPMA0GA1UEBxMGZGVudmVyMQ8wDQYDVQQKEwZz\\\\nZXRoLXMxCjAIBgNVBAsTAXMxDjAMBgNVBAMTBWludmVyMSAwHgYJKoZIhvcNAQkB\\\\nFhFzamZkZkBsc2tkamZjLmNvbTAeFw0xNDA0MDkyMTA2MDdaFw0xNDA1MDkyMTA2\\\\nMDdaMHoxCzAJBgNVBAYTAlVTMQswCQYDVQQIEwJDTzEPMA0GA1UEBxMGZGVudmVy\\\\nMQ8wDQYDVQQKEwZzZXRoLXMxCjAIBgNVBAsTAXMxDjAMBgNVBAMTBWludmVyMSAw\\\\nHgYJKoZIhvcNAQkBFhFzamZkZkBsc2tkamZjLmNvbTCBnzANBgkqhkiG9w0BAQEF\\\\nAAOBjQAwgYkCgYEAxnQBqyuYvjUE4aFQ6vVZU5RqHmy3KiTg2NcxELIlZztUTK3a\\\\nVFbJoBB4ixHXCCYslujthILyBjgT3F+IhSpPAcrlu8O5LVPaPCysh/SNrGNwH4lq\\\\neiW9Z5WAhRO/nG7NZNa0USPHAei6b9Sv9PxuKCY+GJfAIwlO4/bltIH06/kCAwEA\\\\nAaOB3zCB3DAdBgNVHQ4EFgQUU4SqJEFm1zW+CcLxmLlARrqtMN0wgawGA1UdIwSB\\\\npDCBoYAUU4SqJEFm1zW+CcLxmLlARrqtMN2hfqR8MHoxCzAJBgNVBAYTAlVTMQsw\\\\nCQYDVQQIEwJDTzEPMA0GA1UEBxMGZGVudmVyMQ8wDQYDVQQKEwZzZXRoLXMxCjAI\\\\nBgNVBAsTAXMxDjAMBgNVBAMTBWludmVyMSAwHgYJKoZIhvcNAQkBFhFzamZkZkBs\\\\nc2tkamZjLmNvbYIJANZCTNN98L9ZMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEF\\\\nBQADgYEAY/cJsi3w6R4hF4PzAXLhGOg1tzTDYvol3w024WoehJur+qM0AY6UqtoJ\\\\nneCq9af32IKbbOKkoaok+t1+/tylQVF/0FXMTKepxaMbG22vr4TmN3idPUYYbPfW\\\\n5GkF7Hh96BjerrtiUPGuBZL50HoLZ5aR5oZUMAu7TXhOFp+vZp8=\\\\n-----END CERTIFICATE-----\\n",
            url="http://mygameserver.local:7001/fusionauth-webhook")
        ```

        :param str resource_name: The name of the resource.
        :param FusionAuthWebhookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthWebhookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connect_timeout: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 events_enabled: Optional[pulumi.Input[pulumi.InputType['FusionAuthWebhookEventsEnabledArgs']]] = None,
                 global_: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 http_authentication_password: Optional[pulumi.Input[str]] = None,
                 http_authentication_username: Optional[pulumi.Input[str]] = None,
                 read_timeout: Optional[pulumi.Input[int]] = None,
                 ssl_certificate: Optional[pulumi.Input[str]] = None,
                 tenant_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthWebhookArgs.__new__(FusionAuthWebhookArgs)

            if connect_timeout is None and not opts.urn:
                raise TypeError("Missing required property 'connect_timeout'")
            __props__.__dict__["connect_timeout"] = connect_timeout
            __props__.__dict__["description"] = description
            __props__.__dict__["events_enabled"] = events_enabled
            __props__.__dict__["global_"] = global_
            __props__.__dict__["headers"] = headers
            __props__.__dict__["http_authentication_password"] = http_authentication_password
            __props__.__dict__["http_authentication_username"] = http_authentication_username
            if read_timeout is None and not opts.urn:
                raise TypeError("Missing required property 'read_timeout'")
            __props__.__dict__["read_timeout"] = read_timeout
            __props__.__dict__["ssl_certificate"] = ssl_certificate
            __props__.__dict__["tenant_ids"] = tenant_ids
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
        super(FusionAuthWebhook, __self__).__init__(
            'fusionauth:index/fusionAuthWebhook:FusionAuthWebhook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connect_timeout: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            events_enabled: Optional[pulumi.Input[pulumi.InputType['FusionAuthWebhookEventsEnabledArgs']]] = None,
            global_: Optional[pulumi.Input[bool]] = None,
            headers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            http_authentication_password: Optional[pulumi.Input[str]] = None,
            http_authentication_username: Optional[pulumi.Input[str]] = None,
            read_timeout: Optional[pulumi.Input[int]] = None,
            ssl_certificate: Optional[pulumi.Input[str]] = None,
            tenant_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            url: Optional[pulumi.Input[str]] = None) -> 'FusionAuthWebhook':
        """
        Get an existing FusionAuthWebhook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] connect_timeout: The connection timeout in milliseconds used when FusionAuth sends events to the Webhook.
        :param pulumi.Input[str] description: A description of the Webhook. This is used for display purposes only.
        :param pulumi.Input[pulumi.InputType['FusionAuthWebhookEventsEnabledArgs']] events_enabled: A mapping for the events that are enabled for this Webhook.
        :param pulumi.Input[bool] global_: Whether or not this Webhook is used for all events or just for specific Applications.
        :param pulumi.Input[Mapping[str, Any]] headers: An object that contains headers that are sent as part of the HTTP request for the events.
        :param pulumi.Input[str] http_authentication_password: The HTTP basic authentication password that is sent as part of the HTTP request for the events.
        :param pulumi.Input[str] http_authentication_username: -(Optional) The HTTP basic authentication username that is sent as part of the HTTP request for the events.
        :param pulumi.Input[int] read_timeout: The read timeout in milliseconds used when FusionAuth sends events to the Webhook.
        :param pulumi.Input[str] ssl_certificate: An SSL certificate in PEM format that is used to establish the a SSL (TLS specifically) connection to the Webhook.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tenant_ids: The Ids of the tenants that this Webhook should be associated with. If no Ids are specified and the global field is false, this Webhook will not be used.
        :param pulumi.Input[str] url: The fully qualified URL of the Webhook’s endpoint that will accept the event requests from FusionAuth.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthWebhookState.__new__(_FusionAuthWebhookState)

        __props__.__dict__["connect_timeout"] = connect_timeout
        __props__.__dict__["description"] = description
        __props__.__dict__["events_enabled"] = events_enabled
        __props__.__dict__["global_"] = global_
        __props__.__dict__["headers"] = headers
        __props__.__dict__["http_authentication_password"] = http_authentication_password
        __props__.__dict__["http_authentication_username"] = http_authentication_username
        __props__.__dict__["read_timeout"] = read_timeout
        __props__.__dict__["ssl_certificate"] = ssl_certificate
        __props__.__dict__["tenant_ids"] = tenant_ids
        __props__.__dict__["url"] = url
        return FusionAuthWebhook(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> pulumi.Output[int]:
        """
        The connection timeout in milliseconds used when FusionAuth sends events to the Webhook.
        """
        return pulumi.get(self, "connect_timeout")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the Webhook. This is used for display purposes only.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventsEnabled")
    def events_enabled(self) -> pulumi.Output[Optional['outputs.FusionAuthWebhookEventsEnabled']]:
        """
        A mapping for the events that are enabled for this Webhook.
        """
        return pulumi.get(self, "events_enabled")

    @property
    @pulumi.getter(name="global")
    def global_(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not this Webhook is used for all events or just for specific Applications.
        """
        return pulumi.get(self, "global_")

    @property
    @pulumi.getter
    def headers(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        An object that contains headers that are sent as part of the HTTP request for the events.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="httpAuthenticationPassword")
    def http_authentication_password(self) -> pulumi.Output[Optional[str]]:
        """
        The HTTP basic authentication password that is sent as part of the HTTP request for the events.
        """
        return pulumi.get(self, "http_authentication_password")

    @property
    @pulumi.getter(name="httpAuthenticationUsername")
    def http_authentication_username(self) -> pulumi.Output[Optional[str]]:
        """
        -(Optional) The HTTP basic authentication username that is sent as part of the HTTP request for the events.
        """
        return pulumi.get(self, "http_authentication_username")

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> pulumi.Output[int]:
        """
        The read timeout in milliseconds used when FusionAuth sends events to the Webhook.
        """
        return pulumi.get(self, "read_timeout")

    @property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> pulumi.Output[Optional[str]]:
        """
        An SSL certificate in PEM format that is used to establish the a SSL (TLS specifically) connection to the Webhook.
        """
        return pulumi.get(self, "ssl_certificate")

    @property
    @pulumi.getter(name="tenantIds")
    def tenant_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The Ids of the tenants that this Webhook should be associated with. If no Ids are specified and the global field is false, this Webhook will not be used.
        """
        return pulumi.get(self, "tenant_ids")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The fully qualified URL of the Webhook’s endpoint that will accept the event requests from FusionAuth.
        """
        return pulumi.get(self, "url")

