# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['FusionAuthImportedKeyArgs', 'FusionAuthImportedKey']

@pulumi.input_type
class FusionAuthImportedKeyArgs:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input[str]] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 kid: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 secret: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FusionAuthImportedKey resource.
        :param pulumi.Input[str] algorithm: The algorithm used to encrypt the Key. The following values represent algorithms supported by FusionAuth:
        :param pulumi.Input[str] certificate: The certificate to import. The publicKey will be extracted from the certificate.
        :param pulumi.Input[str] key_id: The Id to use for the new key. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] kid: The Key identifier 'kid'.
        :param pulumi.Input[str] name: The name of the Key.
        :param pulumi.Input[str] private_key: The Key private key. Optional if importing an RSA or EC key. If the key is only to be used for token validation, only a public key is necessary and this field may be omitted.
        :param pulumi.Input[str] public_key: "The Key public key. Required if importing an RSA or EC key and a certificate is not provided."
        :param pulumi.Input[str] secret: The Key secret. This field is required if importing an HMAC key type.
        :param pulumi.Input[str] type: The Key type. This field is required if importing an HMAC key type, or if importing a public key / private key pair. The possible values are:
               - `EC`
               - `RSA`
               - `HMAC`
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if kid is not None:
            pulumi.set(__self__, "kid", kid)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        The algorithm used to encrypt the Key. The following values represent algorithms supported by FusionAuth:
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate to import. The publicKey will be extracted from the certificate.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id to use for the new key. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter
    def kid(self) -> Optional[pulumi.Input[str]]:
        """
        The Key identifier 'kid'.
        """
        return pulumi.get(self, "kid")

    @kid.setter
    def kid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kid", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        The Key private key. Optional if importing an RSA or EC key. If the key is only to be used for token validation, only a public key is necessary and this field may be omitted.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        "The Key public key. Required if importing an RSA or EC key and a certificate is not provided."
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[str]]:
        """
        The Key secret. This field is required if importing an HMAC key type.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The Key type. This field is required if importing an HMAC key type, or if importing a public key / private key pair. The possible values are:
        - `EC`
        - `RSA`
        - `HMAC`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _FusionAuthImportedKeyState:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input[str]] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 kid: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 secret: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FusionAuthImportedKey resources.
        :param pulumi.Input[str] algorithm: The algorithm used to encrypt the Key. The following values represent algorithms supported by FusionAuth:
        :param pulumi.Input[str] certificate: The certificate to import. The publicKey will be extracted from the certificate.
        :param pulumi.Input[str] key_id: The Id to use for the new key. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] kid: The Key identifier 'kid'.
        :param pulumi.Input[str] name: The name of the Key.
        :param pulumi.Input[str] private_key: The Key private key. Optional if importing an RSA or EC key. If the key is only to be used for token validation, only a public key is necessary and this field may be omitted.
        :param pulumi.Input[str] public_key: "The Key public key. Required if importing an RSA or EC key and a certificate is not provided."
        :param pulumi.Input[str] secret: The Key secret. This field is required if importing an HMAC key type.
        :param pulumi.Input[str] type: The Key type. This field is required if importing an HMAC key type, or if importing a public key / private key pair. The possible values are:
               - `EC`
               - `RSA`
               - `HMAC`
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if kid is not None:
            pulumi.set(__self__, "kid", kid)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        The algorithm used to encrypt the Key. The following values represent algorithms supported by FusionAuth:
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate to import. The publicKey will be extracted from the certificate.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id to use for the new key. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter
    def kid(self) -> Optional[pulumi.Input[str]]:
        """
        The Key identifier 'kid'.
        """
        return pulumi.get(self, "kid")

    @kid.setter
    def kid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kid", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        The Key private key. Optional if importing an RSA or EC key. If the key is only to be used for token validation, only a public key is necessary and this field may be omitted.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        "The Key public key. Required if importing an RSA or EC key and a certificate is not provided."
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[str]]:
        """
        The Key secret. This field is required if importing an HMAC key type.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The Key type. This field is required if importing an HMAC key type, or if importing a public key / private key pair. The possible values are:
        - `EC`
        - `RSA`
        - `HMAC`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class FusionAuthImportedKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[str]] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 kid: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 secret: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Imported Key Resource

        Cryptographic keys are used in signing and verifying JWTs and verifying responses for third party identity providers. It is more likely you will interact with keys using the FusionAuth UI in the Key Master menu.

        [Keys API](https://fusionauth.io/docs/v1/tech/apis/keys)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        name = fusionauth.FusionAuthImportedKey("name",
            kid="8675309",
            private_key=(lambda path: open(path).read())("./AuthKey_8675309.p8"))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] algorithm: The algorithm used to encrypt the Key. The following values represent algorithms supported by FusionAuth:
        :param pulumi.Input[str] certificate: The certificate to import. The publicKey will be extracted from the certificate.
        :param pulumi.Input[str] key_id: The Id to use for the new key. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] kid: The Key identifier 'kid'.
        :param pulumi.Input[str] name: The name of the Key.
        :param pulumi.Input[str] private_key: The Key private key. Optional if importing an RSA or EC key. If the key is only to be used for token validation, only a public key is necessary and this field may be omitted.
        :param pulumi.Input[str] public_key: "The Key public key. Required if importing an RSA or EC key and a certificate is not provided."
        :param pulumi.Input[str] secret: The Key secret. This field is required if importing an HMAC key type.
        :param pulumi.Input[str] type: The Key type. This field is required if importing an HMAC key type, or if importing a public key / private key pair. The possible values are:
               - `EC`
               - `RSA`
               - `HMAC`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FusionAuthImportedKeyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Imported Key Resource

        Cryptographic keys are used in signing and verifying JWTs and verifying responses for third party identity providers. It is more likely you will interact with keys using the FusionAuth UI in the Key Master menu.

        [Keys API](https://fusionauth.io/docs/v1/tech/apis/keys)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        name = fusionauth.FusionAuthImportedKey("name",
            kid="8675309",
            private_key=(lambda path: open(path).read())("./AuthKey_8675309.p8"))
        ```

        :param str resource_name: The name of the resource.
        :param FusionAuthImportedKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthImportedKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[str]] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 kid: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 secret: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthImportedKeyArgs.__new__(FusionAuthImportedKeyArgs)

            __props__.__dict__["algorithm"] = algorithm
            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["key_id"] = key_id
            __props__.__dict__["kid"] = kid
            __props__.__dict__["name"] = name
            __props__.__dict__["private_key"] = private_key
            __props__.__dict__["public_key"] = public_key
            __props__.__dict__["secret"] = secret
            __props__.__dict__["type"] = type
        super(FusionAuthImportedKey, __self__).__init__(
            'fusionauth:index/fusionAuthImportedKey:FusionAuthImportedKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            algorithm: Optional[pulumi.Input[str]] = None,
            certificate: Optional[pulumi.Input[str]] = None,
            key_id: Optional[pulumi.Input[str]] = None,
            kid: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            private_key: Optional[pulumi.Input[str]] = None,
            public_key: Optional[pulumi.Input[str]] = None,
            secret: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'FusionAuthImportedKey':
        """
        Get an existing FusionAuthImportedKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] algorithm: The algorithm used to encrypt the Key. The following values represent algorithms supported by FusionAuth:
        :param pulumi.Input[str] certificate: The certificate to import. The publicKey will be extracted from the certificate.
        :param pulumi.Input[str] key_id: The Id to use for the new key. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] kid: The Key identifier 'kid'.
        :param pulumi.Input[str] name: The name of the Key.
        :param pulumi.Input[str] private_key: The Key private key. Optional if importing an RSA or EC key. If the key is only to be used for token validation, only a public key is necessary and this field may be omitted.
        :param pulumi.Input[str] public_key: "The Key public key. Required if importing an RSA or EC key and a certificate is not provided."
        :param pulumi.Input[str] secret: The Key secret. This field is required if importing an HMAC key type.
        :param pulumi.Input[str] type: The Key type. This field is required if importing an HMAC key type, or if importing a public key / private key pair. The possible values are:
               - `EC`
               - `RSA`
               - `HMAC`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthImportedKeyState.__new__(_FusionAuthImportedKeyState)

        __props__.__dict__["algorithm"] = algorithm
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["kid"] = kid
        __props__.__dict__["name"] = name
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["public_key"] = public_key
        __props__.__dict__["secret"] = secret
        __props__.__dict__["type"] = type
        return FusionAuthImportedKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def algorithm(self) -> pulumi.Output[str]:
        """
        The algorithm used to encrypt the Key. The following values represent algorithms supported by FusionAuth:
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[str]:
        """
        The certificate to import. The publicKey will be extracted from the certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Id to use for the new key. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter
    def kid(self) -> pulumi.Output[str]:
        """
        The Key identifier 'kid'.
        """
        return pulumi.get(self, "kid")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Key.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[Optional[str]]:
        """
        The Key private key. Optional if importing an RSA or EC key. If the key is only to be used for token validation, only a public key is necessary and this field may be omitted.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[str]:
        """
        "The Key public key. Required if importing an RSA or EC key and a certificate is not provided."
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Output[Optional[str]]:
        """
        The Key secret. This field is required if importing an HMAC key type.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The Key type. This field is required if importing an HMAC key type, or if importing a public key / private key pair. The possible values are:
        - `EC`
        - `RSA`
        - `HMAC`
        """
        return pulumi.get(self, "type")

