# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FusionAuthIdpAppleArgs', 'FusionAuthIdpApple']

@pulumi.input_type
class FusionAuthIdpAppleArgs:
    def __init__(__self__, *,
                 button_text: pulumi.Input[str],
                 key_id: pulumi.Input[str],
                 services_id: pulumi.Input[str],
                 team_id: pulumi.Input[str],
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpAppleApplicationConfigurationArgs']]]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpAppleTenantConfigurationArgs']]]] = None):
        """
        The set of arguments for constructing a FusionAuthIdpApple resource.
        :param pulumi.Input[str] button_text: The top-level button text to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[str] key_id: The unique Id of the private key downloaded from Apple and imported into Key Master that will be used to sign the client secret.
        :param pulumi.Input[str] services_id: The unique Id of the private key downloaded from Apple and imported into Key Master that will be used to sign the client secret.
        :param pulumi.Input[str] team_id: The Apple App ID Prefix, or Team ID found in your Apple Developer Account which has been configured for Sign in with Apple.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpAppleApplicationConfigurationArgs']]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        :param pulumi.Input[str] scope: The top-level space separated scope that you are requesting from Apple.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpAppleTenantConfigurationArgs']]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        pulumi.set(__self__, "button_text", button_text)
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "services_id", services_id)
        pulumi.set(__self__, "team_id", team_id)
        if application_configurations is not None:
            pulumi.set(__self__, "application_configurations", application_configurations)
        if debug is not None:
            pulumi.set(__self__, "debug", debug)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if lambda_reconcile_id is not None:
            pulumi.set(__self__, "lambda_reconcile_id", lambda_reconcile_id)
        if linking_strategy is not None:
            pulumi.set(__self__, "linking_strategy", linking_strategy)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if tenant_configurations is not None:
            pulumi.set(__self__, "tenant_configurations", tenant_configurations)

    @property
    @pulumi.getter(name="buttonText")
    def button_text(self) -> pulumi.Input[str]:
        """
        The top-level button text to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_text")

    @button_text.setter
    def button_text(self, value: pulumi.Input[str]):
        pulumi.set(self, "button_text", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[str]:
        """
        The unique Id of the private key downloaded from Apple and imported into Key Master that will be used to sign the client secret.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="servicesId")
    def services_id(self) -> pulumi.Input[str]:
        """
        The unique Id of the private key downloaded from Apple and imported into Key Master that will be used to sign the client secret.
        """
        return pulumi.get(self, "services_id")

    @services_id.setter
    def services_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "services_id", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Input[str]:
        """
        The Apple App ID Prefix, or Team ID found in your Apple Developer Account which has been configured for Sign in with Apple.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "team_id", value)

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpAppleApplicationConfigurationArgs']]]]:
        """
        The configuration for each Application that the identity provider is enabled for.
        """
        return pulumi.get(self, "application_configurations")

    @application_configurations.setter
    def application_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpAppleApplicationConfigurationArgs']]]]):
        pulumi.set(self, "application_configurations", value)

    @property
    @pulumi.getter
    def debug(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        """
        return pulumi.get(self, "debug")

    @debug.setter
    def debug(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "debug", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if this provider is enabled. If it is false then it will be disabled globally.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="lambdaReconcileId")
    def lambda_reconcile_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        """
        return pulumi.get(self, "lambda_reconcile_id")

    @lambda_reconcile_id.setter
    def lambda_reconcile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_reconcile_id", value)

    @property
    @pulumi.getter(name="linkingStrategy")
    def linking_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        """
        return pulumi.get(self, "linking_strategy")

    @linking_strategy.setter
    def linking_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linking_strategy", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level space separated scope that you are requesting from Apple.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="tenantConfigurations")
    def tenant_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpAppleTenantConfigurationArgs']]]]:
        """
        The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        return pulumi.get(self, "tenant_configurations")

    @tenant_configurations.setter
    def tenant_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpAppleTenantConfigurationArgs']]]]):
        pulumi.set(self, "tenant_configurations", value)


@pulumi.input_type
class _FusionAuthIdpAppleState:
    def __init__(__self__, *,
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpAppleApplicationConfigurationArgs']]]] = None,
                 button_text: Optional[pulumi.Input[str]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 services_id: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpAppleTenantConfigurationArgs']]]] = None):
        """
        Input properties used for looking up and filtering FusionAuthIdpApple resources.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpAppleApplicationConfigurationArgs']]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[str] button_text: The top-level button text to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] key_id: The unique Id of the private key downloaded from Apple and imported into Key Master that will be used to sign the client secret.
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        :param pulumi.Input[str] scope: The top-level space separated scope that you are requesting from Apple.
        :param pulumi.Input[str] services_id: The unique Id of the private key downloaded from Apple and imported into Key Master that will be used to sign the client secret.
        :param pulumi.Input[str] team_id: The Apple App ID Prefix, or Team ID found in your Apple Developer Account which has been configured for Sign in with Apple.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpAppleTenantConfigurationArgs']]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        if application_configurations is not None:
            pulumi.set(__self__, "application_configurations", application_configurations)
        if button_text is not None:
            pulumi.set(__self__, "button_text", button_text)
        if debug is not None:
            pulumi.set(__self__, "debug", debug)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if lambda_reconcile_id is not None:
            pulumi.set(__self__, "lambda_reconcile_id", lambda_reconcile_id)
        if linking_strategy is not None:
            pulumi.set(__self__, "linking_strategy", linking_strategy)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if services_id is not None:
            pulumi.set(__self__, "services_id", services_id)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if tenant_configurations is not None:
            pulumi.set(__self__, "tenant_configurations", tenant_configurations)

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpAppleApplicationConfigurationArgs']]]]:
        """
        The configuration for each Application that the identity provider is enabled for.
        """
        return pulumi.get(self, "application_configurations")

    @application_configurations.setter
    def application_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpAppleApplicationConfigurationArgs']]]]):
        pulumi.set(self, "application_configurations", value)

    @property
    @pulumi.getter(name="buttonText")
    def button_text(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level button text to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_text")

    @button_text.setter
    def button_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "button_text", value)

    @property
    @pulumi.getter
    def debug(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        """
        return pulumi.get(self, "debug")

    @debug.setter
    def debug(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "debug", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if this provider is enabled. If it is false then it will be disabled globally.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Id of the private key downloaded from Apple and imported into Key Master that will be used to sign the client secret.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="lambdaReconcileId")
    def lambda_reconcile_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        """
        return pulumi.get(self, "lambda_reconcile_id")

    @lambda_reconcile_id.setter
    def lambda_reconcile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_reconcile_id", value)

    @property
    @pulumi.getter(name="linkingStrategy")
    def linking_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        """
        return pulumi.get(self, "linking_strategy")

    @linking_strategy.setter
    def linking_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linking_strategy", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level space separated scope that you are requesting from Apple.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="servicesId")
    def services_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Id of the private key downloaded from Apple and imported into Key Master that will be used to sign the client secret.
        """
        return pulumi.get(self, "services_id")

    @services_id.setter
    def services_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "services_id", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Apple App ID Prefix, or Team ID found in your Apple Developer Account which has been configured for Sign in with Apple.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)

    @property
    @pulumi.getter(name="tenantConfigurations")
    def tenant_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpAppleTenantConfigurationArgs']]]]:
        """
        The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        return pulumi.get(self, "tenant_configurations")

    @tenant_configurations.setter
    def tenant_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpAppleTenantConfigurationArgs']]]]):
        pulumi.set(self, "tenant_configurations", value)


class FusionAuthIdpApple(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpAppleApplicationConfigurationArgs']]]]] = None,
                 button_text: Optional[pulumi.Input[str]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 services_id: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpAppleTenantConfigurationArgs']]]]] = None,
                 __props__=None):
        """
        ## # Apple Identity Provider Resource

        The Apple identity provider type will use the Sign in with Apple APIs and will provide a Sign with Apple button on FusionAuth’s login page that will either redirect to an Apple sign in page or leverage native controls when using Safari on macOS or iOS. Additionally, this identity provider will call Apples’s /auth/token API to load additional details about the user and store them in FusionAuth.

        FusionAuth will also store the Apple refresh_token that is returned from the /auth/token endpoint in the UserRegistration object inside the tokens Map. This Map stores the tokens from the various identity providers so that you can use them in your application to call their APIs.

        [Apple Identity Providers API](https://fusionauth.io/docs/v1/tech/apis/identity-providers/apple/#create-the-apple-identity-provider)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        apple = fusionauth.FusionAuthIdpApple("apple",
            application_configurations=[fusionauth.FusionAuthIdpAppleApplicationConfigurationArgs(
                application_id="1c212e59-0d0e-6b1a-ad48-f4f92793be32",
                create_registration=True,
                enabled=True,
            )],
            button_text="Sign in with Apple",
            debug=False,
            enabled=True,
            key_id="2f81529c-4d39-4ce2-982e-cf5fbb1325f6",
            scope="email name",
            services_id="com.piedpiper.webapp",
            team_id="R4NQ1P4UEB")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpAppleApplicationConfigurationArgs']]]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[str] button_text: The top-level button text to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] key_id: The unique Id of the private key downloaded from Apple and imported into Key Master that will be used to sign the client secret.
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        :param pulumi.Input[str] scope: The top-level space separated scope that you are requesting from Apple.
        :param pulumi.Input[str] services_id: The unique Id of the private key downloaded from Apple and imported into Key Master that will be used to sign the client secret.
        :param pulumi.Input[str] team_id: The Apple App ID Prefix, or Team ID found in your Apple Developer Account which has been configured for Sign in with Apple.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpAppleTenantConfigurationArgs']]]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionAuthIdpAppleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Apple Identity Provider Resource

        The Apple identity provider type will use the Sign in with Apple APIs and will provide a Sign with Apple button on FusionAuth’s login page that will either redirect to an Apple sign in page or leverage native controls when using Safari on macOS or iOS. Additionally, this identity provider will call Apples’s /auth/token API to load additional details about the user and store them in FusionAuth.

        FusionAuth will also store the Apple refresh_token that is returned from the /auth/token endpoint in the UserRegistration object inside the tokens Map. This Map stores the tokens from the various identity providers so that you can use them in your application to call their APIs.

        [Apple Identity Providers API](https://fusionauth.io/docs/v1/tech/apis/identity-providers/apple/#create-the-apple-identity-provider)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        apple = fusionauth.FusionAuthIdpApple("apple",
            application_configurations=[fusionauth.FusionAuthIdpAppleApplicationConfigurationArgs(
                application_id="1c212e59-0d0e-6b1a-ad48-f4f92793be32",
                create_registration=True,
                enabled=True,
            )],
            button_text="Sign in with Apple",
            debug=False,
            enabled=True,
            key_id="2f81529c-4d39-4ce2-982e-cf5fbb1325f6",
            scope="email name",
            services_id="com.piedpiper.webapp",
            team_id="R4NQ1P4UEB")
        ```

        :param str resource_name: The name of the resource.
        :param FusionAuthIdpAppleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthIdpAppleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpAppleApplicationConfigurationArgs']]]]] = None,
                 button_text: Optional[pulumi.Input[str]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 services_id: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpAppleTenantConfigurationArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthIdpAppleArgs.__new__(FusionAuthIdpAppleArgs)

            __props__.__dict__["application_configurations"] = application_configurations
            if button_text is None and not opts.urn:
                raise TypeError("Missing required property 'button_text'")
            __props__.__dict__["button_text"] = button_text
            __props__.__dict__["debug"] = debug
            __props__.__dict__["enabled"] = enabled
            if key_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_id'")
            __props__.__dict__["key_id"] = key_id
            __props__.__dict__["lambda_reconcile_id"] = lambda_reconcile_id
            __props__.__dict__["linking_strategy"] = linking_strategy
            __props__.__dict__["scope"] = scope
            if services_id is None and not opts.urn:
                raise TypeError("Missing required property 'services_id'")
            __props__.__dict__["services_id"] = services_id
            if team_id is None and not opts.urn:
                raise TypeError("Missing required property 'team_id'")
            __props__.__dict__["team_id"] = team_id
            __props__.__dict__["tenant_configurations"] = tenant_configurations
        super(FusionAuthIdpApple, __self__).__init__(
            'fusionauth:index/fusionAuthIdpApple:FusionAuthIdpApple',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpAppleApplicationConfigurationArgs']]]]] = None,
            button_text: Optional[pulumi.Input[str]] = None,
            debug: Optional[pulumi.Input[bool]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            key_id: Optional[pulumi.Input[str]] = None,
            lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
            linking_strategy: Optional[pulumi.Input[str]] = None,
            scope: Optional[pulumi.Input[str]] = None,
            services_id: Optional[pulumi.Input[str]] = None,
            team_id: Optional[pulumi.Input[str]] = None,
            tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpAppleTenantConfigurationArgs']]]]] = None) -> 'FusionAuthIdpApple':
        """
        Get an existing FusionAuthIdpApple resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpAppleApplicationConfigurationArgs']]]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[str] button_text: The top-level button text to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] key_id: The unique Id of the private key downloaded from Apple and imported into Key Master that will be used to sign the client secret.
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        :param pulumi.Input[str] scope: The top-level space separated scope that you are requesting from Apple.
        :param pulumi.Input[str] services_id: The unique Id of the private key downloaded from Apple and imported into Key Master that will be used to sign the client secret.
        :param pulumi.Input[str] team_id: The Apple App ID Prefix, or Team ID found in your Apple Developer Account which has been configured for Sign in with Apple.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpAppleTenantConfigurationArgs']]]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthIdpAppleState.__new__(_FusionAuthIdpAppleState)

        __props__.__dict__["application_configurations"] = application_configurations
        __props__.__dict__["button_text"] = button_text
        __props__.__dict__["debug"] = debug
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["lambda_reconcile_id"] = lambda_reconcile_id
        __props__.__dict__["linking_strategy"] = linking_strategy
        __props__.__dict__["scope"] = scope
        __props__.__dict__["services_id"] = services_id
        __props__.__dict__["team_id"] = team_id
        __props__.__dict__["tenant_configurations"] = tenant_configurations
        return FusionAuthIdpApple(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.FusionAuthIdpAppleApplicationConfiguration']]]:
        """
        The configuration for each Application that the identity provider is enabled for.
        """
        return pulumi.get(self, "application_configurations")

    @property
    @pulumi.getter(name="buttonText")
    def button_text(self) -> pulumi.Output[str]:
        """
        The top-level button text to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_text")

    @property
    @pulumi.getter
    def debug(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        """
        return pulumi.get(self, "debug")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if this provider is enabled. If it is false then it will be disabled globally.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[str]:
        """
        The unique Id of the private key downloaded from Apple and imported into Key Master that will be used to sign the client secret.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="lambdaReconcileId")
    def lambda_reconcile_id(self) -> pulumi.Output[Optional[str]]:
        """
        The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        """
        return pulumi.get(self, "lambda_reconcile_id")

    @property
    @pulumi.getter(name="linkingStrategy")
    def linking_strategy(self) -> pulumi.Output[str]:
        """
        The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        """
        return pulumi.get(self, "linking_strategy")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[str]]:
        """
        The top-level space separated scope that you are requesting from Apple.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="servicesId")
    def services_id(self) -> pulumi.Output[str]:
        """
        The unique Id of the private key downloaded from Apple and imported into Key Master that will be used to sign the client secret.
        """
        return pulumi.get(self, "services_id")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[str]:
        """
        The Apple App ID Prefix, or Team ID found in your Apple Developer Account which has been configured for Sign in with Apple.
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter(name="tenantConfigurations")
    def tenant_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.FusionAuthIdpAppleTenantConfiguration']]]:
        """
        The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        return pulumi.get(self, "tenant_configurations")

