# Generated by Django 3.2.4 on 2021-06-23 19:26

from django.conf import settings
import django.contrib.gis.db.models.fields
from django.db import migrations, models
import django.db.models.deletion
import django_extensions.db.fields
import rgd.models.mixins
import rgd.utility
import s3_file_field.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Collection',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name='ID'
                    ),
                ),
                ('name', models.CharField(max_length=127)),
            ],
            options={
                'default_related_name': 'collections',
            },
            bases=(models.Model, rgd.models.mixins.PermissionPathMixin),
        ),
        migrations.CreateModel(
            name='SpatialEntry',
            fields=[
                ('spatial_id', models.AutoField(primary_key=True, serialize=False)),
                ('acquisition_date', models.DateTimeField(blank=True, default=None, null=True)),
                ('footprint', django.contrib.gis.db.models.fields.GeometryField(srid=4326)),
                ('outline', django.contrib.gis.db.models.fields.GeometryField(srid=4326)),
                (
                    'instrumentation',
                    models.CharField(
                        blank=True,
                        help_text='The instrumentation used to acquire these data.',
                        max_length=100,
                        null=True,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='WhitelistedEmail',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name='ID'
                    ),
                ),
                ('email', models.EmailField(max_length=254)),
            ],
        ),
        migrations.CreateModel(
            name='CollectionPermission',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name='ID'
                    ),
                ),
                (
                    'role',
                    models.SmallIntegerField(
                        choices=[(1, 'Reader'), (2, 'Owner')],
                        db_index=True,
                        default=1,
                        help_text='A "reader" can view assets in this collection. An "owner" can additionally add/remove other users, set their permissions, delete the collection, and add/remove other files.',
                    ),
                ),
                (
                    'collection',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='collection_permissions',
                        to='rgd.collection',
                    ),
                ),
                (
                    'user',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='collection_permissions',
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                'default_related_name': 'collection_permissions',
            },
        ),
        migrations.CreateModel(
            name='ChecksumFile',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name='ID'
                    ),
                ),
                ('failure_reason', models.TextField(null=True)),
                (
                    'status',
                    models.CharField(
                        choices=[
                            ('created', 'Created but not queued'),
                            ('queued', 'Queued for processing'),
                            ('running', 'Processing'),
                            ('failed', 'Failed'),
                            ('success', 'Succeeded'),
                        ],
                        default='created',
                        max_length=20,
                    ),
                ),
                (
                    'created',
                    django_extensions.db.fields.CreationDateTimeField(
                        auto_now_add=True, verbose_name='created'
                    ),
                ),
                (
                    'modified',
                    django_extensions.db.fields.ModificationDateTimeField(
                        auto_now=True, verbose_name='modified'
                    ),
                ),
                ('name', models.CharField(blank=True, max_length=1000)),
                ('description', models.TextField(blank=True, null=True)),
                ('checksum', models.CharField(max_length=128)),
                ('validate_checksum', models.BooleanField(default=False)),
                ('last_validation', models.BooleanField(default=True)),
                ('type', models.IntegerField(choices=[(1, 'FileField'), (2, 'URL')], default=1)),
                (
                    'file',
                    s3_file_field.fields.S3FileField(
                        blank=True, null=True, upload_to=rgd.utility.uuid_prefix_filename
                    ),
                ),
                ('url', models.TextField(blank=True, null=True)),
                (
                    'collection',
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name='checksumfiles',
                        related_query_name='checksumfiles',
                        to='rgd.collection',
                    ),
                ),
            ],
            bases=(models.Model, rgd.models.mixins.PermissionPathMixin),
        ),
        migrations.CreateModel(
            name='SpatialAsset',
            fields=[
                (
                    'spatialentry_ptr',
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to='rgd.spatialentry',
                    ),
                ),
                (
                    'created',
                    django_extensions.db.fields.CreationDateTimeField(
                        auto_now_add=True, verbose_name='created'
                    ),
                ),
                (
                    'modified',
                    django_extensions.db.fields.ModificationDateTimeField(
                        auto_now=True, verbose_name='modified'
                    ),
                ),
                ('files', models.ManyToManyField(to='rgd.ChecksumFile')),
            ],
            options={
                'get_latest_by': 'modified',
                'abstract': False,
            },
            bases=('rgd.spatialentry', models.Model, rgd.models.mixins.PermissionPathMixin),
        ),
        migrations.AddConstraint(
            model_name='collectionpermission',
            constraint=models.UniqueConstraint(fields=('collection', 'user'), name='unique_user'),
        ),
        migrations.AddConstraint(
            model_name='checksumfile',
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(
                        ('file__regex', '.+'),
                        ('type', 1),
                        models.Q(('url__in', ['', None]), ('url__isnull', True), _connector='OR'),
                    ),
                    models.Q(
                        ('type', 2),
                        models.Q(('url__isnull', False), ('url__regex', '.+')),
                        models.Q(('file__in', ['', None]), ('file__isnull', True), _connector='OR'),
                    ),
                    _connector='OR',
                ),
                name='rgd_checksumfile_file_source_value_matches_type',
            ),
        ),
    ]
