# List of permitted AST toplevel statements. In IMPORTs (e.g. sgr import
# and Splitfile IMPORT commands), we only allow read-only SELECTs. In Splitfile
# SQL commands, we also allow users to use a bunch of writeable DML and DDL.

IMPORT_SQL_PERMITTED_STATEMENTS = ["RawStmt", "SelectStmt"]
SPLITFILE_SQL_PERMITTED_STATEMENTS = IMPORT_SQL_PERMITTED_STATEMENTS + [
    "InsertStmt",
    "UpdateStmt",
    "DeleteStmt",
    "CreateStmt",
    "CreateTableAsStmt",
    "AlterTableStmt",
    "DropStmt",
]


# List of table names/views/indexes that are located in pg_catalog. This is always
# available to SQL statements even if the search_path doesn't have pg_catalog in it.
# Generating this automatically requires a connection to the engine, adding a dependency
# on that to the sql module, so we hardcode this.

# Generated by
# sgr sql "SELECT relname FROM pg_catalog.pg_class c LEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace WHERE n.nspname = 'pg_catalog'" -a > blacklist.txt

PG_CATALOG_TABLES = {
    "pg_aggregate",
    "pg_aggregate_fnoid_index",
    "pg_am",
    "pg_am_name_index",
    "pg_am_oid_index",
    "pg_amop",
    "pg_amop_fam_strat_index",
    "pg_amop_oid_index",
    "pg_amop_opr_fam_index",
    "pg_amproc",
    "pg_amproc_fam_proc_index",
    "pg_amproc_oid_index",
    "pg_attrdef",
    "pg_attrdef_adrelid_adnum_index",
    "pg_attrdef_oid_index",
    "pg_attribute",
    "pg_attribute_relid_attnam_index",
    "pg_attribute_relid_attnum_index",
    "pg_auth_members",
    "pg_auth_members_member_role_index",
    "pg_auth_members_role_member_index",
    "pg_authid",
    "pg_authid_oid_index",
    "pg_authid_rolname_index",
    "pg_available_extension_versions",
    "pg_available_extensions",
    "pg_cast",
    "pg_cast_oid_index",
    "pg_cast_source_target_index",
    "pg_class",
    "pg_class_oid_index",
    "pg_class_relname_nsp_index",
    "pg_class_tblspc_relfilenode_index",
    "pg_collation",
    "pg_collation_name_enc_nsp_index",
    "pg_collation_oid_index",
    "pg_config",
    "pg_constraint",
    "pg_constraint_conname_nsp_index",
    "pg_constraint_conparentid_index",
    "pg_constraint_conrelid_contypid_conname_index",
    "pg_constraint_contypid_index",
    "pg_constraint_oid_index",
    "pg_conversion",
    "pg_conversion_default_index",
    "pg_conversion_name_nsp_index",
    "pg_conversion_oid_index",
    "pg_cursors",
    "pg_database",
    "pg_database_datname_index",
    "pg_database_oid_index",
    "pg_db_role_setting",
    "pg_db_role_setting_databaseid_rol_index",
    "pg_default_acl",
    "pg_default_acl_oid_index",
    "pg_default_acl_role_nsp_obj_index",
    "pg_depend",
    "pg_depend_depender_index",
    "pg_depend_reference_index",
    "pg_description",
    "pg_description_o_c_o_index",
    "pg_enum",
    "pg_enum_oid_index",
    "pg_enum_typid_label_index",
    "pg_enum_typid_sortorder_index",
    "pg_event_trigger",
    "pg_event_trigger_evtname_index",
    "pg_event_trigger_oid_index",
    "pg_extension",
    "pg_extension_name_index",
    "pg_extension_oid_index",
    "pg_file_settings",
    "pg_foreign_data_wrapper",
    "pg_foreign_data_wrapper_name_index",
    "pg_foreign_data_wrapper_oid_index",
    "pg_foreign_server",
    "pg_foreign_server_name_index",
    "pg_foreign_server_oid_index",
    "pg_foreign_table",
    "pg_foreign_table_relid_index",
    "pg_group",
    "pg_hba_file_rules",
    "pg_index",
    "pg_index_indexrelid_index",
    "pg_index_indrelid_index",
    "pg_indexes",
    "pg_inherits",
    "pg_inherits_parent_index",
    "pg_inherits_relid_seqno_index",
    "pg_init_privs",
    "pg_init_privs_o_c_o_index",
    "pg_language",
    "pg_language_name_index",
    "pg_language_oid_index",
    "pg_largeobject",
    "pg_largeobject_loid_pn_index",
    "pg_largeobject_metadata",
    "pg_largeobject_metadata_oid_index",
    "pg_locks",
    "pg_matviews",
    "pg_namespace",
    "pg_namespace_nspname_index",
    "pg_namespace_oid_index",
    "pg_opclass",
    "pg_opclass_am_name_nsp_index",
    "pg_opclass_oid_index",
    "pg_operator",
    "pg_operator_oid_index",
    "pg_operator_oprname_l_r_n_index",
    "pg_opfamily",
    "pg_opfamily_am_name_nsp_index",
    "pg_opfamily_oid_index",
    "pg_partitioned_table",
    "pg_partitioned_table_partrelid_index",
    "pg_pltemplate",
    "pg_pltemplate_name_index",
    "pg_policies",
    "pg_policy",
    "pg_policy_oid_index",
    "pg_policy_polrelid_polname_index",
    "pg_prepared_statements",
    "pg_prepared_xacts",
    "pg_proc",
    "pg_proc_oid_index",
    "pg_proc_proname_args_nsp_index",
    "pg_publication",
    "pg_publication_oid_index",
    "pg_publication_pubname_index",
    "pg_publication_rel",
    "pg_publication_rel_oid_index",
    "pg_publication_rel_prrelid_prpubid_index",
    "pg_publication_tables",
    "pg_range",
    "pg_range_rngtypid_index",
    "pg_replication_origin",
    "pg_replication_origin_roiident_index",
    "pg_replication_origin_roname_index",
    "pg_replication_origin_status",
    "pg_replication_slots",
    "pg_rewrite",
    "pg_rewrite_oid_index",
    "pg_rewrite_rel_rulename_index",
    "pg_roles",
    "pg_rules",
    "pg_seclabel",
    "pg_seclabel_object_index",
    "pg_seclabels",
    "pg_sequence",
    "pg_sequence_seqrelid_index",
    "pg_sequences",
    "pg_settings",
    "pg_shadow",
    "pg_shdepend",
    "pg_shdepend_depender_index",
    "pg_shdepend_reference_index",
    "pg_shdescription",
    "pg_shdescription_o_c_index",
    "pg_shseclabel",
    "pg_shseclabel_object_index",
    "pg_stat_activity",
    "pg_stat_all_indexes",
    "pg_stat_all_tables",
    "pg_stat_archiver",
    "pg_stat_bgwriter",
    "pg_stat_database",
    "pg_stat_database_conflicts",
    "pg_stat_gssapi",
    "pg_stat_progress_cluster",
    "pg_stat_progress_create_index",
    "pg_stat_progress_vacuum",
    "pg_stat_replication",
    "pg_stat_ssl",
    "pg_stat_subscription",
    "pg_stat_sys_indexes",
    "pg_stat_sys_tables",
    "pg_stat_user_functions",
    "pg_stat_user_indexes",
    "pg_stat_user_tables",
    "pg_stat_wal_receiver",
    "pg_stat_xact_all_tables",
    "pg_stat_xact_sys_tables",
    "pg_stat_xact_user_functions",
    "pg_stat_xact_user_tables",
    "pg_statio_all_indexes",
    "pg_statio_all_sequences",
    "pg_statio_all_tables",
    "pg_statio_sys_indexes",
    "pg_statio_sys_sequences",
    "pg_statio_sys_tables",
    "pg_statio_user_indexes",
    "pg_statio_user_sequences",
    "pg_statio_user_tables",
    "pg_statistic",
    "pg_statistic_ext",
    "pg_statistic_ext_data",
    "pg_statistic_ext_data_stxoid_index",
    "pg_statistic_ext_name_index",
    "pg_statistic_ext_oid_index",
    "pg_statistic_ext_relid_index",
    "pg_statistic_relid_att_inh_index",
    "pg_stats",
    "pg_stats_ext",
    "pg_subscription",
    "pg_subscription_oid_index",
    "pg_subscription_rel",
    "pg_subscription_rel_srrelid_srsubid_index",
    "pg_subscription_subname_index",
    "pg_tables",
    "pg_tablespace",
    "pg_tablespace_oid_index",
    "pg_tablespace_spcname_index",
    "pg_timezone_abbrevs",
    "pg_timezone_names",
    "pg_transform",
    "pg_transform_oid_index",
    "pg_transform_type_lang_index",
    "pg_trigger",
    "pg_trigger_oid_index",
    "pg_trigger_tgconstraint_index",
    "pg_trigger_tgrelid_tgname_index",
    "pg_ts_config",
    "pg_ts_config_cfgname_index",
    "pg_ts_config_map",
    "pg_ts_config_map_index",
    "pg_ts_config_oid_index",
    "pg_ts_dict",
    "pg_ts_dict_dictname_index",
    "pg_ts_dict_oid_index",
    "pg_ts_parser",
    "pg_ts_parser_oid_index",
    "pg_ts_parser_prsname_index",
    "pg_ts_template",
    "pg_ts_template_oid_index",
    "pg_ts_template_tmplname_index",
    "pg_type",
    "pg_type_oid_index",
    "pg_type_typname_nsp_index",
    "pg_user",
    "pg_user_mapping",
    "pg_user_mapping_oid_index",
    "pg_user_mapping_user_server_index",
    "pg_user_mappings",
    "pg_views",
}
